/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.common;

import java.util.Enumeration;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.corpus_tools.pepper.common.CorpusDesc;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.eclipse.emf.common.util.URI;

public class StepDesc {
    private MODULE_TYPE moduleType = null;
    private String name = null;
    private String version = null;
    private CorpusDesc corpusDesc = null;
    private Properties props = null;

    public MODULE_TYPE getModuleType() {
        return this.moduleType;
    }

    public synchronized void setModuleType(MODULE_TYPE moduleType) {
        this.moduleType = moduleType;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public synchronized void setVersion(String version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorpusDesc getCorpusDesc() {
        if (this.corpusDesc == null) {
            StepDesc stepDesc = this;
            synchronized (stepDesc) {
                if (this.corpusDesc == null) {
                    this.corpusDesc = new CorpusDesc();
                }
            }
        }
        return this.corpusDesc;
    }

    public synchronized void setCorpusDesc(CorpusDesc corpusDesc) {
        this.corpusDesc = corpusDesc;
    }

    public Properties getProps() {
        return this.props;
    }

    public synchronized void setProps(Properties props) {
        this.props = props;
    }

    public void toXML(XMLStreamWriter writer) {
        if (writer != null) {
            try {
                URI path;
                String formatVersion;
                String formatName;
                writer.writeStartElement("step");
                if (this.getModuleType() != null) {
                    writer.writeAttribute("type", this.getModuleType().toString());
                }
                if (this.getName() != null) {
                    writer.writeAttribute("moduleName", this.getName());
                }
                if (this.getVersion() != null) {
                    writer.writeAttribute("moduleVersion", this.getVersion());
                }
                if ((formatName = this.getCorpusDesc().getFormatDesc().getFormatName()) != null) {
                    writer.writeAttribute("formatName", formatName);
                }
                if ((formatVersion = this.getCorpusDesc().getFormatDesc().getFormatVersion()) != null) {
                    writer.writeAttribute("formatVersion", formatVersion);
                }
                if ((path = this.getCorpusDesc().getCorpusPath()) != null) {
                    writer.writeAttribute("path", path.toString());
                }
                if (this.getProps() != null) {
                    writer.writeStartElement("customization");
                    Enumeration<Object> keys = this.getProps().keys();
                    while (keys.hasMoreElements()) {
                        String name = keys.nextElement().toString();
                        String value = this.getProps().getProperty(name);
                        writer.writeStartElement("property");
                        writer.writeAttribute("name", name);
                        writer.writeCharacters(value);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new PepperFWException("Cannot marshall StepDesc.", e);
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.getModuleType() != null) {
            str.append(this.getModuleType().toString());
        } else {
            str.append("UNKNOWN_STEP");
        }
        str.append("(");
        if (this.getName() != null) {
            str.append(this.getName() != null ? this.getName() : "");
            str.append(this.getVersion() != null ? ", " + this.getVersion() : "");
        } else if (this.getCorpusDesc().getFormatDesc() != null) {
            str.append("format: ");
            str.append(this.getCorpusDesc().getFormatDesc().getFormatName() != null ? this.getCorpusDesc().getFormatDesc().getFormatName() : "");
            str.append(",");
            str.append(this.getCorpusDesc().getFormatDesc().getFormatVersion() != null ? this.getCorpusDesc().getFormatDesc().getFormatVersion() : "");
        }
        str.append(")");
        return str.toString();
    }
}

