/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.core.DocumentBus;
import org.corpus_tools.pepper.core.PepperJobImpl;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.exceptions.PepperInActionException;
import org.corpus_tools.pepper.impl.BeforeAfterAction;
import org.corpus_tools.pepper.modules.DocumentController;
import org.corpus_tools.pepper.modules.ModuleController;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleControllerImpl
implements ModuleController {
    private static final Logger logger = LoggerFactory.getLogger(ModuleController.class);
    private Logger mLogger = LoggerFactory.getLogger(ModuleController.class);
    protected String id = null;
    protected PepperModule pepperModule;
    private PepperJobImpl job = null;
    private DocumentBus inputDocumentBus = null;
    private DocumentBus outputDocumentBus = null;
    protected volatile SCorpusGraph sCorpusGraph = null;
    protected ExecutorService executor = null;
    protected ReentrantLock busyLock = null;
    private HashSet<DocumentController> controllList = null;

    public ModuleControllerImpl(String id) {
        if (id == null) {
            throw new PepperFWException("Cannot create an instance of PepperModuleController, because the passed identifier is null.");
        }
        if (id.isEmpty()) {
            throw new PepperFWException("Cannot create an instance of PepperModuleController, because the passed identifier is empty.");
        }
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PepperModule getPepperModule() {
        return this.pepperModule;
    }

    @Override
    public void setPepperModule(PepperModule newPepperModule) {
        this.setPepperModule_basic(newPepperModule);
        newPepperModule.setPepperModuleController_basic(this);
        this.mLogger = LoggerFactory.getLogger((String)this.getPepperModule().getName());
    }

    @Override
    public void setPepperModule_basic(PepperModule newPepperModule) {
        if (newPepperModule == null) {
            throw new PepperFWException("Cannot set an empty PepperModule object to module controller.");
        }
        this.pepperModule = newPepperModule;
    }

    @Override
    public PepperJobImpl getJob() {
        return this.job;
    }

    @Override
    public void setJob(PepperJobImpl job) {
        this.setJob_basic(job);
    }

    @Override
    public void setJob_basic(PepperJobImpl job) {
        this.job = job;
    }

    @Override
    public DocumentBus getInputDocumentBus() {
        return this.inputDocumentBus;
    }

    @Override
    public void setInputDocumentBus(DocumentBus inputDocumentBus) {
        this.inputDocumentBus = inputDocumentBus;
    }

    @Override
    public DocumentBus getOutputDocumentBus() {
        return this.outputDocumentBus;
    }

    @Override
    public void setOutputDocumentBus(DocumentBus outputDocumentBus) {
        this.outputDocumentBus = outputDocumentBus;
    }

    @Override
    public SCorpusGraph getCorpusGraph() {
        return this.sCorpusGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getExecutor() {
        if (this.executor == null) {
            ModuleControllerImpl moduleControllerImpl = this;
            synchronized (moduleControllerImpl) {
                if (this.executor == null) {
                    this.executor = Executors.newSingleThreadExecutor();
                }
            }
        }
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Future<?> importCorpusStructure(SCorpusGraph sCorpusGraph) {
        if (sCorpusGraph == null) {
            throw new PepperFWException("Cannot import corpus structure, because the passed SCorpusGraph object was null.");
        }
        if (this.getPepperModule() == null) {
            throw new PepperFWException("Cannot start import of corpus structure, because the contained Pepper module is null.");
        }
        if (!(this.getPepperModule() instanceof PepperImporter)) {
            throw new PepperFWException("Cannot start import of corpus structure, because the contained Pepper module '" + this.getId() + "' is not of type '" + (Object)((Object)MODULE_TYPE.IMPORTER) + "'.");
        }
        if (((PepperImporter)this.getPepperModule()).getCorpusDesc() == null) {
            throw new PepperFWException("Cannot start import of corpus structure, because the corpus description of Pepper module '" + this.getId() + "' is not set. ");
        }
        if (!this.getBusyLock().tryLock()) {
            throw new PepperInActionException("Cannot start importing corpus structure, since this module controller currently imports a corpus structure.");
        }
        this.sCorpusGraph = sCorpusGraph;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ((PepperImporter)ModuleControllerImpl.this.getPepperModule()).importCorpusStructure(ModuleControllerImpl.this.getCorpusGraph());
                ModuleControllerImpl.this.mLogger.debug("[{}] corpus structure imported. ", (Object)(ModuleControllerImpl.this.getPepperModule() != null ? ModuleControllerImpl.this.getPepperModule().getName() : " EMPTY "));
            }
        };
        if (!this.getBusyLock().tryLock()) {
            throw new PepperInActionException("cannot import corpus structure, because module controller '" + this.getId() + "' currently is busy with another process.");
        }
        this.getBusyLock().lock();
        Future<?> future = null;
        try {
            future = executor.submit(task);
        }
        finally {
            this.getBusyLock().unlock();
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Future<?> processDocumentStructures() {
        if (this.getPepperModule() == null) {
            throw new PepperFWException("Cannot start imort corpus structure, because the contained Pepper module is null.");
        }
        if (!this.getBusyLock().tryLock()) {
            throw new PepperInActionException("Cannot start importing corpus structure, since this module controller currently imports a corpus structure.");
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                BeforeAfterAction action = new BeforeAfterAction(ModuleControllerImpl.this.getPepperModule());
                action.before(ModuleControllerImpl.this.getCorpusGraph());
                ModuleControllerImpl.this.getPepperModule().start();
                if (ModuleControllerImpl.this.getControllList().size() != 0) {
                    throw new PepperModuleException(ModuleControllerImpl.this.getPepperModule(), "Some documents are still in the processing queue by module '" + ModuleControllerImpl.this.getPepperModule().getName() + "' and neither set to '" + (Object)((Object)DOCUMENT_STATUS.COMPLETED) + "', '" + (Object)((Object)DOCUMENT_STATUS.DELETED) + "' or '" + (Object)((Object)DOCUMENT_STATUS.FAILED) + "'. Remaining documents are: " + ModuleControllerImpl.this.getControllList());
                }
                ModuleControllerImpl.this.getOutputDocumentBus().finish(ModuleControllerImpl.this.getPepperModule().getModuleController().getId());
                ModuleControllerImpl.this.mLogger.debug("[{}] completed processing of documents and corpora. ", (Object)(ModuleControllerImpl.this.getPepperModule() != null ? ModuleControllerImpl.this.getPepperModule().getName() : " EMPTY "));
                action.after(ModuleControllerImpl.this.getCorpusGraph());
            }
        };
        if (!this.getBusyLock().tryLock()) {
            throw new PepperInActionException("cannot import document structure, because module controller '" + this.getId() + "' currently is busy with another process.");
        }
        this.getBusyLock().lock();
        Future<?> future = null;
        try {
            future = executor.submit(task);
        }
        finally {
            this.getBusyLock().unlock();
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReentrantLock getBusyLock() {
        if (this.busyLock == null) {
            ModuleControllerImpl moduleControllerImpl = this;
            synchronized (moduleControllerImpl) {
                if (this.busyLock == null) {
                    this.busyLock = new ReentrantLock();
                }
            }
        }
        return this.busyLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<DocumentController> getControllList() {
        if (this.controllList == null) {
            ModuleControllerImpl moduleControllerImpl = this;
            synchronized (moduleControllerImpl) {
                this.controllList = new HashSet();
            }
        }
        return this.controllList;
    }

    @Override
    public DocumentController next(boolean ignorePermissionForDocument) {
        if (this.getInputDocumentBus() == null) {
            throw new PepperFWException("The input document bus is not set for module controller '" + this.getId() + "'.");
        }
        DocumentController documentController = this.getInputDocumentBus().pop(this.getId(), ignorePermissionForDocument);
        if (documentController != null) {
            logger.debug("[{}] started processing of document '{}'. ", (Object)(this.getPepperModule() != null ? this.getPepperModule().getName() : " EMPTY "), (Object)documentController.getGlobalId());
            documentController.updateStatus(this, DOCUMENT_STATUS.IN_PROGRESS);
            this.getControllList().add(documentController);
            if (documentController.getDocument() == null) {
                throw new PepperFWException("The current documentController to '" + documentController.getGlobalId() + "' contains no document.");
            }
        }
        return documentController;
    }

    @Override
    public DocumentController next() {
        logger.debug("[{}] is waiting for further documents in pipeline.", (Object)(this.getPepperModule() != null ? this.getPepperModule().getName() : "NO_NAME"));
        return this.next(false);
    }

    @Override
    public void complete(DocumentController documentController) {
        if (documentController == null) {
            throw new PepperFWException("Cannot add the passed document controller to following Pepper modules, because it is null.");
        }
        if (!this.getControllList().contains(documentController)) {
            throw new PepperFWException("Cannot add the passed document controller to following Pepper modules, because the passed document controller '" + documentController.getGlobalId() + "' has never been add to internal controll list.");
        }
        if (documentController.getDocument() == null) {
            throw new PepperFWException("Cannot complete the passed document controller to following Pepper modules, because there is no SDocument contained in passed document controller '" + documentController.getGlobalId() + "' has never been add to internal controll list.");
        }
        documentController.updateStatus(this, DOCUMENT_STATUS.COMPLETED);
        this.getOutputDocumentBus().put(documentController);
        this.getControllList().remove(documentController);
        this.mLogger.debug("[{}] completed document '{}'", (Object)(this.getPepperModule() != null ? this.getPepperModule().getName() : " EMPTY "), (Object)documentController.getGlobalId());
    }

    @Override
    public void delete(DocumentController documentController) {
        if (documentController == null) {
            throw new PepperFWException("Cannot notify Pepper, that the passed document controller shall not be processed any further, because it is null.");
        }
        if (!this.getControllList().contains(documentController)) {
            throw new PepperFWException("Cannot notify Pepper, that the passed document controller '" + documentController.getGlobalId() + "' shall not be processed any further by Pepper module '" + this.getId() + "', because it is not part of internal controll list '" + this.getControllList() + "'. The reason could be, that it never has been added or it was already removed. ");
        }
        documentController.updateStatus(this, DOCUMENT_STATUS.DELETED);
        this.mLogger.debug("[{}] deleted document '{}'", (Object)(this.getPepperModule() != null ? this.getPepperModule().getName() : " EMPTY "), (Object)documentController.getGlobalId());
        documentController.sendToSleep();
        if (this.getJob() != null) {
            this.getJob().releaseDocument(documentController);
        }
        this.getControllList().remove(documentController);
    }

    @Override
    public Double getProgress(String globalId) {
        if (globalId == null) {
            throw new PepperFWException("Cannot notify Pepper framework about progress for '" + this.getId() + "', because given sDocumentId was null.");
        }
        Double retVal = null;
        if (this.getPepperModule() != null && (retVal = this.getPepperModule().getProgress(globalId)) != null && (retVal < 0.0 || retVal > 1.0)) {
            throw new PepperFWException("Cannot notify Pepper framework about progress for '" + this.getId() + "', because the percentage of progress is out of range (0..1). It is '" + retVal + "'.");
        }
        return retVal;
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append(this.getId());
        retVal.append("(");
        if (this.getPepperModule() != null) {
            retVal.append(this.getPepperModule().getName());
        } else {
            retVal.append("EMPTY");
        }
        retVal.append(", ");
        if (this.getPepperModule() != null) {
            retVal.append(this.getPepperModule().getProgress());
        }
        retVal.append(")");
        return retVal.toString();
    }
}

