/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.util.Properties;
import org.corpus_tools.pepper.common.CorpusDesc;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.common.StepDesc;
import org.corpus_tools.pepper.core.ModuleControllerImpl;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperModule;

public class Step
extends StepDesc {
    private String id = null;
    private ModuleControllerImpl moduleController = null;

    public Step(String id) {
        if (id == null) {
            throw new PepperFWException("Cannot create a step description with an empty id value.");
        }
        this.id = id;
    }

    public Step(String id, StepDesc stepDesc) {
        this(id);
        this.setName(stepDesc.getName());
        this.setVersion(stepDesc.getVersion());
        this.setModuleType(stepDesc.getModuleType());
        this.setProps(stepDesc.getProps());
        this.setCorpusDesc(stepDesc.getCorpusDesc());
    }

    @Override
    public String getName() {
        if (this.getModuleController() != null && this.getModuleController().getPepperModule() != null) {
            return this.getModuleController().getPepperModule().getName();
        }
        return super.getName();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public synchronized void setCorpusDesc(CorpusDesc corpusDesc) {
        super.setCorpusDesc(corpusDesc);
        if (this.getModuleController() != null && this.getModuleController().getPepperModule() != null) {
            if (this.getModuleController().getPepperModule() instanceof PepperImporter) {
                ((PepperImporter)this.getModuleController().getPepperModule()).setCorpusDesc(this.getCorpusDesc());
            } else if (this.getModuleController().getPepperModule() instanceof PepperExporter) {
                ((PepperExporter)this.getModuleController().getPepperModule()).setCorpusDesc(this.getCorpusDesc());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPepperModule(PepperModule pepperModule) {
        if (pepperModule == null) {
            throw new PepperFWException("Cannot create a step with an empty Pepper module object.");
        }
        Step step = this;
        synchronized (step) {
            this.moduleController = new ModuleControllerImpl(this.getId() + ":" + pepperModule.getName());
            this.moduleController.setPepperModule(pepperModule);
            if (pepperModule instanceof PepperImporter) {
                ((PepperImporter)pepperModule).setCorpusDesc(this.getCorpusDesc());
            } else if (pepperModule instanceof PepperExporter) {
                ((PepperExporter)pepperModule).setCorpusDesc(this.getCorpusDesc());
            }
            if (this.getProps() != null && pepperModule.getProperties() != null) {
                pepperModule.getProperties().setPropertyValues(this.getProps());
            }
        }
    }

    public ModuleControllerImpl getModuleController() {
        return this.moduleController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MODULE_TYPE getModuleType() {
        if (super.getModuleType() == null && this.getModuleController() != null && this.getModuleController().getPepperModule() != null) {
            Step step = this;
            synchronized (step) {
                if (super.getModuleType() == null && this.getModuleController() != null && this.getModuleController().getPepperModule() != null) {
                    this.setModuleType(this.getModuleController().getPepperModule().getModuleType());
                }
            }
        }
        return super.getModuleType();
    }

    @Override
    public synchronized void setProps(Properties props) {
        if (this.getModuleController() != null) {
            this.getModuleController().getPepperModule().getProperties().setPropertyValues(props);
        } else {
            super.setProps(props);
        }
    }
}

