/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.corpus_tools.pepper.common.CorpusDesc;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.common.PepperUtil;
import org.corpus_tools.pepper.exceptions.WorkflowException;
import org.corpus_tools.pepper.impl.PepperModuleImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.ext.DefaultHandler2;

public abstract class PepperImporterImpl
extends PepperModuleImpl
implements PepperImporter {
    protected CorpusDesc corpusDesc;
    private Map<Identifier, URI> sElementId2ResourceTable = null;
    private Collection<String> sDocumentEndings = null;
    private Collection<String> sCorpusEndings = null;
    private Collection<String> importIgnoreList = null;

    protected PepperImporterImpl() {
        super("MyImporter");
    }

    protected PepperImporterImpl(String name) {
        super(name);
    }

    @Override
    public List<FormatDesc> getSupportedFormats() {
        return this.getFingerprint().getSupportedFormats();
    }

    @Override
    public FormatDesc addSupportedFormat(String formatName, String formatVersion, URI formatReference) {
        return this.getFingerprint().addSupportedFormat(formatName, formatVersion, formatReference);
    }

    @Override
    public CorpusDesc getCorpusDesc() {
        if (this.corpusDesc == null) {
            this.corpusDesc = new CorpusDesc();
        }
        return this.corpusDesc;
    }

    @Override
    public void setCorpusDesc(CorpusDesc newCorpusDefinition) {
        this.corpusDesc = newCorpusDefinition;
    }

    @Override
    public String readFirstLines(URI corpusPath, int lines) {
        String retVal = null;
        if (corpusPath != null) {
            File importPath = new File(corpusPath.toFileString());
            try (BufferedReader br = new BufferedReader(new FileReader(importPath));){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                int i = 0;
                while (line != null) {
                    sb.append(line);
                    sb.append(System.lineSeparator());
                    line = br.readLine();
                    if (++i < lines) continue;
                }
                retVal = sb.toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return retVal;
    }

    @Override
    public synchronized Map<Identifier, URI> getIdentifier2ResourceTable() {
        if (this.sElementId2ResourceTable == null) {
            this.sElementId2ResourceTable = new Hashtable<Identifier, URI>();
        }
        return this.sElementId2ResourceTable;
    }

    @Override
    public void importCorpusStructure(SCorpusGraph corpusGraph) throws PepperModuleException {
        this.setCorpusGraph(corpusGraph);
        if (this.getCorpusGraph() == null) {
            throw new PepperModuleException(this, "Cannot start with importing corpus, because salt project isn't set.");
        }
        if (this.getCorpusDesc() == null) {
            throw new PepperModuleException(this, "Cannot start with importing corpus, because no corpus definition to import is given.");
        }
        if (this.getCorpusDesc().getCorpusPath() == null) {
            throw new PepperModuleException(this, "Cannot start with importing corpus, because the path of given corpus definition is null.");
        }
        if (!this.getCorpusDesc().getCorpusPath().isFile()) {
            throw new PepperModuleException(this, "Cannot start with importing corpus, because the given corpus path does not locate a file.");
        }
        if (this.getCorpusDesc().getCorpusPath().toFileString().endsWith("/") || this.getCorpusDesc().getCorpusPath().toFileString().endsWith("\\")) {
            this.getCorpusDesc().setCorpusPath(this.getCorpusDesc().getCorpusPath().trimSegments(1));
        }
        Boolean containsDocuments = this.importCorpusStructureRec(this.getCorpusDesc().getCorpusPath(), null);
        if (this.logger.isDebugEnabled() && this.getIdentifier2ResourceTable().size() > 0) {
            StringBuilder str = new StringBuilder();
            str.append("[");
            str.append(this.getName());
            str.append("]");
            str.append(" import corpora and documents: \n");
            for (URI uri : this.getIdentifier2ResourceTable().values()) {
                str.append("\t");
                str.append(uri);
                str.append("\n");
            }
            this.logger.debug(str.toString());
        }
        if (this.getIdentifier2ResourceTable().isEmpty()) {
            this.logger.warn("[{}] No corpora and documents fount to import in '{}'. ", (Object)this.getName(), (Object)this.getCorpusDesc().getCorpusPath());
        }
        if (!containsDocuments.booleanValue()) {
            this.logger.warn("[{}] No documents fount to import in '{}'. ", (Object)this.getName(), (Object)this.getCorpusDesc().getCorpusPath());
        }
    }

    protected Boolean importCorpusStructureRec(URI currURI, SCorpus parent) {
        SALT_TYPE type;
        Boolean retVal = false;
        if (this.getCorpusGraph().getName() == null || this.getCorpusGraph().getName().isEmpty()) {
            this.getCorpusGraph().setName(currURI.lastSegment());
        }
        if (currURI.lastSegment() != null && !this.getIgnoreEndings().contains(currURI.lastSegment()) && (type = this.setTypeOfResource(currURI)) != null) {
            File currFile = new File(currURI.toFileString());
            if (SALT_TYPE.SCORPUS.equals((Object)type)) {
                File[] files;
                SCorpus sCorpus = this.getCorpusGraph().createCorpus(parent, currURI.lastSegment());
                this.getIdentifier2ResourceTable().put(sCorpus.getIdentifier(), currURI);
                if (currFile.isDirectory() && (files = currFile.listFiles()) != null) {
                    for (File file : files) {
                        try {
                            Boolean containsDocuments = this.importCorpusStructureRec(URI.createFileURI((String)file.getCanonicalPath()), sCorpus);
                            retVal = retVal != false || containsDocuments != false;
                        }
                        catch (IOException e) {
                            throw new PepperModuleException("Cannot import corpus structure, because cannot create a URI out of file '" + file + "'. ", e);
                        }
                    }
                }
            } else if (SALT_TYPE.SDOCUMENT.equals((Object)type)) {
                retVal = true;
                if (parent == null) {
                    parent = this.getCorpusGraph().createCorpus(null, currURI.lastSegment().replace("." + currURI.fileExtension(), ""));
                    this.getIdentifier2ResourceTable().put(parent.getIdentifier(), currURI);
                }
                File docFile = new File(currURI.toFileString());
                SDocument sDocument = null;
                sDocument = docFile.isDirectory() ? this.getCorpusGraph().createDocument(parent, currURI.lastSegment()) : this.getCorpusGraph().createDocument(parent, currURI.lastSegment().replace("." + currURI.fileExtension(), ""));
                this.getIdentifier2ResourceTable().put(sDocument.getIdentifier(), currURI);
            }
        }
        return retVal;
    }

    @Override
    public void start() throws PepperModuleException {
        if (this.getCorpusDesc().getCorpusPath() == null) {
            throw new WorkflowException("[" + this.getName() + "] Cannot import corpus-structure, because no corpus path was given. ");
        }
        File corpusFile = new File(this.getCorpusDesc().getCorpusPath().toFileString());
        if (!corpusFile.exists()) {
            throw new WorkflowException("[" + this.getName() + "] Cannot import corpus-structure, because the given corpus path '" + corpusFile.getAbsolutePath() + "' does not exist. ");
        }
        super.start();
    }

    @Override
    public synchronized Collection<String> getDocumentEndings() {
        if (this.sDocumentEndings == null) {
            this.sDocumentEndings = new HashSet<String>();
        }
        return this.sDocumentEndings;
    }

    @Override
    public synchronized Collection<String> getCorpusEndings() {
        if (this.sCorpusEndings == null) {
            this.sCorpusEndings = new HashSet<String>();
            this.sCorpusEndings.add("FOLDER");
        }
        return this.sCorpusEndings;
    }

    @Override
    public SALT_TYPE setTypeOfResource(URI resource) {
        File file = new File(resource.toFileString());
        if (file.isDirectory()) {
            File folder = new File(resource.toFileString());
            if (this.isLeafFolder(folder)) {
                if (this.getDocumentEndings().contains("LEAF_FOLDER")) {
                    return SALT_TYPE.SDOCUMENT;
                }
                if (this.getCorpusEndings().contains("FOLDER") || this.getCorpusEndings().contains("LEAF_FOLDER")) {
                    return SALT_TYPE.SCORPUS;
                }
                return null;
            }
            if (this.getCorpusEndings().contains("FOLDER")) {
                return SALT_TYPE.SCORPUS;
            }
            return null;
        }
        String ending = resource.fileExtension();
        if (this.getDocumentEndings().contains("ALL_FILES")) {
            return SALT_TYPE.SDOCUMENT;
        }
        if (this.getDocumentEndings().contains(ending)) {
            return SALT_TYPE.SDOCUMENT;
        }
        if (this.getCorpusEndings().contains(ending)) {
            return SALT_TYPE.SCORPUS;
        }
        return null;
    }

    private boolean isLeafFolder(File folder) {
        if (folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory() || this.getIgnoreEndings().contains(file.getName())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized Collection<String> getIgnoreEndings() {
        if (this.importIgnoreList == null) {
            this.importIgnoreList = new HashSet<String>();
            this.importIgnoreList.add(".svn");
        }
        return this.importIgnoreList;
    }

    protected void readXMLResource(DefaultHandler2 contentHandler, URI documentLocation) {
        PepperUtil.readXMLResource(contentHandler, documentLocation);
    }

    @Override
    public Double isImportable(URI corpusPath) {
        return null;
    }
}

