/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.common.PepperModuleDesc;
import org.corpus_tools.pepper.exceptions.NotInitializedException;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.impl.PepperMapperControllerImpl;
import org.corpus_tools.pepper.modules.DocumentController;
import org.corpus_tools.pepper.modules.MappingSubject;
import org.corpus_tools.pepper.modules.ModuleController;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperManipulator;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperMapperController;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class PepperModuleImpl
implements PepperModule,
Thread.UncaughtExceptionHandler {
    protected Logger logger = LoggerFactory.getLogger((String)"Pepper");
    private PepperModuleDesc fingerprint = null;
    protected SaltProject saltProject = null;
    protected URI resources = null;
    @Deprecated
    protected URI temproraries = null;
    protected String symbolicName = null;
    private ComponentContext componentContext = null;
    private Collection<String> startProblems = new ArrayList<String>();
    protected ModuleController moduleController = null;
    protected SCorpusGraph sCorpusGraph = null;
    private Map<String, PepperMapperController> mappersControllers = null;
    private Lock getMapperConnectorLock = new ReentrantLock();
    protected boolean isMultithreaded = true;
    private ThreadGroup mapperThreadGroup = null;
    private boolean isStartOverridden = true;
    private Map<String, DocumentController> documentId2DC = null;
    private HashSet<String> mappedIds = null;
    private Collection<SCorpus> corporaToEnd = null;

    protected PepperModuleImpl() {
        this("MyModule");
    }

    protected PepperModuleImpl(String name) {
        this.setName(name);
        this.logger = LoggerFactory.getLogger((String)name);
        this.getFingerprint();
        if (this.getProperties() == null) {
            this.setProperties(new PepperModuleProperties());
        }
    }

    @Override
    public PepperModuleDesc getFingerprint() {
        if (this.fingerprint == null) {
            this.fingerprint = new PepperModuleDesc();
            if (this instanceof PepperManipulator) {
                this.fingerprint.setModuleType(MODULE_TYPE.MANIPULATOR);
            } else if (this instanceof PepperImporter) {
                this.fingerprint.setModuleType(MODULE_TYPE.IMPORTER);
            } else if (this instanceof PepperExporter) {
                this.fingerprint.setModuleType(MODULE_TYPE.EXPORTER);
            }
        }
        return this.fingerprint;
    }

    @Override
    public String getName() {
        return this.getFingerprint().getName();
    }

    protected void setName(String name) {
        if (name != null) {
            this.getFingerprint().setName(name);
        }
    }

    @Override
    public String getVersion() {
        return this.getFingerprint().getVersion();
    }

    @Override
    public void setVersion(String newVersion) {
        if (newVersion != null && this.getVersion() == null) {
            this.getFingerprint().setVersion(newVersion);
        }
    }

    @Override
    public MODULE_TYPE getModuleType() {
        return this.getFingerprint().getModuleType();
    }

    @Override
    public String getDesc() {
        return this.getFingerprint().getDesc();
    }

    @Override
    public void setDesc(String desc) {
        this.getFingerprint().setDesc(desc);
    }

    @Override
    public URI getSupplierContact() {
        return this.getFingerprint().getSupplierContact();
    }

    @Override
    public void setSupplierContact(URI supplierContact) {
        this.getFingerprint().setSupplierContact(supplierContact);
    }

    @Override
    public URI getSupplierHomepage() {
        return this.getFingerprint().getSupplierHomepage();
    }

    @Override
    public void setSupplierHomepage(URI hp) {
        this.getFingerprint().setSupplierHomepage(hp);
    }

    @Override
    public PepperModuleProperties getProperties() {
        return this.getFingerprint().getProperties();
    }

    @Override
    public void setProperties(PepperModuleProperties properties) {
        this.getFingerprint().setProperties(properties);
    }

    @Override
    public SaltProject getSaltProject() {
        return this.saltProject;
    }

    @Override
    public synchronized void setSaltProject(SaltProject newSaltProject) {
        this.saltProject = newSaltProject;
    }

    @Override
    public URI getResources() {
        return this.resources;
    }

    @Override
    public void setResources(URI newResources) {
        this.resources = newResources;
    }

    @Override
    @Deprecated
    public URI getTemproraries() {
        return this.temproraries;
    }

    @Override
    @Deprecated
    public void setTemproraries(URI newTemproraries) {
        this.temproraries = newTemproraries;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public void setSymbolicName(String newSymbolicName) {
        this.symbolicName = newSymbolicName;
    }

    @Override
    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        if (componentContext != null && componentContext.getBundleContext() != null && componentContext.getBundleContext().getBundle() != null) {
            this.setSymbolicName(componentContext.getBundleContext().getBundle().getSymbolicName());
            this.setVersion(componentContext.getBundleContext().getBundle().getVersion().toString());
        }
    }

    @Override
    public Collection<String> getStartProblems() {
        return this.startProblems;
    }

    @Override
    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        Boolean retVal = true;
        if (this.getResources() == null) {
            this.startProblems.add("No resource is given for module.");
            retVal = false;
        } else {
            File resourceFile = new File(this.getResources().toFileString());
            if (!resourceFile.exists()) {
                this.startProblems.add("Given resource file '" + resourceFile.getAbsolutePath() + "' does not exist.");
                retVal = false;
            }
        }
        if (this.getModuleType() == null) {
            this.startProblems.add("No module-type is set for module.");
            retVal = false;
        }
        if (this.getName() == null) {
            this.startProblems.add("No name is set for module.");
            retVal = false;
        }
        return retVal;
    }

    @Override
    public ModuleController getModuleController() {
        return this.moduleController;
    }

    @Override
    public void setPepperModuleController(ModuleController newModuleController) {
        this.setPepperModuleController_basic(newModuleController);
        newModuleController.setPepperModule_basic(this);
    }

    @Override
    public void setPepperModuleController_basic(ModuleController newModuleController) {
        this.moduleController = newModuleController;
    }

    @Override
    public SCorpusGraph getCorpusGraph() {
        return this.sCorpusGraph;
    }

    @Override
    public void setCorpusGraph(SCorpusGraph newSCorpusGraph) {
        this.sCorpusGraph = newSCorpusGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, PepperMapperController> getMapperControllers() {
        if (this.mappersControllers == null) {
            this.getMapperConnectorLock.lock();
            try {
                if (this.mappersControllers == null) {
                    this.mappersControllers = new Hashtable<String, PepperMapperController>();
                }
            }
            finally {
                this.getMapperConnectorLock.unlock();
            }
        }
        return this.mappersControllers;
    }

    @Override
    public void setIsMultithreaded(boolean isMultithreaded) {
        this.isMultithreaded = isMultithreaded;
    }

    @Override
    public boolean isMultithreaded() {
        return this.isMultithreaded;
    }

    protected ThreadGroup getMapperThreadGroup() {
        return this.mapperThreadGroup;
    }

    protected void setMapperThreadGroup(ThreadGroup mapperThreadGroup) {
        this.mapperThreadGroup = mapperThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, DocumentController> getDocumentId2DC() {
        if (this.documentId2DC == null) {
            PepperModuleImpl pepperModuleImpl = this;
            synchronized (pepperModuleImpl) {
                if (this.documentId2DC == null) {
                    this.documentId2DC = new Hashtable<String, DocumentController>();
                }
            }
        }
        return this.documentId2DC;
    }

    @Override
    public void start() throws PepperModuleException {
        if (this.getSaltProject() == null) {
            throw new PepperFWException("No salt project was set in module '" + this.getName() + ", " + this.getVersion() + "'.");
        }
        this.mapperThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), this.getName() + "_mapperGroup");
        boolean isStart = true;
        Identifier sElementId = null;
        DocumentController documentController = null;
        while (isStart || sElementId != null) {
            isStart = false;
            documentController = this.getModuleController().next();
            if (documentController == null) break;
            sElementId = documentController.getDocumentId();
            this.getDocumentId2DC().put(SaltUtil.getGlobalId((Identifier)sElementId), documentController);
            try {
                this.start(sElementId);
            }
            catch (Exception e) {
                if (this.isStartOverridden) {
                    this.done(sElementId, DOCUMENT_STATUS.DELETED);
                }
                if (e instanceof PepperModuleException) {
                    throw (PepperModuleException)e;
                }
                throw new PepperModuleException(this, "", (Throwable)e);
            }
            if (!this.isStartOverridden) continue;
            this.done(sElementId, DOCUMENT_STATUS.COMPLETED);
        }
        Collection<PepperMapperController> controllers = null;
        HashSet<PepperMapperController> alreadyWaitedFor = new HashSet<PepperMapperController>();
        controllers = Collections.synchronizedCollection(this.getMapperControllers().values());
        for (PepperMapperController controller : controllers) {
            try {
                controller.join();
                alreadyWaitedFor.add(controller);
            }
            catch (InterruptedException e) {
                throw new PepperFWException("Cannot wait for mapper thread '" + controller + "' in " + this.getName() + " to end. ", e);
            }
        }
        this.end();
        for (PepperMapperController controller : this.getMapperControllers().values()) {
            if (alreadyWaitedFor.contains(controller)) continue;
            try {
                controller.join();
            }
            catch (InterruptedException e) {
                throw new PepperFWException("Cannot wait for mapper thread '" + controller + "' in " + this.getName() + " to end. ", e);
            }
            this.done(controller);
        }
    }

    private synchronized Collection<String> getMappedIds() {
        if (this.mappedIds == null) {
            this.mappedIds = new HashSet();
        }
        return this.mappedIds;
    }

    @Override
    public void done(Identifier id, DOCUMENT_STATUS result) {
        if (id.getIdentifiableElement() instanceof SDocument) {
            DocumentController docController = this.getDocumentId2DC().get(SaltUtil.getGlobalId((Identifier)id));
            if (docController == null) {
                throw new PepperFWException("Error in '" + this.getName() + "'. Cannot find a " + DocumentController.class.getSimpleName() + " object corresponding to " + SDocument.class.getSimpleName() + " '" + SaltUtil.getGlobalId((Identifier)id) + "' to pass status '" + (Object)((Object)result) + "'. Controllers are listed for the following Identifier objects: " + this.getDocumentId2DC() + ". ");
            }
            if (DOCUMENT_STATUS.DELETED.equals((Object)result)) {
                this.getModuleController().delete(docController);
            } else if (DOCUMENT_STATUS.COMPLETED.equals((Object)result)) {
                this.getModuleController().complete(docController);
            } else if (DOCUMENT_STATUS.FAILED.equals((Object)result)) {
                this.logger.error("Cannot map '" + SaltUtil.getGlobalId((Identifier)id) + "' with module '" + this.getName() + "', because of a mapping result was '" + (Object)((Object)DOCUMENT_STATUS.FAILED) + "'.");
                this.getModuleController().delete(docController);
            } else {
                throw new PepperModuleException(this, "Cannot notify pepper framework for process of Identifier '" + id.getId() + "', because the mapping result was '" + (Object)((Object)result) + "', and only '" + (Object)((Object)DOCUMENT_STATUS.COMPLETED) + "', '" + (Object)((Object)DOCUMENT_STATUS.FAILED) + "' and '" + (Object)((Object)DOCUMENT_STATUS.DELETED) + "' is permitted.");
            }
        }
    }

    @Override
    public void done(PepperMapperController controller) {
        if (controller == null) {
            throw new PepperFWException("This might be a bug of Pepper framework. The given PepperMapperController is null in methode done().");
        }
        if (controller.getMappingSubjects() != null) {
            for (MappingSubject subject : controller.getMappingSubjects()) {
                String globalId = SaltUtil.getGlobalId((Identifier)subject.getIdentifier());
                DOCUMENT_STATUS result = null;
                if (this.getMappedIds().contains(globalId)) continue;
                this.getMappedIds().add(SaltUtil.getGlobalId((Identifier)subject.getIdentifier()));
                try {
                    result = subject.getMappingResult();
                }
                catch (Exception e) {
                    result = DOCUMENT_STATUS.FAILED;
                }
                this.done(subject.getIdentifier(), result);
            }
        }
    }

    @Override
    public void start(Identifier sElementId) throws PepperModuleException {
        this.isStartOverridden = false;
        this.corporaToEnd = new Vector<SCorpus>();
        LinkedList corpGraphs = new LinkedList(this.getSaltProject().getCorpusGraphs());
        for (SCorpusGraph sCorpusGraph : corpGraphs) {
            if (sCorpusGraph == null) continue;
            if (MODULE_TYPE.IMPORTER.equals((Object)this.getModuleType())) {
                boolean belongsToSetCorpusGraph = false;
                if (sCorpusGraph.getIdentifier() != null && ((PepperImporter)((Object)this)).getCorpusGraph() != null && ((PepperImporter)((Object)this)).getCorpusGraph().getIdentifier() != null) {
                    if (sCorpusGraph.getIdentifier().equals(((PepperImporter)((Object)this)).getCorpusGraph().getIdentifier())) {
                        belongsToSetCorpusGraph = true;
                    }
                } else if (sCorpusGraph.equals(((PepperImporter)((Object)this)).getCorpusGraph())) {
                    belongsToSetCorpusGraph = true;
                }
                if (!belongsToSetCorpusGraph) continue;
                for (SCorpus sCorpus : sCorpusGraph.getCorpora()) {
                    this.corporaToEnd.add(sCorpus);
                }
                continue;
            }
            for (SCorpus sCorpus : sCorpusGraph.getCorpora()) {
                this.corporaToEnd.add(sCorpus);
            }
        }
        if (sElementId != null && sElementId.getIdentifiableElement() != null && (sElementId.getIdentifiableElement() instanceof SDocument || sElementId.getIdentifiableElement() instanceof SCorpus)) {
            PepperMapperControllerImpl controller = new PepperMapperControllerImpl(this.mapperThreadGroup, this.getName() + "_mapper(" + sElementId.getId() + ")");
            String id = sElementId.getId();
            if (sElementId.getIdentifiableElement() instanceof SDocument) {
                id = SaltUtil.getGlobalId((Identifier)sElementId);
            }
            this.getMapperControllers().put(id, controller);
            controller.setUncaughtExceptionHandler(this);
            controller.setPepperModule(this);
            PepperMapper mapper = this.createPepperMapper(sElementId);
            mapper.setProperties(this.getProperties());
            if (this instanceof PepperImporter && mapper.getResourceURI() == null) {
                URI resource = ((PepperImporter)((Object)this)).getIdentifier2ResourceTable().get(sElementId);
                mapper.setResourceURI(resource);
            }
            if (sElementId.getIdentifiableElement() instanceof SDocument && mapper.getDocument() == null) {
                mapper.setDocument((SDocument)sElementId.getIdentifiableElement());
            } else if (sElementId.getIdentifiableElement() instanceof SCorpus && mapper.getCorpus() == null) {
                mapper.setCorpus((SCorpus)sElementId.getIdentifiableElement());
            }
            controller.setPepperMapper(mapper);
            if (this.isMultithreaded()) {
                controller.start();
            } else {
                controller.run();
            }
        }
    }

    @Override
    public PepperMapper createPepperMapper(Identifier sElementId) {
        throw new NotInitializedException("Cannot start mapping, because the method createPepperMapper() of module '" + this.getName() + "' has not been overridden. Please check that first.");
    }

    @Override
    public void end() throws PepperModuleException {
        this.logger.trace("[{}] start processing corpus structure (manipulating or exporting). ", (Object)this.getName());
        if (this.getSaltProject() == null) {
            throw new PepperModuleException(this, "Error in method end() salt project was empty.");
        }
        if (this.getSaltProject().getCorpusGraphs() == null) {
            throw new PepperModuleException(this, "Error in method end() corpus graphs of salt project were empty.");
        }
        if (this.corporaToEnd != null) {
            for (SCorpus sCorpus : this.corporaToEnd) {
                this.start(sCorpus.getIdentifier());
            }
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.logger.error("An exception was thrown by the mapper threads '" + t + "'. ", (Object)e.getMessage());
        e.printStackTrace();
        if (this.logger instanceof NOPLogger) {
            e.printStackTrace();
        }
    }

    @Override
    public Double getProgress(String globalId) {
        if (globalId == null) {
            throw new PepperFWException("Cannot return the progress for an empty sDocumentId.");
        }
        PepperMapperController controller = this.getMapperControllers().get(globalId);
        if (controller != null) {
            return controller.getProgress();
        }
        return null;
    }

    @Override
    public Double getProgress() {
        Collection<PepperMapperController> controllers = Collections.synchronizedCollection(this.getMapperControllers().values());
        Double progress = 0.0;
        if (controllers != null && controllers.size() > 0) {
            for (PepperMapperController controller : controllers) {
                if (controller == null) continue;
                progress = progress + controller.getProgress();
            }
            if (progress > 0.0) {
                progress = progress / (double)controllers.size();
            }
        }
        return progress;
    }

    @Override
    public List<Identifier> proposeImportOrder(SCorpusGraph sCorpusGraph) {
        return new Vector<Identifier>();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append((Object)this.getModuleType());
        result.append("(");
        result.append(this.getName());
        result.append(", ");
        if (this.getVersion() != null) {
            result.append(this.getVersion());
        } else {
            result.append("NO_VERSION");
        }
        result.append(")");
        return result.toString();
    }
}

