/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules;

import java.io.File;

public class PepperModuleProperty<T>
implements Comparable<PepperModuleProperty<?>> {
    private String name = null;
    private Class<T> clazz = null;
    private String description = null;
    private boolean required = false;
    T value = null;

    public PepperModuleProperty(String name, Class<T> clazz, String description) {
        this.name = name;
        this.clazz = clazz;
        this.description = description;
    }

    public PepperModuleProperty(String name, Class<T> clazz, String description, T defaultValue) {
        this(name, clazz, description);
        this.value = defaultValue;
    }

    public PepperModuleProperty(String name, Class<T> clazz, String description, boolean required) {
        this(name, clazz, description);
        this.required = required;
    }

    public PepperModuleProperty(String name, Class<T> clazz, String description, T defaultValue, boolean required) {
        this(name, clazz, description, required);
        this.value = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public void setType(Class<T> type) {
        this.clazz = type;
    }

    public Class<T> getType() {
        return this.clazz;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setValueString(String value) {
        if (value == null) {
            this.value = null;
        } else {
            value = value.trim();
            if (String.class.isAssignableFrom(this.clazz)) {
                this.value = value;
            } else if (Character.class.isAssignableFrom(this.clazz)) {
                this.value = Character.valueOf(value.charAt(0));
            } else if (Boolean.class.isAssignableFrom(this.clazz)) {
                this.value = Boolean.valueOf(value);
            } else if (Integer.class.isAssignableFrom(this.clazz)) {
                this.value = Integer.valueOf(value);
            } else if (Long.class.isAssignableFrom(this.clazz)) {
                this.value = Long.valueOf(value);
            } else if (Float.class.isAssignableFrom(this.clazz)) {
                this.value = Float.valueOf(value);
            } else if (Double.class.isAssignableFrom(this.clazz)) {
                this.value = Double.valueOf(value);
            } else if (Byte.class.isAssignableFrom(this.clazz)) {
                this.value = Byte.valueOf(value);
            } else if (Short.class.isAssignableFrom(this.clazz)) {
                this.value = Short.valueOf(value);
            } else if (File.class.isAssignableFrom(this.clazz)) {
                this.value = new File(value);
            }
        }
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return this.getName() + "=" + this.getType() + "::" + this.getValue();
    }

    @Override
    public int compareTo(PepperModuleProperty<?> o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

