/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules.coreModules;

import java.io.File;
import java.io.IOException;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.coreModules.DOTManipulatorProperties;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(name="DOTManipulatorComponent", factory="PepperManipulatorComponentFactory")
public class DOTManipulator
extends PepperManipulatorImpl {
    public DOTManipulator() {
        super("DOTManipulator");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This manipulator exports a Salt model to the dot syntax. This can be used to create a graphical representation of the Salt model. ");
        this.setProperties(new DOTManipulatorProperties());
    }

    @Override
    @Activate
    public void activate(ComponentContext componentContext) {
        super.activate(componentContext);
    }

    @Override
    public PepperMapper createPepperMapper(Identifier sElementId) {
        PepperMapperImpl mapper = new PepperMapperImpl(){

            @Override
            public DOCUMENT_STATUS mapSDocument() {
                SaltUtil.saveDocumentGraph((SDocumentGraph)this.getDocument().getDocumentGraph(), (URI)this.getResourceURI());
                this.addProgress(1.0);
                return DOCUMENT_STATUS.COMPLETED;
            }
        };
        String outputStr = ((DOTManipulatorProperties)this.getProperties()).getOutputFile().getAbsolutePath();
        File outputFile = new File(outputStr + "/" + ((SNode)sElementId.getIdentifiableElement()).getPath() + "." + ((DOTManipulatorProperties)this.getProperties()).getFileEnding());
        if (!outputFile.exists()) {
            try {
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    this.logger.warn("Cannot create folder {}. ", (Object)outputFile.getParentFile());
                }
                if (!outputFile.getParentFile().exists()) {
                    throw new PepperModuleException("Cannot create folder for output file for dot: " + outputFile.getParentFile());
                }
                if (!outputFile.createNewFile()) {
                    this.logger.warn("Cannot create file {}. ", (Object)outputFile);
                }
            }
            catch (IOException e) {
                throw new PepperModuleException("Cannot create output file for dot: " + outputStr);
            }
        }
        URI outputURI = URI.createFileURI((String)outputFile.getAbsolutePath());
        mapper.setResourceURI(outputURI);
        return mapper;
    }
}

