/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules.coreModules;

import java.util.ArrayList;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.coreModules.SaltValidatorProperties;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="SaltValidatorManipulatorComponent", factory="PepperManipulatorComponentFactory")
public class SaltValidator
extends PepperManipulatorImpl {
    private static final Logger logger = LoggerFactory.getLogger(SaltValidator.class);
    private static final String MSG_PREFIX = "[validator]: ";
    private static final String MSG_HELP = "You can switch on property 'clean' to try to clean the model, but take care, this could also mean to remove model objects.";

    public SaltValidator() {
        this.setName("SaltValidator");
        this.setDesc("The aim of the SaltValidator is to check a Salt model and to detect possible problems for further modules. This might be very helpful, when developing an importer or a manipulator, to check their output. This could also be used by end users, to check if a module produces a processable output.");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setProperties(new SaltValidatorProperties());
    }

    @Override
    public PepperMapper createPepperMapper(Identifier sElementId) {
        ValidatorMapper mapper = new ValidatorMapper();
        return mapper;
    }

    public static class ValidatorMapper
    extends PepperMapperImpl {
        @Override
        public DOCUMENT_STATUS mapSCorpus() {
            if (this.getCorpus() != null) {
                Boolean isLeafCorpus = null;
                for (SRelation relation : this.getCorpus().getGraph().getOutRelations(this.getCorpus().getId())) {
                    if (relation.getTarget() instanceof SDocument) {
                        if (isLeafCorpus != null && !isLeafCorpus.booleanValue()) {
                            logger.info("[validator]: Salt model not valid, the corpus '" + relation.getSource().getId() + "' contains corpora and documents as well.");
                        }
                        isLeafCorpus = true;
                        continue;
                    }
                    if (!(relation.getTarget() instanceof SCorpus)) continue;
                    if (isLeafCorpus != null && isLeafCorpus.booleanValue()) {
                        logger.info("[validator]: Salt model not valid, the corpus '" + relation.getSource().getId() + "' contains corpora and documents as well.");
                    }
                    isLeafCorpus = true;
                }
            }
            return super.mapSCorpus();
        }

        @Override
        public DOCUMENT_STATUS mapSDocument() {
            ArrayList<String> invalidities = new ArrayList<String>();
            if (this.getDocument().getDocumentGraph() != null) {
                for (SRelation rel : this.getDocument().getDocumentGraph().getRelations()) {
                    String msg;
                    if (rel.getSource() == null) {
                        msg = "The relation '" + rel.getId() + "' has no source node. ";
                        if (((SaltValidatorProperties)this.getProperties()).isClean().booleanValue()) {
                            this.getDocument().getDocumentGraph().removeRelation((Relation)rel);
                            msg = msg + "[DELETED] ";
                        }
                        invalidities.add(msg);
                    }
                    if (rel.getTarget() == null) {
                        msg = "The relation '" + rel.getId() + "' has no target node.";
                        if (((SaltValidatorProperties)this.getProperties()).isClean().booleanValue()) {
                            this.getDocument().getDocumentGraph().removeRelation((Relation)rel);
                            msg = msg + "[DELETED] ";
                        }
                        invalidities.add(msg);
                    }
                    if (rel.getSource() != null && rel.getTarget() != null && rel.getSource().equals(rel.getTarget()) && ((SaltValidatorProperties)this.getProperties()).isSelfRelation().booleanValue()) {
                        this.getDocument().getDocumentGraph().removeRelation((Relation)rel);
                        invalidities.add("[DELETED] The source and target of relation '" + rel.getId() + "' points to the same node '" + rel.getSource().getId() + "'. ");
                    }
                    if (!(rel instanceof STextualRelation)) continue;
                    STextualRelation textRel = (STextualRelation)rel;
                    if (textRel.getStart() == null) {
                        invalidities.add("The " + STextualRelation.class.getSimpleName() + " '" + rel.getId() + "' has no sStart value.");
                    }
                    if (textRel.getEnd() == null) {
                        invalidities.add("The " + STextualRelation.class.getSimpleName() + " '" + rel.getId() + "' has no sEnd value.");
                    }
                    if (((STextualDS)textRel.getTarget()).getText() == null) {
                        invalidities.add("The " + STextualDS.class.getSimpleName() + " '" + ((STextualDS)textRel.getTarget()).getId() + "' has contains no sText value, but there are '" + STextualRelation.class.getSimpleName() + "' relations refering it.");
                    }
                    if ((Integer)textRel.getStart() > ((STextualDS)textRel.getTarget()).getText().length() || (Integer)textRel.getStart() < 0) {
                        invalidities.add("The sStart value '" + textRel.getStart() + "' of " + STextualRelation.class.getSimpleName() + " '" + rel.getId() + "' is not in range of target text. It's length is '" + ((STextualDS)textRel.getTarget()).getText().length() + "'.");
                    }
                    if ((Integer)textRel.getEnd() <= ((STextualDS)textRel.getTarget()).getText().length() && (Integer)textRel.getEnd() >= 0) continue;
                    invalidities.add("The sEnd value '" + textRel.getEnd() + "' of " + STextualRelation.class.getSimpleName() + " '" + rel.getId() + "' is not in range of target text. It's length is '" + ((STextualDS)textRel.getTarget()).getText().length() + "'.");
                }
            }
            if (invalidities.size() != 0) {
                String msg = "[validator]: The Salt model is not valid.";
                if (!((SaltValidatorProperties)this.getProperties()).isClean().booleanValue()) {
                    msg = msg + SaltValidator.MSG_HELP;
                }
                msg = msg + "The following invalidities have been found in document-structure '" + this.getDocument().getId() + "':";
                logger.info(msg);
                for (String invalidity : invalidities) {
                    logger.info("\t" + invalidity);
                }
            }
            return DOCUMENT_STATUS.COMPLETED;
        }
    }
}

