/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules.coreModules;

import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperExporterImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="SaltXMLExporterComponent", factory="PepperExporterComponentFactory")
public class SaltXMLExporter
extends PepperExporterImpl
implements PepperExporter {
    public static final String MODULE_NAME = "SaltXMLExporter";
    public static final String FORMAT_NAME_SALTXML = "SaltXML";
    public static final String FORMAT_VERSION_SALTXML = "1.0";

    public SaltXMLExporter() {
        super(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This exporter exports a Salt model to a SaltXML representation. SaltXML is the native format to persist Salt. ");
        this.addSupportedFormat(FORMAT_NAME_SALTXML, FORMAT_VERSION_SALTXML, null);
    }

    @Override
    public PepperMapper createPepperMapper(Identifier sElementId) {
        SaltXMLExporterMapper mapper = new SaltXMLExporterMapper();
        return mapper;
    }

    @Override
    public void start() throws PepperModuleException {
        if (this.getSaltProject() == null) {
            throw new PepperModuleException("Cannot export the SaltProject, because the saltProject is null.");
        }
        if (this.getCorpusDesc() == null) {
            throw new PepperModuleException("Cannot export the SaltProject, because no corpus definition is given for export.");
        }
        if (this.getCorpusDesc().getCorpusPath() == null) {
            throw new PepperModuleException("Cannot export the SaltProject, because no corpus path is given for export.");
        }
        URI saltProjectURI = URI.createFileURI((String)(this.getCorpusDesc().getCorpusPath().toFileString() + "/" + "saltProject.salt"));
        SaltUtil.saveSaltProject((SaltProject)this.saltProject, (URI)saltProjectURI);
        super.start();
    }

    private class SaltXMLExporterMapper
    extends PepperMapperImpl {
        private SaltXMLExporterMapper() {
        }

        @Override
        public DOCUMENT_STATUS mapSDocument() {
            URI sDocumentURI = SaltXMLExporter.this.getCorpusDesc().getCorpusPath().appendSegments(this.getDocument().getPath().segments());
            sDocumentURI = sDocumentURI.appendFileExtension("salt");
            SaltUtil.saveDocumentGraph((SDocumentGraph)this.getDocument().getDocumentGraph(), (URI)sDocumentURI);
            return DOCUMENT_STATUS.COMPLETED;
        }
    }
}

