/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.testFramework;

import java.util.List;
import java.util.Vector;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.testFramework.PepperModuleTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class PepperImporterTest
extends PepperModuleTest {
    protected List<FormatDesc> supportedFormatsCheck = null;

    public void addSupportedFormat(FormatDesc formatDesc) {
        if (formatDesc == null) {
            Assert.fail((String)"Cannot add an empty format description.");
        }
        this.supportedFormatsCheck.add(formatDesc);
    }

    protected void setFixture(PepperImporter fixture) {
        super.setFixture(fixture);
        this.supportedFormatsCheck = new Vector<FormatDesc>();
    }

    @Override
    protected PepperImporter getFixture() {
        return (PepperImporter)super.getFixture();
    }

    @Test
    public void testGetSupportedFormats() {
        Assert.assertNotNull((String)"Cannot run test, please set fixture first.", (Object)this.getFixture());
        Assert.assertNotNull((String)"There have to be some supported formats", this.getFixture().getSupportedFormats());
        List<FormatDesc> formatDefs = this.getFixture().getSupportedFormats();
        Assert.assertNotSame((String)"Number of supported formats have to be more than 0", (Object)0, formatDefs);
        for (FormatDesc formatDef : formatDefs) {
            Assert.assertNotNull((String)"The name of supported formats has to be set.", (Object)formatDef.getFormatName());
            Assert.assertFalse((String)"The name of the supported formats can't be empty.", (boolean)formatDef.getFormatName().equals(""));
            Assert.assertNotNull((String)"The version of supported formats has to be set.", (Object)formatDef.getFormatVersion());
            Assert.assertFalse((String)"The version of the supported formats can't be empty.", (boolean)formatDef.getFormatVersion().equals(""));
        }
        Assert.assertTrue((String)"Cannot test the supported formats please set variable 'supportedFormatsCheck'.", (this.supportedFormatsCheck.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"There is a different between the number formats which are supported by module, and the number of formats which shall be supported.", (long)this.supportedFormatsCheck.size(), (long)this.getFixture().getSupportedFormats().size());
        for (FormatDesc formatCheck : this.supportedFormatsCheck) {
            Boolean hasOpponend = false;
            for (FormatDesc formatDef : this.getFixture().getSupportedFormats()) {
                if (!formatDef.getFormatName().equalsIgnoreCase(formatCheck.getFormatName()) || !formatDef.getFormatVersion().equalsIgnoreCase(formatCheck.getFormatVersion())) continue;
                hasOpponend = true;
            }
            Assert.assertTrue((String)("The format '" + formatCheck.getFormatName() + " " + formatCheck.getFormatVersion() + "' has to be supported, but does not exist in list of suppoted formats."), (boolean)hasOpponend);
        }
    }
}

