/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules.coreModules;

import java.util.List;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperExporterImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="DOTExporterComponent", factory="PepperExporterComponentFactory", enabled=true)
public class DOTExporter
extends PepperExporterImpl {
    public DOTExporter() {
        super("DOTExporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This exporter exports a Salt model to the dot syntax. This can be used to create a graphical representation of the Salt model. ");
        this.addSupportedFormat("dot", "1.0", null);
    }

    @Override
    public PepperMapper createPepperMapper(Identifier sElementId) {
        PepperMapperImpl mapper = new PepperMapperImpl(){

            @Override
            public DOCUMENT_STATUS mapSDocument() {
                SCorpusGraph sCorpusGraph = this.getDocument().getGraph();
                SaltUtil.save_DOT((Object)this.getDocument(), (URI)this.getResourceURI());
                if (this.getDocument().getGraph() == null) {
                    this.getDocument().setGraph((Graph)sCorpusGraph);
                }
                this.addProgress(1.0);
                return DOCUMENT_STATUS.COMPLETED;
            }

            @Override
            public DOCUMENT_STATUS mapSCorpus() {
                List roots = this.getCorpus().getGraph().getRoots();
                if (roots != null && !roots.isEmpty() && this.getCorpus().equals(roots.get(0))) {
                    SaltUtil.save_DOT((Object)this.getCorpus().getGraph(), (URI)DOTExporter.this.getCorpusDesc().getCorpusPath());
                }
                return DOCUMENT_STATUS.COMPLETED;
            }
        };
        StringBuilder segments = new StringBuilder();
        URI outputURI = null;
        for (String segment : ((SNode)sElementId.getIdentifiableElement()).getPath().segmentsList()) {
            segments.append("/");
            segments.append(segment);
        }
        outputURI = URI.createFileURI((String)(this.getCorpusDesc().getCorpusPath().toFileString() + segments.toString() + "." + "salt"));
        mapper.setResourceURI(outputURI);
        return mapper;
    }
}

