/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModuleFitness {
    private String moduleName;
    private final Map<FitnessFeature, Boolean> fitnessMap = new HashMap<FitnessFeature, Boolean>();

    public ModuleFitness(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setFeature(FitnessFeature feature, boolean value) {
        if (feature != null) {
            this.fitnessMap.put(feature, value);
        }
    }

    public Boolean getFitness(FitnessFeature feature) {
        return this.fitnessMap.get((Object)feature);
    }

    public Fitness getOverallFitness() {
        if (this.fitnessMap.size() == 0) {
            return Fitness.FIT;
        }
        Fitness overallFitness = Fitness.CRITICAL;
        for (FitnessFeature healthFeature : FitnessFeature.getHealthFeatures()) {
            Boolean fitness = this.fitnessMap.get((Object)healthFeature);
            if (!Boolean.FALSE.equals(fitness)) continue;
            return overallFitness;
        }
        overallFitness = Fitness.HEALTHY;
        boolean hasFitnessValue = false;
        for (FitnessFeature fitnessFeature : FitnessFeature.getFitnessFeatures()) {
            Boolean fitness = this.fitnessMap.get((Object)fitnessFeature);
            if (Boolean.FALSE.equals(fitness)) {
                return overallFitness;
            }
            if (!Boolean.TRUE.equals(fitness)) continue;
            hasFitnessValue = true;
        }
        if (hasFitnessValue) {
            overallFitness = Fitness.FIT;
        }
        return overallFitness;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append(this.moduleName);
        retVal.append(":");
        for (FitnessFeature healthFeature : FitnessFeature.getHealthFeatures()) {
            retVal.append((Object)healthFeature);
            retVal.append("=");
            retVal.append(this.getFitness(healthFeature));
            retVal.append(", ");
        }
        for (FitnessFeature fitnessFeature : FitnessFeature.getFitnessFeatures()) {
            retVal.append((Object)fitnessFeature);
            retVal.append("=");
            retVal.append(this.getFitness(fitnessFeature));
            retVal.append(", ");
        }
        return retVal.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fitnessMap == null ? 0 : this.fitnessMap.hashCode());
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleFitness other = (ModuleFitness)obj;
        if (this.fitnessMap == null ? other.fitnessMap != null : !this.fitnessMap.equals(other.fitnessMap)) {
            return false;
        }
        return !(this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName));
    }

    public static class ModuleFitnessBuilder {
        private ModuleFitness moduleFitness;

        public ModuleFitnessBuilder(String moduleName) {
            this.moduleFitness = new ModuleFitness(moduleName);
        }

        public ModuleFitnessBuilder addFitnessFeature(FitnessFeature feature, boolean fitness) {
            this.moduleFitness.setFeature(feature, fitness);
            return this;
        }

        public ModuleFitness build() {
            return this.moduleFitness;
        }
    }

    public static enum FitnessFeature {
        HAS_NAME,
        IS_READY_TO_RUN,
        HAS_PASSED_SELFTEST,
        IS_IMPORTABLE_SEFTEST_DATA,
        IS_VALID_SELFTEST_DATA,
        HAS_SUPPLIER_CONTACT,
        HAS_SUPPLIER_HP,
        HAS_DESCRIPTION,
        HAS_SUPPORTED_FORMATS,
        HAS_SELFTEST,
        IS_IMPORTABLE;

        private static final Set<FitnessFeature> FITNESS_FEATURES;
        private static final Set<FitnessFeature> HEALTH_FEATURES;

        public static Collection<FitnessFeature> getHealthFeatures() {
            if (HEALTH_FEATURES.size() < 1) {
                HEALTH_FEATURES.add(IS_READY_TO_RUN);
                HEALTH_FEATURES.add(HAS_NAME);
                HEALTH_FEATURES.add(HAS_PASSED_SELFTEST);
                HEALTH_FEATURES.add(IS_IMPORTABLE_SEFTEST_DATA);
                HEALTH_FEATURES.add(IS_VALID_SELFTEST_DATA);
            }
            return HEALTH_FEATURES;
        }

        public static Collection<FitnessFeature> getFitnessFeatures() {
            if (FITNESS_FEATURES.size() < 1) {
                FITNESS_FEATURES.add(HAS_SUPPLIER_CONTACT);
                FITNESS_FEATURES.add(HAS_SUPPLIER_HP);
                FITNESS_FEATURES.add(HAS_DESCRIPTION);
                FITNESS_FEATURES.add(HAS_SUPPORTED_FORMATS);
                FITNESS_FEATURES.add(IS_IMPORTABLE);
                FITNESS_FEATURES.add(HAS_SELFTEST);
            }
            return FITNESS_FEATURES;
        }

        static {
            FITNESS_FEATURES = new HashSet<FitnessFeature>();
            HEALTH_FEATURES = new HashSet<FitnessFeature>();
        }
    }

    public static enum Fitness {
        FIT,
        HEALTHY,
        CRITICAL;

    }
}

