/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.corpus_tools.pepper.common.JOB_STATUS;
import org.corpus_tools.pepper.common.ModuleFitness;
import org.corpus_tools.pepper.common.Pepper;
import org.corpus_tools.pepper.common.PepperConfiguration;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.PepperModuleDesc;
import org.corpus_tools.pepper.core.ModuleFitnessChecker;
import org.corpus_tools.pepper.core.ModuleResolver;
import org.corpus_tools.pepper.core.PepperJobImpl;
import org.corpus_tools.pepper.exceptions.JobNotFoundException;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.impl.CorpusPathResolver;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperManipulator;
import org.corpus_tools.pepper.modules.PepperModule;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="PepperImpl", immediate=true)
public class PepperImpl
implements Pepper {
    private static final Logger logger = LoggerFactory.getLogger((String)"Pepper");
    private PepperConfiguration configuration = null;
    private Map<String, JobEntry> mapOfJobs = null;
    private ModuleResolver moduleResolver = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PepperConfiguration getConfiguration() {
        if (this.configuration == null) {
            PepperImpl pepperImpl = this;
            synchronized (pepperImpl) {
                if (this.configuration == null) {
                    this.configuration = new PepperConfiguration();
                }
            }
        }
        return this.configuration;
    }

    @Override
    public void setConfiguration(PepperConfiguration configuration) {
        this.configuration = configuration;
        if (this.getModuleResolver() != null) {
            this.getModuleResolver().setConfiguration(this.getConfiguration());
        }
    }

    @Override
    public Set<String> findAppropriateImporters(URI corpusPath) throws FileNotFoundException {
        if (corpusPath == null) {
            throw new FileNotFoundException("Cannot find importers for corpus path, because corpus path is null.  ");
        }
        if (this.getModuleResolver() == null) {
            throw new PepperFWException("Cannot find importers for corpus path '" + corpusPath + "', because the module resolver is null. ");
        }
        HashSet<String> retVal = new HashSet<String>();
        CorpusPathResolver corpusPathResolver = new CorpusPathResolver(corpusPath);
        for (PepperImporter importer : this.getModuleResolver().getPepperImporters()) {
            Double rate;
            if (importer instanceof PepperImporterImpl) {
                ((PepperImporterImpl)importer).setCorpusPathResolver(corpusPathResolver);
            }
            if ((rate = importer.isImportable(corpusPath)) == null || !(rate > 0.0)) continue;
            retVal.add(importer.getName());
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, JobEntry> getMapOfJobs() {
        if (this.mapOfJobs == null) {
            PepperImpl pepperImpl = this;
            synchronized (pepperImpl) {
                if (this.mapOfJobs == null) {
                    this.mapOfJobs = new Hashtable<String, JobEntry>();
                }
            }
        }
        return this.mapOfJobs;
    }

    @Override
    public String createJob() {
        PepperJobImpl job = null;
        SecureRandom random = new SecureRandom();
        String newId = new BigInteger(130, random).toString(32).substring(0, 8);
        while (this.getMapOfJobs().containsKey(newId)) {
            newId = new BigInteger(130, random).toString(32).substring(0, 8);
        }
        job = new PepperJobImpl(newId);
        job.setModuleResolver(this.getModuleResolver());
        job.setConfiguration(this.getConfiguration());
        File jobFolder = new File(this.getConfiguration().getWorkspace().getAbsolutePath() + "/" + newId);
        if (!jobFolder.mkdirs()) {
            logger.warn("Cannot create folder {}. ", (Object)jobFolder);
        }
        this.getMapOfJobs().put(newId, new JobEntry(job, jobFolder));
        return job.getId();
    }

    public Set<String> getJobIds() {
        return this.getMapOfJobs().keySet();
    }

    @Override
    public PepperJob getJob(String id) throws JobNotFoundException {
        return this.getPepperJobImpl(id);
    }

    public PepperJobImpl getPepperJobImpl(String id) throws JobNotFoundException {
        PepperJobImpl job = null;
        JobEntry jobEntry = this.getMapOfJobs().get(id);
        if (jobEntry == null) {
            throw new JobNotFoundException("The Pepper job with id '" + id + "' was not found.");
        }
        job = jobEntry.pepperJob;
        return job;
    }

    @Override
    public boolean removeJob(String id) throws JobNotFoundException {
        boolean retVal = false;
        JobEntry jobEntry = this.getMapOfJobs().get(id);
        if (jobEntry == null) {
            throw new JobNotFoundException("The Pepper job with id '" + id + "' was not found.");
        }
        retVal = jobEntry.location.delete();
        this.getMapOfJobs().remove(id);
        return retVal;
    }

    public File getLocation(String id) throws JobNotFoundException {
        JobEntry jobEntry = this.getMapOfJobs().get(id);
        if (jobEntry == null) {
            throw new JobNotFoundException("The Pepper job with id '" + id + "' was not found.");
        }
        return jobEntry.location;
    }

    public void cleanUp() {
        for (String jobId : this.getMapOfJobs().keySet()) {
            JobEntry jobEntry = this.getMapOfJobs().get(jobId);
            if (jobEntry == null) {
                this.getMapOfJobs().remove(jobId);
            }
            boolean toRemove = true;
            if (jobEntry != null && jobEntry.pepperJob != null && JOB_STATUS.INITIALIZING.equals((Object)jobEntry.pepperJob.getStatus())) {
                toRemove = false;
            }
            if (!toRemove) continue;
            this.removeJob(jobId);
        }
    }

    @Override
    public Collection<PepperModuleDesc> getRegisteredImporters() {
        ArrayList<PepperModuleDesc> retVal = new ArrayList<PepperModuleDesc>();
        if (this.getModuleResolver() == null) {
            throw new PepperFWException("Cannot return registered modules, because the module resolver is missing.");
        }
        List<PepperImporter> importers = this.getModuleResolver().getPepperImporters();
        if (importers != null) {
            for (PepperModule pepperModule : this.getModuleResolver().getPepperImporters()) {
                if (pepperModule == null) continue;
                retVal.add(pepperModule.getFingerprint());
            }
        }
        return retVal;
    }

    @Override
    public Collection<PepperModuleDesc> getRegisteredModules() {
        ArrayList<PepperModuleDesc> retVal = new ArrayList<PepperModuleDesc>();
        if (this.getModuleResolver() == null) {
            throw new PepperFWException("Cannot return registered modules, because the module resolver is missing.");
        }
        if (this.getModuleResolver().getPepperImporters() != null) {
            for (PepperModule pepperModule : this.getModuleResolver().getPepperImporters()) {
                if (pepperModule == null) continue;
                retVal.add(pepperModule.getFingerprint());
            }
        }
        if (this.getModuleResolver().getPepperManipulators() != null) {
            for (PepperModule pepperModule : this.getModuleResolver().getPepperManipulators()) {
                if (pepperModule == null) continue;
                retVal.add(pepperModule.getFingerprint());
            }
        }
        if (this.getModuleResolver().getPepperExporters() != null) {
            for (PepperModule pepperModule : this.getModuleResolver().getPepperExporters()) {
                if (pepperModule == null) continue;
                retVal.add(pepperModule.getFingerprint());
            }
        }
        return retVal;
    }

    public ModuleResolver getModuleResolver() {
        return this.moduleResolver;
    }

    @Reference(unbind="unsetModuleResolver", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setModuleResolver(ModuleResolver moduleResolver) {
        this.moduleResolver = moduleResolver;
        moduleResolver.setConfiguration(this.getConfiguration());
    }

    public void unsetModuleResolver(ModuleResolver moduleResolver) {
        this.moduleResolver = null;
    }

    private Collection<PepperModule> getAllRegisteredModules() {
        ArrayList<PepperModule> modules = new ArrayList<PepperModule>();
        if (this.getModuleResolver() != null) {
            modules.addAll(this.getModuleResolver().getPepperImporters());
            modules.addAll(this.getModuleResolver().getPepperManipulators());
            modules.addAll(this.getModuleResolver().getPepperExporters());
        }
        return modules;
    }

    @Override
    public Collection<ModuleFitness> checkFitness() {
        return new ModuleFitnessChecker(this).checkFitness(this.getAllRegisteredModules());
    }

    @Override
    public Collection<String> selfTest() {
        List<PepperExporter> exporters;
        List<PepperImporter> importers;
        Vector<String> retVal = new Vector<String>();
        if (this.getModuleResolver() == null) {
            retVal.add("Cannot run Pepper, because no PepperModuleResolver was set.");
        }
        if ((importers = this.getModuleResolver().getPepperImporters()) == null || importers.size() == 0) {
            retVal.add("Cannot run Pepper, because no importers were given");
        } else {
            for (PepperImporter importer : importers) {
                try {
                    logger.info("Checking '" + importer.getName() + "'");
                    if (!importer.isReadyToStart()) {
                        retVal.add("A Pepper module '" + importer.getName() + "' is not ready to start.");
                    }
                }
                catch (Exception e) {
                    retVal.add("A Pepper module '" + importer.getName() + "' is not ready to start.");
                }
                if (retVal == null || retVal.size() == 0) {
                    logger.info("ok");
                    continue;
                }
                logger.info("Problems occured in: " + retVal);
            }
        }
        List<PepperManipulator> manipulators = this.getModuleResolver().getPepperManipulators();
        if (manipulators != null && manipulators.size() != 0) {
            for (PepperManipulator manipulator : manipulators) {
                try {
                    logger.info("Checking '" + manipulator.getName() + "'");
                    if (!manipulator.isReadyToStart()) {
                        retVal.add("A Pepper module '" + manipulator.getName() + "' is not ready to start.");
                    }
                }
                catch (Exception e) {
                    retVal.add("A Pepper module '" + manipulator.getName() + "' is not ready to start.");
                }
                if (retVal == null || retVal.size() == 0) {
                    logger.info("ok");
                    continue;
                }
                logger.info("Problems occured in: " + retVal);
            }
        }
        if ((exporters = this.getModuleResolver().getPepperExporters()) == null || exporters.size() == 0) {
            retVal.add("Cannot run Pepper, because no exporters were given");
        } else {
            for (PepperExporter exporter : exporters) {
                try {
                    logger.info("Checking '" + exporter.getName() + "'");
                    if (!exporter.isReadyToStart()) {
                        retVal.add("A Pepper module '" + exporter.getName() + "' is not ready to start.");
                    }
                }
                catch (Exception e) {
                    retVal.add("A Pepper module '" + exporter.getName() + "' is not ready to start.");
                }
                if (retVal == null || retVal.size() == 0) {
                    logger.info("ok");
                    continue;
                }
                logger.info("Problems occured in: " + retVal);
            }
        }
        return retVal;
    }

    @Override
    public String getRegisteredModulesAsString() {
        String retVal = null;
        if (this.getModuleResolver() != null) {
            retVal = this.getModuleResolver().getStatus();
        }
        return retVal;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("pepper");
        str.append("[");
        str.append("registered jobs: ");
        str.append(this.getJobIds().size());
        str.append("]");
        return str.toString();
    }

    static class JobEntry {
        public PepperJobImpl pepperJob = null;
        public File location = null;

        public JobEntry(PepperJobImpl job, File location) {
            this.pepperJob = job;
            this.location = location;
        }
    }
}

