/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.corpus_tools.pepper.core.DocumentBus;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.modules.DocumentController;

public class TerminalDocumentBus
extends DocumentBus {
    protected static final String ID_TERMINAL = "terminal";

    public TerminalDocumentBus(String inputModuleControllerId) {
        super(inputModuleControllerId, ID_TERMINAL);
    }

    public TerminalDocumentBus(List<String> inputModuleControllerIds) {
        super(inputModuleControllerIds, ID_TERMINAL);
    }

    @Override
    public DocumentController pop(String outputControllerId, boolean ignorePermissionForDocument) {
        return this.pop(outputControllerId);
    }

    @Override
    public DocumentController pop(String outputControllerId) {
        DocumentController documentController = null;
        this.lock.lock();
        try {
            ConcurrentLinkedQueue<DocumentController> queue = this.getDocumentBus().get(outputControllerId);
            if (queue == null) {
                throw new PepperFWException("Document bus '" + this.getId() + "' cannot pop a document controller, because there is no entry for module controller '" + outputControllerId + "'.");
            }
            if (queue.isEmpty() && !this.isFinished() && queue.isEmpty() && !this.isFinished()) {
                this.waitUntilAllDocumentsArePut.await();
            }
            if (this.getPepperJob() != null) {
                this.getPepperJob().getPermissionForProcessDoument(documentController);
            }
            documentController = queue.poll();
            documentController.sendToSleep();
        }
        catch (InterruptedException e) {
            throw new PepperFWException("Something went wrong, when waiting for lock 'waitUntilAllDocumentsArePut'.", e);
        }
        finally {
            this.lock.unlock();
        }
        return documentController;
    }
}

