/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDocumentGraphObject;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SMedialDS;
import org.corpus_tools.salt.common.SMedialRelation;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.impl.SDocumentImpl;
import org.corpus_tools.salt.common.tokenizer.Tokenizer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.core.impl.SGraphImpl;
import org.corpus_tools.salt.exceptions.SaltElementNotInGraphException;
import org.corpus_tools.salt.exceptions.SaltInsertionException;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.Difference;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.DataSourceAccessor;
import org.corpus_tools.salt.util.internal.Diff;
import org.corpus_tools.salt.util.internal.GetXBySequence;

public class SDocumentGraphImpl
extends SGraphImpl
implements SDocumentGraph {
    public SDocumentGraphImpl() {
    }

    public SDocumentGraphImpl(Graph delegate) {
        super(delegate);
    }

    @Override
    protected void init() {
        super.init();
        this.getIndexMgr().createIndex("idx_sNodeType", Class.class, Node.class, this.expectedNodes / 2, this.expectedNodes);
        this.getIndexMgr().createIndex("idx_sRelationType", Class.class, Relation.class, this.expectedRelations / 2, this.expectedRelations);
    }

    @Override
    public void addRelation(Relation<? extends SNode, ? extends SNode> relation) {
        if (relation != null) {
            if (!(relation instanceof SRelation)) {
                throw new SaltInsertionException(this, relation, "Cannot insert an relation, which is not a SRelation object.");
            }
            if (Strings.isNullOrEmpty((String)((SRelation)relation).getName())) {
                if (relation instanceof STextualRelation) {
                    ((SRelation)relation).setName("sTextRel" + (this.getTextualRelations().size() + 1));
                } else if (relation instanceof STimelineRelation) {
                    ((SRelation)relation).setName("sTimeRel" + (this.getTimelineRelations().size() + 1));
                } else if (relation instanceof SSpanningRelation) {
                    ((SRelation)relation).setName("sSpanRel" + (this.getSpanningRelations().size() + 1));
                } else if (relation instanceof SPointingRelation) {
                    ((SRelation)relation).setName("sPointingRel" + (this.getPointingRelations().size() + 1));
                } else if (relation instanceof SDominanceRelation) {
                    ((SRelation)relation).setName("sDomRel" + (this.getDominanceRelations().size() + 1));
                } else if (relation instanceof SMedialRelation) {
                    ((SRelation)relation).setName("sAudioRel" + (this.getMedialRelations().size() + 1));
                } else if (relation instanceof SOrderRelation) {
                    ((SRelation)relation).setName("sOrderRel" + (this.getOrderRelations().size() + 1));
                } else {
                    ((SRelation)relation).setName("sRel" + (this.getRelations().size() + 1));
                }
            }
            ((SRelation)relation).setId(this.getId() + "#" + ((SRelation)relation).getName());
            super.addRelation(relation);
            Class key = relation instanceof STextualRelation ? STextualRelation.class : (relation instanceof STimelineRelation ? STimelineRelation.class : (relation instanceof SSpanningRelation ? SSpanningRelation.class : (relation instanceof SPointingRelation ? SPointingRelation.class : (relation instanceof SDominanceRelation ? SDominanceRelation.class : (relation instanceof SMedialRelation ? SMedialRelation.class : (relation instanceof SOrderRelation ? SOrderRelation.class : relation.getClass()))))));
            this.getIndexMgr().put("idx_sRelationType", key, relation);
        }
    }

    @Override
    public void addNode(SNode node) {
        if (this.getIndexMgr().containsKey("idx_id_nodes_inverse", node)) {
            return;
        }
        if (node != null) {
            if (Strings.isNullOrEmpty((String)node.getName())) {
                if (node instanceof STextualDS) {
                    node.setName("sText" + (this.getTextualDSs().size() + 1));
                } else if (node instanceof SToken) {
                    node.setName("sTok" + (this.getTokens().size() + 1));
                } else if (node instanceof STimeline) {
                    node.setName("sTimeline" + (this.getTokens().size() + 1));
                } else if (node instanceof SSpan) {
                    node.setName("sSpan" + (this.getSpans().size() + 1));
                } else if (node instanceof SStructure) {
                    node.setName("structure" + (this.getStructures().size() + 1));
                } else if (node instanceof SMedialDS) {
                    node.setName("audio" + (this.getMedialDSs().size() + 1));
                } else {
                    node.setName("sNode" + (this.getNodes().size() + 1));
                }
            }
            if (Strings.isNullOrEmpty((String)node.getId())) {
                node.setId(this.getId() + "#" + node.getName());
            }
            super.addNode(node);
            Class key = node instanceof SToken ? SToken.class : (node instanceof STextualDS ? STextualDS.class : (node instanceof STimeline ? STimeline.class : (node instanceof SSpan ? SSpan.class : (node instanceof SStructure ? SStructure.class : (node instanceof SMedialDS ? SMedialDS.class : node.getClass())))));
            this.getIndexMgr().put("idx_sNodeType", key, node);
        }
    }

    @Override
    public SDocument getDocument() {
        SDocument retVal = null;
        SFeature sFeature = this.getFeature("salt::SDOCUMENT");
        if (sFeature != null) {
            retVal = (SDocument)sFeature.getValue();
        }
        return retVal;
    }

    @Override
    public void setDocument(SDocument document) {
        SDocument oldDocument = this.getDocument();
        if (oldDocument != null && oldDocument != document && oldDocument instanceof SDocumentImpl) {
            ((SDocumentImpl)oldDocument).basic_setDocumentGraph(null);
        }
        if (document != null && document instanceof SDocumentImpl) {
            ((SDocumentImpl)document).basic_setDocumentGraph(this);
        }
        this.basic_setDocument(document);
    }

    public void basic_setDocument(SDocument document) {
        SFeature sFeature = this.getFeature("salt::SDOCUMENT");
        if (sFeature == null) {
            sFeature = SaltFactory.createSFeature();
            sFeature.setNamespace("salt");
            sFeature.setName("SDOCUMENT");
            this.addFeature(sFeature);
        }
        sFeature.setValue(document);
    }

    @Override
    public List<STextualDS> getTextualDSs() {
        List<STextualDS> retVal = this.getIndexMgr().getAll("idx_sNodeType", STextualDS.class);
        if (retVal == null) {
            retVal = new ArrayList<STextualDS>();
        }
        return retVal;
    }

    @Override
    public List<SRelation> getRelations(SALT_TYPE type) {
        List<SRelation> relations = null;
        relations = this.getRelations(type.getJavaType());
        return relations;
    }

    @Override
    public List<SRelation> getRelations(Class<?> clazz) {
        List<SRelation> relations = null;
        relations = this.getIndexMgr().getAll("idx_sRelationType", clazz);
        return relations;
    }

    @Override
    public List<SNode> getNodes(SALT_TYPE type) {
        List<SNode> nodes = null;
        nodes = this.getNodes(type.getJavaType());
        return nodes;
    }

    @Override
    public List<SNode> getNodes(Class<?> clazz) {
        List<SNode> nodes = null;
        nodes = this.getIndexMgr().getAll("idx_sNodeType", clazz);
        return nodes;
    }

    @Override
    public List<STextualRelation> getTextualRelations() {
        List<STextualRelation> retVal = this.getIndexMgr().getAll("idx_sRelationType", STextualRelation.class);
        if (retVal == null) {
            retVal = new ArrayList<STextualRelation>();
        }
        return retVal;
    }

    @Override
    public List<SToken> getTokens() {
        List<SToken> retVal = this.getIndexMgr().getAll("idx_sNodeType", SToken.class);
        if (retVal == null) {
            retVal = new ArrayList<SToken>();
        }
        return retVal;
    }

    @Override
    public STimeline getTimeline() {
        return (STimeline)this.getIndexMgr().get("idx_sNodeType", STimeline.class);
    }

    @Override
    public void setTimeline(STimeline value) {
        this.addNode(value);
    }

    @Override
    public List<STimelineRelation> getTimelineRelations() {
        List<STimelineRelation> retVal = this.getIndexMgr().getAll("idx_sRelationType", STimelineRelation.class);
        if (retVal == null) {
            retVal = new ArrayList<STimelineRelation>();
        }
        return retVal;
    }

    @Override
    public List<SSpanningRelation> getSpanningRelations() {
        List<SSpanningRelation> retVal = this.getIndexMgr().getAll("idx_sRelationType", SSpanningRelation.class);
        if (retVal == null) {
            retVal = new ArrayList<SSpanningRelation>();
        }
        return retVal;
    }

    @Override
    public List<SSpan> getSpans() {
        List<SSpan> retVal = this.getIndexMgr().getAll("idx_sNodeType", SSpan.class);
        if (retVal == null) {
            retVal = new ArrayList<SSpan>();
        }
        return retVal;
    }

    @Override
    public List<SStructure> getStructures() {
        List<SStructure> retVal = this.getIndexMgr().getAll("idx_sNodeType", SStructure.class);
        if (retVal == null) {
            retVal = new ArrayList<SStructure>();
        }
        return retVal;
    }

    @Override
    public List<SDominanceRelation> getDominanceRelations() {
        List<SDominanceRelation> retVal = this.getIndexMgr().getAll("idx_sRelationType", SDominanceRelation.class);
        if (retVal == null) {
            retVal = new ArrayList<SDominanceRelation>();
        }
        return retVal;
    }

    @Override
    public List<SPointingRelation> getPointingRelations() {
        List<SPointingRelation> retVal = this.getIndexMgr().getAll("idx_sRelationType", SPointingRelation.class);
        if (retVal == null) {
            retVal = new ArrayList<SPointingRelation>();
        }
        return retVal;
    }

    @Override
    public List<SMedialRelation> getMedialRelations() {
        List<SMedialRelation> retVal = this.getIndexMgr().getAll("idx_sRelationType", SMedialRelation.class);
        if (retVal == null) {
            retVal = new ArrayList<SMedialRelation>();
        }
        return retVal;
    }

    @Override
    public List<SMedialDS> getMedialDSs() {
        List<SMedialDS> retVal = this.getIndexMgr().getAll("idx_sNodeType", SMedialDS.class);
        if (retVal == null) {
            retVal = new ArrayList<SMedialDS>();
        }
        return retVal;
    }

    @Override
    public List<SOrderRelation> getOrderRelations() {
        List<SOrderRelation> retVal = this.getIndexMgr().getAll("idx_sRelationType", SOrderRelation.class);
        if (retVal == null) {
            retVal = new ArrayList<SOrderRelation>();
        }
        return retVal;
    }

    @Override
    public SRelation addNode(SNode source, SNode target, SALT_TYPE sRelationType) {
        if (!this.getNodes().contains(source)) {
            throw new SaltElementNotInGraphException(this, source, "Given SNode cannot be used as source node, because it is not contained in the SDocumentGraph");
        }
        SDocumentGraphObject retVal = null;
        switch (sRelationType) {
            case STEXTUAL_RELATION: {
                retVal = SaltFactory.createSTextualRelation();
                break;
            }
            case SPOINTING_RELATION: {
                retVal = SaltFactory.createSPointingRelation();
                break;
            }
            case SSPANNING_RELATION: {
                retVal = SaltFactory.createSSpanningRelation();
                break;
            }
            case SDOMINANCE_RELATION: {
                retVal = SaltFactory.createSDominanceRelation();
                break;
            }
        }
        if (retVal == null) {
            throw new SaltParameterException("Improper STYPE_NAME for this method; must be one of STEXTUAL_RELATION, SPOINTING_RELATION, SSPANNING_RELATION and SDOMINANCE_RELATION.");
        }
        retVal.setSource(source);
        retVal.setTarget(target);
        if (!this.getNodes().contains(target)) {
            this.addNode(target);
        }
        this.addRelation((Relation<? extends SNode, ? extends SNode>)((Object)retVal));
        return retVal;
    }

    @Override
    public STextualDS createTextualDS(String text) {
        STextualDS sTextualDS = SaltFactory.createSTextualDS();
        sTextualDS.setText(text);
        this.addNode(sTextualDS);
        return sTextualDS;
    }

    @Override
    public SToken createToken(List<DataSourceSequence> sequences) {
        if (sequences == null) {
            throw new SaltParameterException("sDSSequences", "addSToken", this.getClass());
        }
        if (sequences.size() > 0) {
            SToken sToken = SaltFactory.createSToken();
            this.addNode(sToken);
            for (DataSourceSequence sequence : sequences) {
                this.addToken(sToken, sequence);
            }
            return sToken;
        }
        return null;
    }

    @Override
    public SToken createToken(SSequentialDS sequentialDS, Integer start, Integer end) {
        if (sequentialDS == null) {
            throw new SaltParameterException("sequentialDS", "createToken", this.getClass(), "The passed sequentialDS is empty. ");
        }
        if (sequentialDS.getId() == null || !this.containsNode(sequentialDS.getId())) {
            throw new SaltInsertionException(this, sequentialDS, "The passed sequentialDS does not belong to this document graph. ");
        }
        SToken sTok = SaltFactory.createSToken();
        DataSourceSequence<Integer> sequence = new DataSourceSequence<Integer>();
        sequence.setStart(start);
        sequence.setEnd(end);
        sequence.setDataSource(sequentialDS);
        this.addToken(sTok, sequence);
        return sTok;
    }

    private void addToken(SToken token, DataSourceSequence sequence) {
        if (sequence == null) {
            throw new SaltParameterException("sDSSequence", "addSToken", this.getClass());
        }
        if (sequence.getDataSource() == null) {
            throw new SaltParameterException("sDSSequences.getSSequentialDS()", "addSToken", this.getClass());
        }
        if (sequence.getStart() == null) {
            throw new SaltParameterException("sDSSequences.getSStart()", "addSToken", this.getClass());
        }
        if (sequence.getEnd() == null) {
            throw new SaltParameterException("sDSSequences.getSEnd()", "addSToken", this.getClass());
        }
        if (token.getId() == null || this.getNode(token.getId()) == null) {
            this.addNode(token);
        }
        SDocumentGraphObject seqRel = null;
        if (sequence.getDataSource() instanceof STextualDS) {
            seqRel = SaltFactory.createSTextualRelation();
            seqRel.setTarget((STextualDS)sequence.getDataSource());
        } else if (sequence.getDataSource() instanceof STimeline) {
            seqRel = SaltFactory.createSTimelineRelation();
            ((STimelineRelation)seqRel).setTarget((STimeline)sequence.getDataSource());
        }
        if (seqRel != null) {
            seqRel.setSource(token);
            seqRel.setStart(sequence.getStart());
            seqRel.setEnd(sequence.getEnd());
            this.addRelation((Relation<? extends SNode, ? extends SNode>)((Object)seqRel));
        }
    }

    @Override
    public SToken createToken(DataSourceSequence sDSSequence) {
        SToken sToken = SaltFactory.createSToken();
        this.addNode(sToken);
        this.addToken(sToken, sDSSequence);
        return sToken;
    }

    @Override
    public SSpan createSpan(List<SToken> tokens) {
        if (SaltUtil.isNotNullOrEmpty(tokens)) {
            return this.createSpan(tokens.toArray(new SToken[tokens.size()]));
        }
        return null;
    }

    @Override
    public SSpan createSpan(SToken ... tokens) {
        SSpan retVal = null;
        if (tokens != null) {
            for (SToken sToken : tokens) {
                if (sToken == null) continue;
                if (retVal == null) {
                    retVal = SaltFactory.createSSpan();
                    this.addNode(retVal);
                }
                SSpanningRelation sSpanRel = SaltFactory.createSSpanningRelation();
                sSpanRel.setSource(retVal);
                sSpanRel.setTarget(sToken);
                this.addRelation(sSpanRel);
            }
        }
        return retVal;
    }

    @Override
    public SStructure createStructure(List<SStructuredNode> sourceNodes) {
        if (SaltUtil.isNotNullOrEmpty(sourceNodes)) {
            return this.createStructure(sourceNodes.toArray(new SStructuredNode[sourceNodes.size()]));
        }
        return null;
    }

    @Override
    public SStructure createStructure(SStructuredNode ... structures) {
        SStructure retVal = null;
        if (structures != null) {
            for (SStructuredNode sStructuredNode : structures) {
                if (sStructuredNode == null) continue;
                if (retVal == null) {
                    retVal = SaltFactory.createSStructure();
                    this.addNode(retVal);
                }
                SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
                sDomRel.setSource(retVal);
                sDomRel.setTarget(sStructuredNode);
                this.addRelation(sDomRel);
            }
        }
        return retVal;
    }

    @Override
    public STimeline createTimeline() {
        STimeline retVal = null;
        if (this.getTimeline() == null || (Integer)this.getTimeline().getEnd() == 0) {
            STimeline sTimeline = SaltFactory.createSTimeline();
            this.addNode(sTimeline);
            ArrayList sTimeRelList = new ArrayList();
            Hashtable sTimeRelTable = new Hashtable();
            for (STextualRelation sTextRel : this.getTextualRelations()) {
                STimelineRelation sTimeRel = SaltFactory.createSTimelineRelation();
                sTimeRel.setTarget(sTimeline);
                sTimeRel.setSource(sTextRel.getSource());
                if (sTimeRelTable.get(sTextRel.getTarget()) == null) {
                    sTimeRelTable.put(sTextRel.getTarget(), new ArrayList());
                }
                ((List)sTimeRelTable.get(sTextRel.getTarget())).add(sTimeRel);
            }
            for (STextualDS sTextualDS : this.getTextualDSs()) {
                sTimeRelList.addAll((Collection)sTimeRelTable.get(sTextualDS));
            }
            Integer pot = 0;
            for (STimelineRelation sTimeRelation : sTimeRelList) {
                sTimeRelation.setStart(pot);
                Integer n = pot;
                Integer n2 = pot = Integer.valueOf(pot + 1);
                sTimeline.increasePointOfTime();
                sTimeRelation.setEnd(pot);
                this.addRelation(sTimeRelation);
            }
            retVal = sTimeline;
        } else {
            retVal = this.getTimeline();
        }
        return retVal;
    }

    @Override
    public STimelineRelation createTimelineRelation(SToken token, int timeSteps) {
        STimeline timeline = this.getTimeline();
        int timelineEnd = timeline.getEnd() == null ? 0 : (Integer)timeline.getEnd();
        STimelineRelation timeLineRel = SaltFactory.createSTimelineRelation();
        timeLineRel.setSource(token);
        timeLineRel.setTarget(timeline);
        timeLineRel.setStart(timeline.getEnd());
        timeLineRel.setEnd(timelineEnd += timeSteps);
        this.addRelation(timeLineRel);
        return timeLineRel;
    }

    @Override
    public List<SToken> getTokensBySequence(DataSourceSequence sequence) {
        return new GetXBySequence(this).getTokensBySequence(sequence);
    }

    @Override
    public List<SSpan> getSpansBySequence(DataSourceSequence sequence) {
        return new GetXBySequence(this).getSpanBySequence(sequence);
    }

    @Override
    public List<SStructure> getStructuresBySequence(DataSourceSequence sequence) {
        return new GetXBySequence(this).getStructureBySequence(sequence);
    }

    @Override
    public List<SNode> getNodesBySequence(DataSourceSequence sequence) {
        return new GetXBySequence(this).getNodeBySequence(sequence);
    }

    @Override
    public List<DataSourceSequence> getOverlappedDataSourceSequence(SNode node, SALT_TYPE ... relationTypes) {
        return DataSourceAccessor.getOverlappedDataSourceSequence((SDocumentGraph)this, node, relationTypes);
    }

    @Override
    public List<DataSourceSequence> getOverlappedDataSourceSequence(List<SNode> nodes, SALT_TYPE ... relationTypes) {
        return DataSourceAccessor.getOverlappedDataSourceSequence((SDocumentGraph)this, nodes, relationTypes);
    }

    @Override
    public boolean isContinuousByText(List<SNode> subNodeList, List<SNode> fullNodeList) {
        return DataSourceAccessor.isContinuousByText(this, subNodeList, fullNodeList);
    }

    @Override
    public boolean isContinuousByText(List<SNode> subNodeList) {
        return DataSourceAccessor.isContinuousByText(this, subNodeList);
    }

    @Override
    public List<SToken> getSortedTokenByText(List<SToken> tokens2sort) {
        return DataSourceAccessor.getSortedSTokenByText(this, tokens2sort);
    }

    @Override
    public List<SToken> getSortedTokenByText() {
        return DataSourceAccessor.getSortedSTokenByText(this);
    }

    @Override
    public void sortTokenByText() {
        DataSourceAccessor.sortSTokenByText(this);
    }

    @Override
    public List<SNode> getRootsByRelation(SALT_TYPE ... type) {
        return DataSourceAccessor.getRootsByRelation(this, type);
    }

    @Override
    public Multimap<String, SNode> getRootsByRelationType(SALT_TYPE type) {
        return DataSourceAccessor.getRootsByRelationType((SDocumentGraph)this, type);
    }

    @Override
    public List<SToken> tokenize() {
        ArrayList<SToken> retVal = null;
        if (this.getTextualDSs().size() > 0) {
            Tokenizer tokenizer = this.createTokenizer();
            for (STextualDS sTextualDS : this.getTextualDSs()) {
                if (sTextualDS == null) continue;
                if (retVal == null) {
                    retVal = new ArrayList<SToken>();
                }
                retVal.addAll(tokenizer.tokenize(sTextualDS));
            }
        }
        return retVal;
    }

    @Override
    public Tokenizer createTokenizer() {
        Tokenizer tokenizer = new Tokenizer();
        tokenizer.setsDocumentGraph(this);
        return tokenizer;
    }

    @Override
    public SToken insertTokenAt(STextualDS sTextualDS, Integer posInText, String text, Boolean insertSpace) {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(text);
        return this.insertTokensAt(sTextualDS, posInText, texts, insertSpace).get(0);
    }

    @Override
    public List<SToken> insertTokensAt(STextualDS sTextualDS, Integer posInText, List<String> texts, Boolean insertSpace) {
        ArrayList<SToken> sTokens = new ArrayList<SToken>();
        HashSet<STextualRelation> newSTextualRelations = new HashSet<STextualRelation>();
        StringBuilder newSTextualDSvalueBuilder = new StringBuilder(sTextualDS.getText().substring(0, posInText));
        int sizeOfnewTexts = newSTextualDSvalueBuilder.length();
        for (String text : texts) {
            Integer start = newSTextualDSvalueBuilder.length();
            newSTextualDSvalueBuilder.append(text);
            Integer end = newSTextualDSvalueBuilder.length();
            SToken sTok = SaltFactory.createSToken();
            this.addNode(sTok);
            sTokens.add(sTok);
            STextualRelation sTextRel = SaltFactory.createSTextualRelation();
            sTextRel.setStart(start);
            sTextRel.setEnd(end);
            sTextRel.setSource(sTok);
            sTextRel.setTarget(sTextualDS);
            this.addRelation(sTextRel);
            newSTextualRelations.add(sTextRel);
            if (!insertSpace.booleanValue()) continue;
            newSTextualDSvalueBuilder.append(" ");
        }
        sizeOfnewTexts = newSTextualDSvalueBuilder.length() - sizeOfnewTexts;
        newSTextualDSvalueBuilder.append(sTextualDS.getText().substring(posInText));
        sTextualDS.setText(newSTextualDSvalueBuilder.toString());
        for (STextualRelation sTextualRelation : this.getTextualRelations()) {
            if (newSTextualRelations.contains(sTextualRelation)) continue;
            if ((Integer)sTextualRelation.getStart() >= posInText) {
                sTextualRelation.setStart((Integer)sTextualRelation.getStart() + sizeOfnewTexts);
            }
            if ((Integer)sTextualRelation.getEnd() <= posInText) continue;
            sTextualRelation.setEnd((Integer)sTextualRelation.getEnd() + sizeOfnewTexts);
        }
        return sTokens;
    }

    @Override
    public SRelation createRelation(SNode sSource, SNode sTarget, SALT_TYPE sRelationType, String sAnnotations) {
        if (sSource == null) {
            throw new SaltParameterException("Cannot create an Srelation, because the passed source node is null.");
        }
        if (sTarget == null) {
            throw new SaltParameterException("Cannot create an Srelation, because the passed target node is null.");
        }
        if (sRelationType == null) {
            throw new SaltParameterException("Cannot create an Srelation, because the type of relation is null.");
        }
        SRelation<SStructuredNode, SStructuredNode> sRel = null;
        switch (sRelationType) {
            case SPOINTING_RELATION: {
                sRel = SaltFactory.createSPointingRelation();
                break;
            }
            case SSPANNING_RELATION: {
                sRel = SaltFactory.createSSpanningRelation();
                break;
            }
            case SDOMINANCE_RELATION: {
                sRel = SaltFactory.createSDominanceRelation();
                break;
            }
            case SORDER_RELATION: {
                sRel = SaltFactory.createSOrderRelation();
                break;
            }
            default: {
                throw new SaltParameterException("Cannot create an SRelation, because the passed type '" + (Object)((Object)sRelationType) + "' is not supported for this method.");
            }
        }
        try {
            sRel.setSource((SStructuredNode)sSource);
            sRel.setTarget((SStructuredNode)sTarget);
        }
        catch (Exception e) {
            throw new SaltParameterException("Cannot create an SRelation for the passed type '" + (Object)((Object)sRelationType) + "', because of a nested exception. It might be, that the passed type is not compatible to the types of passed sSource '" + sSource.getClass() + "' or sTarget node '" + sTarget.getClass() + "'.");
        }
        this.addRelation((Relation<? extends SNode, ? extends SNode>)sRel);
        sRel.createAnnotations(sAnnotations);
        return sRel;
    }

    @Override
    public List<SToken> getOverlappedTokens(SNode overlappingNode) {
        return DataSourceAccessor.getOverlappedSTokens(this, overlappingNode, SALT_TYPE.STEXT_OVERLAPPING_RELATION);
    }

    @Override
    public List<SToken> getOverlappedTokens(SNode overlappingNode, SALT_TYPE ... relationTypes) {
        return DataSourceAccessor.getOverlappedSTokens(this, overlappingNode, relationTypes);
    }

    @Override
    public String getText(SNode sNode) {
        if (sNode == null) {
            return null;
        }
        if (this.getOverlappedDataSourceSequence(sNode, SALT_TYPE.STEXT_OVERLAPPING_RELATION) == null) {
            return null;
        }
        DataSourceSequence sData = this.getOverlappedDataSourceSequence(sNode, SALT_TYPE.STEXT_OVERLAPPING_RELATION).get(0);
        return ((STextualDS)sData.getDataSource()).getText().substring((Integer)sData.getStart(), (Integer)sData.getEnd());
    }

    @Override
    public boolean isIsomorph(SDocumentGraph other) {
        Diff diff = new Diff(this, other);
        return diff.isIsomorph();
    }

    @Override
    public boolean isIsomorph(SDocumentGraph other, DiffOptions options) {
        Diff diff = new Diff((SDocumentGraph)this, other, options);
        return diff.isIsomorph();
    }

    @Override
    public Set<Difference> findDiffs(SDocumentGraph other) {
        Diff diff = new Diff(this, other);
        return diff.findDiffs();
    }

    @Override
    public Set<Difference> findDiffs(SDocumentGraph other, DiffOptions options) {
        Diff diff = new Diff((SDocumentGraph)this, other, options);
        return diff.findDiffs();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName());
        str.append("(");
        str.append(this.getId());
        str.append(")");
        return str.toString();
    }
}

