/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util;

import java.io.Serializable;
import java.util.Comparator;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSequentialRelation;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltParameterException;

public class TokenStartComparator
implements Comparator<SToken>,
Serializable {
    private SDocumentGraph documentGraph = null;

    public SDocumentGraph getDocumentGraph() {
        return this.documentGraph;
    }

    public void setDocumentGraph(SDocumentGraph documentGraph) {
        this.documentGraph = documentGraph;
    }

    @Override
    public int compare(SToken o1, SToken o2) {
        int retVal = 0;
        if (o1 == null) {
            throw new SaltParameterException("Cannot compare the given SToken-objects, bacause first one is null.");
        }
        if (o2 == null) {
            throw new SaltParameterException("Cannot compare the given SToken-objects, bacause second one is null.");
        }
        STextualRelation sTextRelO1 = null;
        for (SRelation rel : this.getDocumentGraph().getOutRelations(o1.getId())) {
            if (!(rel instanceof STextualRelation)) continue;
            sTextRelO1 = (STextualRelation)rel;
            break;
        }
        SSequentialRelation sTextRelO2 = null;
        for (SRelation rel : this.getDocumentGraph().getOutRelations(o2.getId())) {
            if (!(rel instanceof STextualRelation)) continue;
            sTextRelO2 = (STextualRelation)rel;
            break;
        }
        if (sTextRelO1 != null && sTextRelO2 != null) {
            if (((Integer)sTextRelO1.getStart()).equals(sTextRelO2.getStart())) {
                retVal = 0;
            } else if ((Integer)sTextRelO1.getStart() < (Integer)sTextRelO2.getStart()) {
                retVal = -1;
            } else if ((Integer)sTextRelO1.getStart() > (Integer)sTextRelO2.getStart()) {
                retVal = 1;
            }
        }
        return retVal;
    }
}

