/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.core.internal.AbstractComparisonStrategy;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.IterableUtil;

public class ComparatorBasedComparisonStrategy
extends AbstractComparisonStrategy {
    private static final StandardRepresentation STANDARD_REPRESENTATION = new StandardRepresentation();
    private final Comparator comparator;

    public ComparatorBasedComparisonStrategy(Comparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean iterableContains(Iterable<?> iterable, Object value) {
        if (IterableUtil.isNullOrEmpty(iterable)) {
            return false;
        }
        for (Object element : iterable) {
            if (element == value) {
                return true;
            }
            if (value == null || element == null || this.comparator.compare(element, value) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void iterableRemoves(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            if (this.comparator.compare(iterator.next(), value) != 0) continue;
            iterator.remove();
        }
    }

    @Override
    public void iterablesRemoveFirst(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            if (this.comparator.compare(iterator.next(), value) != 0) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        if (actual == null) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        return this.comparator.compare(actual, other) == 0;
    }

    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        return super.duplicatesFrom(iterable);
    }

    @Override
    protected Set<Object> newSetUsingComparisonStrategy() {
        return new TreeSet<Object>(this.comparator);
    }

    @Override
    public String asText() {
        return "when comparing values using " + STANDARD_REPRESENTATION.toStringOf(this.comparator);
    }

    public String toString() {
        return STANDARD_REPRESENTATION.toStringOf(this.comparator);
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    @Override
    public boolean stringStartsWith(String string, String prefix) {
        if (string.length() < prefix.length()) {
            return false;
        }
        String stringPrefix = string.substring(0, prefix.length());
        return this.comparator.compare(stringPrefix, prefix) == 0;
    }

    @Override
    public boolean stringEndsWith(String string, String suffix) {
        if (string.length() < suffix.length()) {
            return false;
        }
        String stringSuffix = string.substring(string.length() - suffix.length());
        return this.comparator.compare(stringSuffix, suffix) == 0;
    }

    @Override
    public boolean stringContains(String string, String sequence) {
        int sequenceLength = sequence.length();
        for (int i = 0; i < string.length(); ++i) {
            String subString = string.substring(i);
            if (subString.length() < sequenceLength) {
                return false;
            }
            if (!this.stringStartsWith(subString, sequence)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGreaterThan(Object actual, Object other) {
        return this.comparator.compare(actual, other) > 0;
    }

    @Override
    public boolean isStandard() {
        return false;
    }
}

