/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.corpus_tools.pepper.common.MEMORY_POLICY;
import org.corpus_tools.pepper.core.PepperJobImpl;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.modules.DocumentController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentBus {
    private static final Logger logger = LoggerFactory.getLogger(DocumentBus.class);
    protected List<String> outputModuleControllerIds = null;
    protected List<String> inputModuleControllerIds = null;
    protected String id = null;
    private PepperJobImpl pepperJob = null;
    protected volatile Hashtable<String, ConcurrentLinkedQueue<DocumentController>> documentBus = null;
    protected volatile MEMORY_POLICY memPolicy = MEMORY_POLICY.MODERATE;
    protected ReentrantLock lock = new ReentrantLock(true);
    protected Condition waitUntilAllDocumentsArePut = this.lock.newCondition();

    public DocumentBus(String inputModuleControllerId, String outputModuleControllerId) {
        Vector<String> inputModuleControllerIds = new Vector<String>();
        inputModuleControllerIds.add(inputModuleControllerId);
        Vector<String> outputModuleControllerIds = new Vector<String>();
        outputModuleControllerIds.add(outputModuleControllerId);
        this.init(inputModuleControllerIds, outputModuleControllerIds);
    }

    public DocumentBus(String inputModuleControllerId, List<String> outputModuleControllerIds) {
        Vector<String> inputModuleControllerIds = new Vector<String>();
        inputModuleControllerIds.add(inputModuleControllerId);
        this.init(inputModuleControllerIds, outputModuleControllerIds);
    }

    public DocumentBus(List<String> inputModuleControllerIds, String outputModuleControllerId) {
        Vector<String> outputModuleControllerIds = new Vector<String>();
        outputModuleControllerIds.add(outputModuleControllerId);
        this.init(inputModuleControllerIds, outputModuleControllerIds);
    }

    public DocumentBus(List<String> inputModuleControllerIds, List<String> outputModuleControllerIds) {
        this.init(inputModuleControllerIds, outputModuleControllerIds);
    }

    protected void init(List<String> inputModuleControllerIds, List<String> outputModuleControllerIds) {
        if (inputModuleControllerIds == null || inputModuleControllerIds.isEmpty()) {
            throw new PepperFWException("Cannot create a document bus with an empty list of input module controllers.");
        }
        if (outputModuleControllerIds == null || outputModuleControllerIds.isEmpty()) {
            throw new PepperFWException("Cannot create a document bus with an empty list of output module controllers.");
        }
        this.inputModuleControllerIds = new Vector<String>();
        for (String inputControllerId : inputModuleControllerIds) {
            this.inputModuleControllerIds.add(inputControllerId);
        }
        this.outputModuleControllerIds = new Vector<String>();
        for (String outputControllerId : outputModuleControllerIds) {
            this.outputModuleControllerIds.add(outputControllerId);
        }
        this.initDocumentBus(outputModuleControllerIds);
        StringBuilder str = new StringBuilder();
        if (this.getInputControllerIds() != null && this.getInputControllerIds().size() != 0) {
            int i = 0;
            for (String id : this.getInputControllerIds()) {
                str.append(id);
                if (++i >= this.getInputControllerIds().size()) continue;
                str.append(", ");
            }
        } else {
            str.append("EMPTY");
        }
        str.append(" ==> ");
        if (this.getOutputControllerIds() != null && this.getOutputControllerIds().size() != 0) {
            int i = 0;
            for (String id : this.getOutputControllerIds()) {
                str.append(id);
                if (++i >= this.getOutputControllerIds().size()) continue;
                str.append(", ");
            }
        } else {
            str.append("EMPTY");
        }
        this.id = str.toString();
    }

    public List<String> getOutputControllerIds() {
        return this.outputModuleControllerIds;
    }

    public List<String> getInputControllerIds() {
        return this.inputModuleControllerIds;
    }

    public String getId() {
        return this.id;
    }

    public PepperJobImpl getPepperJob() {
        return this.pepperJob;
    }

    public void setPepperJob(PepperJobImpl pepperJob) {
        this.pepperJob = pepperJob;
    }

    public Hashtable<String, ConcurrentLinkedQueue<DocumentController>> getDocumentBus() {
        return this.documentBus;
    }

    protected void initDocumentBus(List<String> outputModuleControllerIds) {
        this.documentBus = new Hashtable();
        for (String controllerId : outputModuleControllerIds) {
            ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
            this.documentBus.put(controllerId, queue);
        }
    }

    public MEMORY_POLICY getMemPolicy() {
        return this.memPolicy;
    }

    public void setMemPolicy(MEMORY_POLICY memPolicy) {
        this.memPolicy = memPolicy;
    }

    public void finish(String inputControllerId) {
        if (inputControllerId == null || inputControllerId.isEmpty()) {
            throw new PepperFWException("Cannot finish PepperModuleController for document queue, because given id is null.");
        }
        if (!this.inputModuleControllerIds.contains(inputControllerId)) {
            throw new PepperFWException("Cannot finish PepperModuleController for document queue, because  to document queue, because the given id '" + inputControllerId + "' is not contained in input list of document queue.");
        }
        this.lock.lock();
        try {
            this.inputModuleControllerIds.remove(inputControllerId);
            if (this.inputModuleControllerIds.size() == 0) {
                this.waitUntilAllDocumentsArePut.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isFinished() {
        return this.inputModuleControllerIds.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(DocumentController documentController) {
        if (documentController == null) {
            throw new PepperFWException("Cannot add a null value as DocumentController into documentBus.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[Pepper] new document '{}' added to document bus. Following documents are waiting in document bus '{}': '{}'... ", new Object[]{documentController.getGlobalId(), this.getId(), this.getDocumentBus().values()});
        }
        if (MEMORY_POLICY.THRIFTY.equals((Object)this.getMemPolicy())) {
            if (this.getPepperJob() != null) {
                documentController.sendToSleep();
                this.getPepperJob().releaseDocument(documentController);
            }
        } else if (MEMORY_POLICY.MODERATE.equals((Object)this.getMemPolicy()) && this.getPepperJob() != null) {
            documentController.sendToSleep();
            this.getPepperJob().releaseDocument(documentController);
        }
        this.lock.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("[Pepper] blocking lock for new document '{}' in document bus {}. ", (Object)documentController.getGlobalId(), (Object)this.getId());
            }
            Collection<ConcurrentLinkedQueue<DocumentController>> queues = this.getDocumentBus().values();
            for (ConcurrentLinkedQueue<DocumentController> queue : queues) {
                queue.add(documentController);
            }
            this.waitUntilAllDocumentsArePut.signalAll();
        }
        finally {
            this.lock.unlock();
            if (logger.isTraceEnabled()) {
                logger.trace("[Pepper] unlocked lock for new document '{}' in document bus '{}'. ", (Object)documentController.getGlobalId(), (Object)this.getId());
            }
        }
    }

    public DocumentController pop(String outputControllerId) {
        return this.pop(outputControllerId, false);
    }

    public DocumentController pop(String outputControllerId, boolean ignorePermissionForDocument) {
        DocumentController documentController = null;
        if (logger.isDebugEnabled()) {
            logger.debug("[Pepper] remove document for controller {} from document bus. Following documents are still waiting in bus: '{}'... ", (Object)outputControllerId, this.getDocumentBus().values());
        }
        this.lock.lock();
        try {
            logger.trace("[Pepper] blocking lock for remove document for controller {} in document bus {}. ", (Object)outputControllerId, (Object)this.getId());
            ConcurrentLinkedQueue<DocumentController> queue = this.getDocumentBus().get(outputControllerId);
            if (queue == null) {
                throw new PepperFWException("Document bus '" + this.getId() + "' cannot pop a document controller, because there is no entry for module controller '" + outputControllerId + "'.");
            }
            if (queue.size() == 0 && !this.isFinished()) {
                logger.trace("[Pepper] start waiting for condition 'waitUntilAllDocumentsArePut' in DocumentBus {} in pop({}). ", (Object)this.getId(), (Object)outputControllerId);
                this.waitUntilAllDocumentsArePut.await();
                logger.trace("[Pepper] ended waiting for condition 'waitUntilAllDocumentsArePut' in DocumentBus {} in pop({}). ", (Object)this.getId(), (Object)outputControllerId);
            }
            documentController = queue.poll();
            if (!ignorePermissionForDocument && documentController != null && documentController.isAsleep()) {
                if (this.getPepperJob() != null) {
                    logger.debug("[Pepper] waiting for permission to wake up document '{}' for module '{}' in document bus '{}'... ", new Object[]{documentController.getGlobalId() != null ? documentController.getGlobalId() : "NULL", outputControllerId, this.getId()});
                    this.getPepperJob().getPermissionForProcessDoument(documentController);
                }
                documentController.awake();
            }
            this.lock.unlock();
        }
        catch (InterruptedException e) {
            try {
                throw new PepperFWException("Something went wrong, when waiting for lock 'waitUntilAllDocumentsArePut'.", e);
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                if (logger.isTraceEnabled()) {
                    logger.trace("[Pepper] unlocked lock for remove document for controller {} in document bus '{}'and return document '{}'. ", new Object[]{outputControllerId, this.getId(), documentController != null ? documentController.getGlobalId() : "NULL"});
                }
                throw throwable;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[Pepper] unlocked lock for remove document for controller {} in document bus '{}'and return document '{}'. ", new Object[]{outputControllerId, this.getId(), documentController != null ? documentController.getGlobalId() : "NULL"});
        }
        return documentController;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("{");
        str.append(this.getId());
        str.append("}");
        return str.toString();
    }
}

