/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.util.SaltUtil;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SelfTestDesc {
    private static final Logger logger = LoggerFactory.getLogger((String)"Pepper");
    private final URI inputCorpusPath;
    private final URI expectedCorpusPath;
    protected final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();

    public SelfTestDesc(URI inputCorpusPath, URI expectedCorpusPath) {
        this.inputCorpusPath = inputCorpusPath;
        this.expectedCorpusPath = expectedCorpusPath;
    }

    public URI getInputCorpusPath() {
        return this.inputCorpusPath;
    }

    public URI getExpectedCorpusPath() {
        return this.expectedCorpusPath;
    }

    public boolean compare(SaltProject actualProject, SaltProject expectedProject) {
        return SaltUtil.compare((Object)actualProject).with((Object)expectedProject).andCheckIsomorphie();
    }

    public boolean compare(URI actualCorpusPath, URI expectedCorpusPath) {
        if (actualCorpusPath == null || expectedCorpusPath == null) {
            return false;
        }
        File actualDir = new File(actualCorpusPath.toFileString());
        File expectedDir = new File(expectedCorpusPath.toFileString());
        if (!actualDir.exists() || !expectedDir.exists()) {
            return false;
        }
        Collection actualFiles = FileUtils.listFiles((File)actualDir, null, (boolean)true);
        Collection expectedFiles = FileUtils.listFiles((File)expectedDir, null, (boolean)true);
        if (actualFiles == null || expectedFiles == null) {
            return false;
        }
        if (actualFiles.size() != expectedFiles.size()) {
            return false;
        }
        String expectedFilePrefix = this.getCannonicalPathWithoutException(expectedDir);
        String actualFilePrefix = this.getCannonicalPathWithoutException(actualDir);
        Hashtable<String, File> expectedFileMap = new Hashtable<String, File>();
        for (File expectedFile : expectedFiles) {
            expectedFileMap.put(this.getCannonicalPathWithoutException(expectedFile).replace(expectedFilePrefix, ""), expectedFile);
        }
        for (File actualFile : actualFiles) {
            File expectedFile;
            if (this.compare(actualFile, expectedFile = (File)expectedFileMap.get(this.getCannonicalPathWithoutException(actualFile).replace(actualFilePrefix, "")))) continue;
            return false;
        }
        return true;
    }

    private String getCannonicalPathWithoutException(File input) {
        try {
            return input.getCanonicalPath();
        }
        catch (IOException e) {
            logger.warn("Cannot create cannonical path for '" + input + "'.", (Throwable)e);
            return "";
        }
    }

    protected boolean compare(File actualFile, File expectedFile) {
        if (!this.filesDoExist(actualFile, expectedFile)) {
            return false;
        }
        if (this.isXmlFile(expectedFile)) {
            return this.compareXML(actualFile, expectedFile);
        }
        return this.filesAreEqual(actualFile, expectedFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isXmlFile(File pobablyXMlFile) {
        try (BufferedReader brTest = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pobablyXMlFile), StandardCharsets.UTF_8));){
            String firstLine = brTest.readLine();
            if (Strings.isNullOrEmpty((String)firstLine)) return false;
            if (!firstLine.contains("<?xml")) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e1) {
            return false;
        }
    }

    private boolean filesAreEqual(File actualFile, File expectedFile) {
        try {
            return FileUtils.contentEquals((File)actualFile, (File)expectedFile);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean filesDoExist(File actualFile, File expectedFile) {
        return actualFile != null && actualFile.exists() && expectedFile != null && expectedFile.exists();
    }

    protected boolean compareXML(File actualXmlFile, File expectedXmlFile) {
        Diff diff;
        if (!this.filesDoExist(actualXmlFile, expectedXmlFile)) {
            return false;
        }
        if (this.filesAreEqual(actualXmlFile, expectedXmlFile)) {
            return true;
        }
        try {
            DocumentBuilder docBuilder = this.docBuilderFactory.newDocumentBuilder();
            XMLUnit.setIgnoreWhitespace((boolean)true);
            XMLUnit.setIgnoreComments((boolean)true);
            XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)true);
            diff = XMLUnit.compareXML((Document)docBuilder.parse(expectedXmlFile), (Document)docBuilder.parse(actualXmlFile));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
        diff.overrideElementQualifier((ElementQualifier)new ElementNameQualifier());
        return diff.identical();
    }

    public boolean isValid(Collection<String> problems) {
        URI in = this.getInputCorpusPath();
        boolean retVal = true;
        if (in == null) {
            if (problems != null) {
                problems.add("The input corpus path was null. ");
            }
            retVal = false;
        } else {
            File inFile = new File(in.toFileString());
            if (!inFile.exists()) {
                if (problems != null) {
                    problems.add("The input corpus path '" + inFile.getAbsolutePath() + "' does not exist. ");
                }
                retVal = false;
            }
        }
        URI expected = this.getExpectedCorpusPath();
        if (expected == null) {
            if (problems != null) {
                problems.add("The expected corpus path was null. ");
            }
            retVal = false;
        } else {
            File expectedFile = new File(expected.toFileString());
            if (!expectedFile.exists()) {
                if (problems != null) {
                    problems.add("The expected corpus path '" + expectedFile.getAbsolutePath() + "' does not exist. ");
                }
                retVal = false;
            }
        }
        return retVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expectedCorpusPath == null ? 0 : this.expectedCorpusPath.hashCode());
        result = 31 * result + (this.inputCorpusPath == null ? 0 : this.inputCorpusPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelfTestDesc other = (SelfTestDesc)obj;
        if (this.expectedCorpusPath == null ? other.expectedCorpusPath != null : !this.expectedCorpusPath.equals(other.expectedCorpusPath)) {
            return false;
        }
        return !(this.inputCorpusPath == null ? other.inputCorpusPath != null : !this.inputCorpusPath.equals(other.inputCorpusPath));
    }

    public String toString() {
        return "SelfTestDesc [inputCorpusPath=" + this.inputCorpusPath + ", expectedCorpusPath=" + this.expectedCorpusPath + "]";
    }

    public static class Builder {
        private URI inputCorpusPath;
        private URI expectedCorpusPath;

        public Builder withInputCorpusPath(URI inputCorpusPath) {
            this.inputCorpusPath = inputCorpusPath;
            return this;
        }

        public Builder withExpectedCorpusPath(URI expectedCorpusPath) {
            this.expectedCorpusPath = expectedCorpusPath;
            return this;
        }

        public SelfTestDesc build() {
            SelfTestDesc selfTestDesc = new SelfTestDesc(this.inputCorpusPath, this.expectedCorpusPath);
            return selfTestDesc;
        }
    }
}

