/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.util.DIFF_TYPES;

public class Difference
implements Serializable {
    public Object templateObject;
    public Object otherObject;
    public Object container;
    public DIFF_TYPES diffType;
    public Set<Difference> subDiffs = null;

    public void addSubDiffs(Set<Difference> subDiffs) {
        this.subDiffs = subDiffs;
    }

    public Difference(Object templateObject, Object otherObject, Object container, DIFF_TYPES diffType) {
        this.templateObject = templateObject;
        this.otherObject = otherObject;
        this.container = container;
        this.diffType = diffType;
    }

    public String toString() {
        Label label;
        StringBuilder str = new StringBuilder();
        str.append(this.diffType.toString());
        str.append(" compared <");
        if (this.templateObject != null) {
            if (this.templateObject instanceof IdentifiableElement) {
                str.append(((IdentifiableElement)this.templateObject).getId());
            } else if (this.templateObject instanceof Label) {
                label = (Label)this.templateObject;
                str.append(label.toString());
            }
        }
        str.append("> with <");
        if (this.otherObject != null) {
            if (this.otherObject instanceof IdentifiableElement) {
                str.append(((IdentifiableElement)this.otherObject).getId());
            } else if (this.otherObject instanceof Label) {
                label = (Label)this.otherObject;
                str.append(label.toString());
            }
        }
        str.append(">");
        if (this.subDiffs != null) {
            str.append(" because of:");
            Iterator<Difference> iterator = this.subDiffs.iterator();
            while (iterator.hasNext()) {
                str.append("\n\t" + iterator.next().toString());
            }
        }
        return str.toString();
    }
}

