/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.util.DIFF_TYPES;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.Difference;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.AbstractDiff;

public class DocumentStructureDiff
extends AbstractDiff<SDocumentGraph> {
    public DocumentStructureDiff(SDocumentGraph template, SDocumentGraph other) {
        this(template, other, (DiffOptions)null);
    }

    public DocumentStructureDiff(SDocumentGraph template, SDocumentGraph other, DiffOptions optionMap) {
        super(template, other, optionMap);
    }

    @Override
    protected boolean findDiffs(boolean diffsRequested) {
        if (!this.compareSize((SDocumentGraph)this.templateObject, (SDocumentGraph)this.otherObject) && !diffsRequested) {
            return false;
        }
        if (!this.compareDataSources((SDocumentGraph)this.templateObject, (SDocumentGraph)this.otherObject, diffsRequested) && !diffsRequested) {
            return false;
        }
        if (!this.compareTokens((SDocumentGraph)this.templateObject, (SDocumentGraph)this.otherObject, diffsRequested) && !diffsRequested) {
            return false;
        }
        List<SNode> roots = ((SDocumentGraph)this.otherObject).getRootsByRelation(SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SDOMINANCE_RELATION);
        if (!SaltUtil.isNullOrEmpty(roots)) {
            ArrayList<SNode> remainingTemplateNodes = new ArrayList<SNode>(((SDocumentGraph)this.templateObject).getSpans().size() + ((SDocumentGraph)this.templateObject).getStructures().size());
            remainingTemplateNodes.addAll(((SDocumentGraph)this.templateObject).getSpans());
            remainingTemplateNodes.addAll(((SDocumentGraph)this.templateObject).getStructures());
            DifferenceHandler handler = new DifferenceHandler();
            handler.remainingTemplateNodes = remainingTemplateNodes;
            ((SDocumentGraph)this.otherObject).traverse(roots, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "diff_" + ((SDocumentGraph)this.templateObject).getId(), handler, false);
            if (this.getDifferences().size() > 0) {
                return false;
            }
            if (remainingTemplateNodes.size() > 0) {
                for (SNode remainingNode : remainingTemplateNodes) {
                    if (!diffsRequested) {
                        return false;
                    }
                    this.addDifference(remainingNode, null, null, DIFF_TYPES.NODE_MISSING, null);
                }
            }
        }
        if (!this.compareRelations((SDocumentGraph)this.templateObject, ((SDocumentGraph)this.templateObject).getPointingRelations(), (SDocumentGraph)this.otherObject, ((SDocumentGraph)this.otherObject).getPointingRelations(), diffsRequested) && !diffsRequested) {
            return false;
        }
        if (!this.compareRelations((SDocumentGraph)this.templateObject, ((SDocumentGraph)this.templateObject).getOrderRelations(), (SDocumentGraph)this.otherObject, ((SDocumentGraph)this.otherObject).getOrderRelations(), diffsRequested) && !diffsRequested) {
            return false;
        }
        return (Boolean)this.options.get("ignoreLayer") != false || this.compareLayers((SDocumentGraph)this.templateObject, (SDocumentGraph)this.otherObject, diffsRequested) || diffsRequested;
    }

    private boolean compareSize(SDocumentGraph template, SDocumentGraph other) {
        if (template.getNodes().size() != other.getNodes().size()) {
            return false;
        }
        if (template.getRelations().size() != other.getRelations().size()) {
            return false;
        }
        if (template.getTextualDSs().size() != other.getTextualDSs().size()) {
            return false;
        }
        if (template.getTextualRelations().size() != other.getTextualRelations().size()) {
            return false;
        }
        if (template.getTokens().size() != other.getTokens().size()) {
            return false;
        }
        if (template.getOrderRelations().size() != other.getOrderRelations().size()) {
            return false;
        }
        if (template.getPointingRelations().size() != other.getPointingRelations().size()) {
            return false;
        }
        if (template.getSpanningRelations().size() != other.getSpanningRelations().size()) {
            return false;
        }
        if (template.getSpans().size() != other.getSpans().size()) {
            return false;
        }
        if (template.getDominanceRelations().size() != other.getDominanceRelations().size()) {
            return false;
        }
        if (template.getStructures().size() != other.getStructures().size()) {
            return false;
        }
        if (template.getMedialDSs().size() != other.getMedialDSs().size()) {
            return false;
        }
        if (template.getMedialRelations().size() != other.getMedialRelations().size()) {
            return false;
        }
        if (template.getTimelineRelations().size() != other.getTimelineRelations().size()) {
            return false;
        }
        return (Boolean)this.options.get("ignoreLayer") != false || template.getLayers().size() == other.getLayers().size();
    }

    private boolean compareDataSources(SDocumentGraph template, SDocumentGraph other, boolean diff) {
        boolean retVal1 = this.compareDataSources(template.getTextualDSs(), other.getTextualDSs(), diff);
        if (!diff && !retVal1) {
            return retVal1;
        }
        boolean retVal2 = this.compareDataSources(template.getMedialDSs(), other.getMedialDSs(), diff);
        return retVal1 && retVal2;
    }

    private boolean compareDataSources(List<SSequentialDS> template, List<SSequentialDS> other, boolean diff) {
        boolean iso = true;
        Hashtable dataToDS = new Hashtable();
        HashSet<SSequentialDS> remainingTemplates = new HashSet<SSequentialDS>();
        for (SSequentialDS sSequentialDS : template) {
            dataToDS.put(sSequentialDS.getData(), sSequentialDS);
            remainingTemplates.add(sSequentialDS);
        }
        for (SSequentialDS sSequentialDS : other) {
            SSequentialDS templateDS = (SSequentialDS)dataToDS.get(sSequentialDS.getData());
            if (templateDS == null) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(null, sSequentialDS, null, DIFF_TYPES.NODE_MISSING, null);
                continue;
            }
            this.getIsoNodes().put((Object)templateDS, (Object)sSequentialDS);
            HashSet<Difference> subDiffs = new HashSet<Difference>();
            this.compareIdentifiableElements(templateDS, sSequentialDS, subDiffs);
            if (subDiffs.size() > 0) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(templateDS, sSequentialDS, null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
            }
            subDiffs = new HashSet();
            this.compareAnnotationContainers(templateDS, sSequentialDS, subDiffs);
            if (subDiffs.size() > 0) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(templateDS, sSequentialDS, null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
            }
            remainingTemplates.remove(templateDS);
        }
        if (remainingTemplates.size() > 0) {
            for (SSequentialDS sSequentialDS : remainingTemplates) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(sSequentialDS, null, null, DIFF_TYPES.NODE_MISSING, null);
            }
        }
        return iso;
    }

    private boolean compareTokens(SDocumentGraph template, SDocumentGraph other, boolean diff) {
        boolean iso = true;
        Hashtable textDSsToOffsetMap = new Hashtable();
        HashSet<STextualRelation> remainingTemplates = new HashSet<STextualRelation>();
        for (STextualRelation textRel : template.getTextualRelations()) {
            Hashtable<String, STextualRelation> offsetMap = (Hashtable<String, STextualRelation>)textDSsToOffsetMap.get(textRel.getTarget());
            if (offsetMap == null) {
                offsetMap = new Hashtable<String, STextualRelation>();
                textDSsToOffsetMap.put(textRel.getTarget(), offsetMap);
            }
            offsetMap.put(textRel.getStart() + "#" + textRel.getEnd(), textRel);
            remainingTemplates.add(textRel);
        }
        for (STextualRelation otherRel : other.getTextualRelations()) {
            STextualDS templateDS = (STextualDS)this.getIsoNodes().inverse().get(otherRel.getTarget());
            if (templateDS != null) {
                Map offsetMap = (Map)textDSsToOffsetMap.get(templateDS);
                STextualRelation templateRel = (STextualRelation)offsetMap.get(otherRel.getStart() + "#" + otherRel.getEnd());
                if (templateRel == null) {
                    if (!diff) {
                        return false;
                    }
                    iso = false;
                    this.addDifference(null, otherRel.getTarget(), null, DIFF_TYPES.NODE_MISSING, null);
                    continue;
                }
                this.getIsoNodes().put(templateRel.getSource(), otherRel.getSource());
                HashSet<Difference> subDiffs = new HashSet<Difference>();
                this.compareIdentifiableElements((IdentifiableElement)templateRel.getSource(), (IdentifiableElement)otherRel.getSource(), (Set<Difference>)subDiffs);
                if (subDiffs.size() > 0) {
                    if (!diff) {
                        return false;
                    }
                    iso = false;
                    this.addDifference(templateRel.getSource(), otherRel.getSource(), null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
                }
                subDiffs = new HashSet();
                this.compareAnnotationContainers((SAnnotationContainer)templateRel.getSource(), (SAnnotationContainer)otherRel.getSource(), subDiffs);
                if (subDiffs.size() > 0) {
                    if (!diff) {
                        return false;
                    }
                    iso = false;
                    this.addDifference(templateRel.getSource(), otherRel.getSource(), null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
                }
                remainingTemplates.remove(templateRel);
                continue;
            }
            if (!diff) {
                return false;
            }
            iso = false;
            this.addDifference(null, otherRel.getTarget(), null, DIFF_TYPES.NODE_MISSING, null);
        }
        if (remainingTemplates.size() > 0) {
            for (STextualRelation templateRel : remainingTemplates) {
                if (!diff) {
                    return false;
                }
                iso = false;
                this.addDifference(templateRel.getSource(), null, null, DIFF_TYPES.NODE_MISSING, null);
            }
        }
        return iso;
    }

    protected boolean compareRelations(SDocumentGraph template, List<? extends SRelation> templateRels, SDocumentGraph other, List<? extends SRelation> otherRels, Boolean diff) {
        boolean iso = true;
        HashSet<SRelation> otherRelSet = new HashSet<SRelation>();
        Iterator iterator = otherRels.iterator();
        while (iterator.hasNext()) {
            otherRelSet.add(iterator.next());
        }
        for (SRelation sRelation : templateRels) {
            SNode tempSource = (SNode)sRelation.getSource();
            SNode tempTarget = (SNode)sRelation.getTarget();
            SNode otherSource = (SNode)this.getIsoNodes().get((Object)tempSource);
            SNode otherTarget = (SNode)this.getIsoNodes().get((Object)tempTarget);
            if (otherSource == null || otherTarget == null) continue;
            Iterator inBetweenIterator = other.getInRelations(otherTarget.getId()).iterator();
            boolean isRelIso = true;
            while (inBetweenIterator.hasNext()) {
                isRelIso = true;
                SRelation otherRel = (SRelation)inBetweenIterator.next();
                if (((SNode)otherRel.getSource()).equals(otherSource) && sRelation.getClass().equals(otherRel.getClass())) {
                    HashSet<Difference> subDiffs = new HashSet<Difference>();
                    this.compareIdentifiableElements(sRelation, otherRel, subDiffs);
                    if (subDiffs.size() > 0) {
                        if (!diff.booleanValue()) {
                            return false;
                        }
                        isRelIso = false;
                        this.addDifference(sRelation, otherRel, null, DIFF_TYPES.RELATION_DIFFERING, subDiffs);
                    }
                    subDiffs = new HashSet();
                    this.compareAnnotationContainers(sRelation, otherRel, subDiffs);
                    if (subDiffs.size() > 0) {
                        if (!diff.booleanValue()) {
                            return false;
                        }
                        isRelIso = false;
                        this.addDifference(sRelation, otherRel, null, DIFF_TYPES.RELATION_DIFFERING, subDiffs);
                    }
                } else {
                    isRelIso = false;
                }
                if (!isRelIso) continue;
                otherRelSet.remove(otherRel);
                break;
            }
            if (isRelIso) continue;
            this.addDifference(sRelation, null, null, DIFF_TYPES.RELATION_MISSING, null);
            iso = false;
        }
        if (otherRelSet.size() > 0) {
            iterator = otherRelSet.iterator();
            while (iterator.hasNext()) {
                this.addDifference(null, iterator.next(), null, DIFF_TYPES.RELATION_MISSING, null);
            }
            iso = false;
        }
        return iso;
    }

    protected boolean compareLayers(SDocumentGraph template, SDocumentGraph other, Boolean diff) {
        HashSet<SLayer> remainingLayers = new HashSet<SLayer>();
        HashMultimap nameToLayer = HashMultimap.create();
        for (SLayer templateLayer : template.getLayers()) {
            nameToLayer.put((Object)templateLayer.getName(), (Object)templateLayer);
            remainingLayers.add(templateLayer);
        }
        block1: for (SLayer otherLayer : other.getLayers()) {
            Collection templateLayers = nameToLayer.get((Object)otherLayer.getName());
            if (templateLayers == null || templateLayers.size() == 0) {
                if (!diff.booleanValue()) {
                    return false;
                }
                this.addDifference(null, otherLayer, null, DIFF_TYPES.LAYER_MISSING, null);
                continue;
            }
            int i = 0;
            for (SLayer templateLayer : templateLayers) {
                boolean morePotentialPartners = ++i < templateLayers.size();
                boolean matches = true;
                if (templateLayer.getNodes().size() != otherLayer.getNodes().size()) {
                    matches = false;
                    if (!morePotentialPartners) {
                        this.addDifference(templateLayer, otherLayer, null, DIFF_TYPES.LAYER_DIFFERING, null);
                        if (!diff.booleanValue()) {
                            return false;
                        }
                    }
                }
                if (templateLayer.getRelations().size() != otherLayer.getRelations().size()) {
                    matches = false;
                    if (!morePotentialPartners) {
                        this.addDifference(templateLayer, otherLayer, null, DIFF_TYPES.LAYER_DIFFERING, null);
                        if (!diff.booleanValue()) {
                            return false;
                        }
                    }
                }
                HashSet<Difference> subDiffs = new HashSet<Difference>();
                this.compareIdentifiableElements(templateLayer, otherLayer, subDiffs);
                if (subDiffs.size() > 0) {
                    matches = false;
                    if (!morePotentialPartners) {
                        if (!diff.booleanValue()) {
                            return false;
                        }
                        this.addDifference(templateLayer, otherLayer, null, DIFF_TYPES.LAYER_DIFFERING, subDiffs);
                    }
                }
                subDiffs = new HashSet();
                this.compareAnnotationContainers(templateLayer, otherLayer, subDiffs);
                if (subDiffs.size() > 0) {
                    matches = false;
                    if (!morePotentialPartners) {
                        if (!diff.booleanValue()) {
                            return false;
                        }
                        this.addDifference(templateLayer, otherLayer, null, DIFF_TYPES.LAYER_DIFFERING, subDiffs);
                    }
                }
                if (!matches) continue;
                remainingLayers.remove(templateLayer);
                continue block1;
            }
        }
        if (remainingLayers.size() > 0) {
            for (SLayer layer : remainingLayers) {
                if (!diff.booleanValue()) {
                    return false;
                }
                this.addDifference(layer, null, null, DIFF_TYPES.LAYER_MISSING, null);
            }
        }
        return true;
    }

    private class DifferenceHandler
    implements GraphTraverseHandler {
        List<SNode> remainingTemplateNodes = null;
        private boolean abort = false;
        private Set<SRelation> visitedRelations = new HashSet<SRelation>();

        private DifferenceHandler() {
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation sRelation, SNode currNode, long order) {
            if (this.abort) {
                return false;
            }
            boolean retVal = true;
            if (sRelation != null) {
                if (sRelation instanceof SPointingRelation) {
                    retVal = false;
                } else if (currNode instanceof SToken) {
                    retVal = false;
                } else if (this.visitedRelations.contains(sRelation)) {
                    retVal = false;
                } else {
                    this.visitedRelations.add(sRelation);
                }
            }
            return retVal;
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode otherNode, long order) {
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode otherNode, long order) {
            if (currNode instanceof SSpan) {
                if (!this.findIsomorphicNode(currNode, SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SSPAN)) {
                    this.abort = true;
                }
            } else if (currNode instanceof SStructure) {
                if (!this.findIsomorphicNode(currNode, SALT_TYPE.SDOMINANCE_RELATION, SALT_TYPE.SSTRUCTURE)) {
                    this.abort = true;
                }
            } else if (!(currNode instanceof STextualDS)) {
                throw new SaltException("Computing of Differences is not implemented for this node type: " + currNode);
            }
        }

        private boolean findIsomorphicNode(SNode otherNode, SALT_TYPE sTypeRelations, SALT_TYPE nodeType) {
            SNode templateNode = null;
            List<SNode> children = ((SDocumentGraph)DocumentStructureDiff.this.otherObject).getChildren(otherNode, sTypeRelations);
            ArrayList<SNode> templateChildren = new ArrayList<SNode>();
            for (SNode child : children) {
                SNode templateChild = (SNode)DocumentStructureDiff.this.getIsoNodes().inverse().get((Object)child);
                if (templateChild == null) continue;
                templateChildren.add(templateChild);
            }
            List<Object> sharedParents = new ArrayList();
            if (templateChildren.size() > 0) {
                sharedParents = ((SDocumentGraph)DocumentStructureDiff.this.templateObject).getSharedParent(templateChildren, nodeType);
            }
            if (sharedParents.size() == 1) {
                templateNode = (SNode)sharedParents.get(0);
            } else if (sharedParents.size() > 1) {
                List<SRelation> otherOutRels = otherNode.getOutRelations();
                HashSet<SNode> trueCandidates = new HashSet<SNode>();
                for (SNode sNode : sharedParents) {
                    List<SRelation> templateOutRels = sNode.getOutRelations();
                    if (otherOutRels.size() != templateOutRels.size()) continue;
                    HashSet<SNode> otherChldren = new HashSet<SNode>();
                    Iterator<SRelation> it = otherOutRels.iterator();
                    while (it.hasNext()) {
                        otherChldren.add((SNode)it.next().getTarget());
                    }
                    boolean trueCandidate = true;
                    Iterator<SRelation> it_template = templateOutRels.iterator();
                    while (it_template.hasNext()) {
                        SNode templateChild = (SNode)it_template.next().getTarget();
                        if (otherChldren.contains(DocumentStructureDiff.this.getIsoNodes().get((Object)templateChild))) continue;
                        trueCandidate = false;
                        break;
                    }
                    if (!trueCandidate) continue;
                    trueCandidates.add(sNode);
                }
                if (trueCandidates.size() > 1) {
                    int minNumberOfDiffs = Integer.MAX_VALUE;
                    for (SNode trueCandidate : trueCandidates) {
                        HashSet<Difference> subDiff = new HashSet<Difference>();
                        DocumentStructureDiff.this.compareAnnotationContainers(trueCandidate, otherNode, subDiff);
                        if (subDiff.size() >= minNumberOfDiffs) continue;
                        minNumberOfDiffs = subDiff.size();
                        templateNode = trueCandidate;
                    }
                } else if (!trueCandidates.isEmpty()) {
                    templateNode = (SNode)trueCandidates.iterator().next();
                }
            }
            if (templateNode == null) {
                if (!DocumentStructureDiff.this.diffsRequested) {
                    return false;
                }
                DocumentStructureDiff.this.addDifference(null, otherNode, null, DIFF_TYPES.NODE_MISSING, null);
                return false;
            }
            boolean isIsomorph = true;
            DocumentStructureDiff.this.getIsoNodes().put((Object)templateNode, (Object)otherNode);
            this.remainingTemplateNodes.remove(templateNode);
            HashSet<Difference> subDiffs = new HashSet<Difference>();
            DocumentStructureDiff.this.compareIdentifiableElements(templateNode, otherNode, subDiffs);
            if (subDiffs.size() > 0) {
                if (!DocumentStructureDiff.this.diffsRequested) {
                    return false;
                }
                isIsomorph = false;
                DocumentStructureDiff.this.addDifference(templateNode, otherNode, null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
            }
            subDiffs = new HashSet();
            DocumentStructureDiff.this.compareAnnotationContainers(templateNode, otherNode, subDiffs);
            if (subDiffs.size() > 0) {
                if (!DocumentStructureDiff.this.diffsRequested) {
                    return false;
                }
                isIsomorph = false;
                DocumentStructureDiff.this.addDifference(templateNode, otherNode, null, DIFF_TYPES.NODE_DIFFERING, subDiffs);
            }
            return isIsomorph;
        }
    }
}

