/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.FloatingPointNumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Doubles;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractDoubleAssert<S extends AbstractDoubleAssert<S>>
extends AbstractComparableAssert<S, Double>
implements FloatingPointNumberAssert<S, Double> {
    @VisibleForTesting
    Doubles doubles = Doubles.instance();

    protected AbstractDoubleAssert(Double actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public S isNaN() {
        this.doubles.assertIsNaN(this.info, (Number)this.actual);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isNotNaN() {
        this.doubles.assertIsNotNaN(this.info, (Number)this.actual);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isZero() {
        this.doubles.assertIsZero(this.info, (Number)this.actual);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isNotZero() {
        this.doubles.assertIsNotZero(this.info, (Number)this.actual);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isPositive() {
        this.doubles.assertIsPositive(this.info, (Number)this.actual);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isNegative() {
        this.doubles.assertIsNegative(this.info, (Number)this.actual);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isNotNegative() {
        this.doubles.assertIsNotNegative(this.info, (Number)this.actual);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isNotPositive() {
        this.doubles.assertIsNotPositive(this.info, (Number)this.actual);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isCloseTo(double other, Offset<Double> offset) {
        this.doubles.assertIsCloseTo(this.info, (Number)this.actual, other, offset);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isCloseTo(Double other, Offset<Double> offset) {
        this.doubles.assertIsCloseTo(this.info, (Number)this.actual, other, offset);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isCloseTo(Double expected, Percentage percentage) {
        this.doubles.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isCloseTo(double expected, Percentage percentage) {
        this.doubles.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    public S isEqualTo(double expected) {
        this.doubles.assertEqual(this.info, this.actual, expected);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isEqualTo(Double expected, Offset<Double> offset) {
        this.doubles.assertEqual(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isEqualTo(double expected, Offset<Double> offset) {
        this.doubles.assertEqual(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    public S isNotEqualTo(double other) {
        this.doubles.assertNotEqual(this.info, this.actual, other);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isLessThan(double other) {
        this.doubles.assertLessThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isLessThanOrEqualTo(double other) {
        this.doubles.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isGreaterThan(double other) {
        this.doubles.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isGreaterThanOrEqualTo(double other) {
        this.doubles.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isBetween(Double start, Double end) {
        this.doubles.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S isStrictlyBetween(Double start, Double end) {
        this.doubles.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S usingComparator(Comparator<? super Double> customComparator) {
        super.usingComparator(customComparator);
        this.doubles = new Doubles(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.doubles = Doubles.instance();
        return (S)((AbstractDoubleAssert)this.myself);
    }
}

