/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IndexedObjectEnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.description.Description;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Lists;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractListAssert<S extends AbstractListAssert<S, A, T>, A extends List<? extends T>, T>
extends AbstractIterableAssert<S, A, T>
implements IndexedObjectEnumerableAssert<S, T> {
    @VisibleForTesting
    Lists lists = Lists.instance();

    protected AbstractListAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public S contains(T value, Index index) {
        this.lists.assertContains(this.info, (List)this.actual, value, index);
        return (S)((AbstractListAssert)this.myself);
    }

    @Override
    public S doesNotContain(T value, Index index) {
        this.lists.assertDoesNotContain(this.info, (List)this.actual, value, index);
        return (S)((AbstractListAssert)this.myself);
    }

    public S has(Condition<? super T> condition, Index index) {
        this.lists.assertHas(this.info, (List)this.actual, condition, index);
        return (S)((AbstractListAssert)this.myself);
    }

    public S is(Condition<? super T> condition, Index index) {
        this.lists.assertIs(this.info, (List)this.actual, condition, index);
        return (S)((AbstractListAssert)this.myself);
    }

    public S isSorted() {
        this.lists.assertIsSorted(this.info, (List)this.actual);
        return (S)((AbstractListAssert)this.myself);
    }

    public S isSortedAccordingTo(Comparator<? super T> comparator) {
        this.lists.assertIsSortedAccordingToComparator(this.info, (List)this.actual, comparator);
        return (S)((AbstractListAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super T> customComparator) {
        super.usingElementComparator((Comparator)customComparator);
        this.lists = new Lists(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractListAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        super.usingDefaultElementComparator();
        this.lists = Lists.instance();
        return (S)((AbstractListAssert)this.myself);
    }

    @Override
    protected S usingComparisonStrategy(ComparisonStrategy comparisonStrategy) {
        super.usingComparisonStrategy(comparisonStrategy);
        this.lists = new Lists(comparisonStrategy);
        return (S)((AbstractListAssert)this.myself);
    }

    @Override
    public S as(String description, Object ... args) {
        return (S)((AbstractListAssert)super.as(description, args));
    }

    @Override
    public S as(Description description) {
        return (S)((AbstractListAssert)super.as(description));
    }

    @Override
    public S describedAs(Description description) {
        return (S)((AbstractListAssert)super.describedAs(description));
    }

    @Override
    public S describedAs(String description, Object ... args) {
        return (S)((AbstractListAssert)super.describedAs(description, args));
    }

    @Override
    public S doesNotHave(Condition<? super A> condition) {
        return (S)((AbstractListAssert)super.doesNotHave((Condition)condition));
    }

    @Override
    public S doesNotHaveSameClassAs(Object other) {
        return (S)((AbstractListAssert)super.doesNotHaveSameClassAs(other));
    }

    @Override
    public S has(Condition<? super A> condition) {
        return (S)((AbstractListAssert)super.has((Condition)condition));
    }

    @Override
    public S hasSameClassAs(Object other) {
        return (S)((AbstractListAssert)super.hasSameClassAs(other));
    }

    @Override
    public S hasToString(String expectedToString) {
        return (S)((AbstractListAssert)super.hasToString(expectedToString));
    }

    @Override
    public S is(Condition<? super A> condition) {
        return (S)((AbstractListAssert)super.is((Condition)condition));
    }

    @Override
    public S isEqualTo(Object expected) {
        return (S)((AbstractListAssert)super.isEqualTo(expected));
    }

    @Override
    public S isExactlyInstanceOf(Class<?> type) {
        return (S)((AbstractListAssert)super.isExactlyInstanceOf((Class)type));
    }

    @Override
    public S isIn(Iterable<?> values) {
        return (S)((AbstractListAssert)super.isIn((Iterable)values));
    }

    @Override
    public S isIn(Object ... values) {
        return (S)((AbstractListAssert)super.isIn(values));
    }

    @Override
    public S isInstanceOf(Class<?> type) {
        return (S)((AbstractListAssert)super.isInstanceOf((Class)type));
    }

    @Override
    public S isInstanceOfAny(Class<?> ... types) {
        return (S)((AbstractListAssert)super.isInstanceOfAny((Class[])types));
    }

    @Override
    public S isNot(Condition<? super A> condition) {
        return (S)((AbstractListAssert)super.isNot((Condition)condition));
    }

    @Override
    public S isNotEqualTo(Object other) {
        return (S)((AbstractListAssert)super.isNotEqualTo(other));
    }

    @Override
    public S isNotExactlyInstanceOf(Class<?> type) {
        return (S)((AbstractListAssert)super.isNotExactlyInstanceOf((Class)type));
    }

    @Override
    public S isNotIn(Iterable<?> values) {
        return (S)((AbstractListAssert)super.isNotIn((Iterable)values));
    }

    @Override
    public S isNotIn(Object ... values) {
        return (S)((AbstractListAssert)super.isNotIn(values));
    }

    @Override
    public S isNotInstanceOf(Class<?> type) {
        return (S)((AbstractListAssert)super.isNotInstanceOf((Class)type));
    }

    @Override
    public S isNotInstanceOfAny(Class<?> ... types) {
        return (S)((AbstractListAssert)super.isNotInstanceOfAny((Class[])types));
    }

    @Override
    public S isNotOfAnyClassIn(Class<?> ... types) {
        return (S)((AbstractListAssert)super.isNotOfAnyClassIn((Class[])types));
    }

    @Override
    public S isNotNull() {
        return (S)((AbstractListAssert)super.isNotNull());
    }

    @Override
    public S isNotSameAs(Object other) {
        return (S)((AbstractListAssert)super.isNotSameAs(other));
    }

    @Override
    public S isOfAnyClassIn(Class<?> ... types) {
        return (S)((AbstractListAssert)super.isOfAnyClassIn((Class[])types));
    }

    @Override
    public S isSameAs(Object expected) {
        return (S)((AbstractListAssert)super.isSameAs(expected));
    }

    @Override
    public S overridingErrorMessage(String newErrorMessage, Object ... args) {
        return (S)((AbstractListAssert)super.overridingErrorMessage(newErrorMessage, args));
    }

    @Override
    public S usingDefaultComparator() {
        return (S)((AbstractListAssert)super.usingDefaultComparator());
    }

    @Override
    public S usingComparator(Comparator<? super A> customComparator) {
        return (S)((AbstractListAssert)super.usingComparator((Comparator)customComparator));
    }

    @Override
    public S withFailMessage(String newErrorMessage, Object ... args) {
        return (S)((AbstractListAssert)super.withFailMessage(newErrorMessage, args));
    }

    @Override
    public S withThreadDumpOnError() {
        return (S)((AbstractListAssert)super.withThreadDumpOnError());
    }
}

