/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Collections;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.Objects;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.IntrospectionError;

public class IgnoringFieldsComparator
extends FieldByFieldComparator {
    private String[] fields;
    private static final StandardRepresentation REPRESENTATION = new StandardRepresentation();

    public IgnoringFieldsComparator(String ... fields) {
        this.fields = fields;
    }

    @VisibleForTesting
    public String[] getFields() {
        return this.fields;
    }

    @Override
    protected boolean areEqual(Object actualElement, Object otherElement) {
        try {
            return Objects.instance().areEqualToIgnoringGivenFields(actualElement, otherElement, Collections.EMPTY_MAP, Collections.EMPTY_MAP, this.fields);
        }
        catch (IntrospectionError e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return "field by field comparator on all fields except " + REPRESENTATION.toStringOf(this.fields);
    }
}

