/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Collections;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.Objects;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.IntrospectionError;

public class OnFieldsComparator
extends FieldByFieldComparator {
    private static final StandardRepresentation REPRESENTATION = new StandardRepresentation();
    private String[] fields;

    public OnFieldsComparator(String ... fields) {
        if (Arrays.isNullOrEmpty(fields)) {
            throw new IllegalArgumentException("No fields specified");
        }
        for (String field : fields) {
            if (!Strings.isNullOrEmpty(field) && !Strings.isNullOrEmpty(field.trim())) continue;
            throw new IllegalArgumentException("Null/blank fields are invalid, fields were " + REPRESENTATION.toStringOf(fields));
        }
        this.fields = fields;
    }

    @VisibleForTesting
    public String[] getFields() {
        return this.fields;
    }

    @Override
    protected boolean areEqual(Object actualElement, Object otherElement) {
        try {
            return Objects.instance().areEqualToComparingOnlyGivenFields(actualElement, otherElement, Collections.EMPTY_MAP, Collections.EMPTY_MAP, this.fields);
        }
        catch (IntrospectionError e) {
            return false;
        }
    }

    @Override
    public String toString() {
        if (this.fields.length == 1) {
            return "single field comparator on field " + REPRESENTATION.toStringOf(this.fields[0]);
        }
        return "field by field comparator on fields " + REPRESENTATION.toStringOf(this.fields);
    }
}

