/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.pepper.cli.PepperStarter;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.common.Pepper;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.PepperModuleDesc;
import org.corpus_tools.pepper.common.PepperUtil;
import org.corpus_tools.pepper.common.StepDesc;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertWizardConsole {
    private static final Logger logger = LoggerFactory.getLogger(PepperStarter.class);
    private static final String PROMPT = "wizard";
    private static final String MSG_IM = "\tPlease enter the number or the name of the importer you want to use. ";
    private static final String MSG_IMPORT_CORPUS = "\tPlease enter a (further) path to a corpus you want to import or press enter to skip. When you use a relative path make it relative to:'" + new File("").getAbsolutePath() + "/'. ";
    private static final String MSG_PROP = "\tTo use a customization property, please enter it's number or name, the '=' and a value (e.g. 'name=value', or 'number=value'). To skip the customization, press enter. ";
    private static final String MSG_MAN = "\tIf you want to use a manipulator, please enter it's number or name, or press enter to skip. ";
    private static final String MSG_NO_PROPS = "\tNo customization properties available.";
    private static final String MSG_NO_VALID_MODULE = "\tSorry could not match the input, please enter the number or the name of the module again. ";
    private static final String MSG_NO_VALID_PROP = "\tSorry could not match the input, please enter the number or the name of the property followed by '=' and the value again. ";
    private static final String MSG_EX = "\tPlease enter the number or the name of the exporter you want to use. ";
    private static final String MSG_EX_CORPUS = "\tPlease enter a (further) path to which you want to export the corpus or press enter to skip. When you use a relative path make it relative to:'" + new File("").getAbsolutePath() + "/'. ";
    private static final String MSG_ABORTED = "Creating of Pepper workflow aborted by user's input. ";
    public Boolean isDebug = false;
    private String prompt = null;
    private Pepper pepper = null;
    private BufferedReader in = null;
    private PrintStream out = null;

    public ConvertWizardConsole(String prefixPrompt) {
        this.prompt = prefixPrompt + "/" + PROMPT;
    }

    public Pepper getPepper() {
        return this.pepper;
    }

    public void setPepper(Pepper pepper) {
        this.pepper = pepper;
    }

    public void start() {
        this.start(new BufferedReader(new InputStreamReader(System.in)), System.out);
    }

    public synchronized PepperJob start(BufferedReader in, PrintStream out) {
        this.in = in;
        this.out = out;
        String jobId = this.pepper.createJob();
        PepperJob pepperJob = this.pepper.getJob(jobId);
        try {
            String promptOld = this.prompt;
            this.prompt = this.prompt + "/importer";
            if (!this.importPhase(pepperJob)) {
                out.println(MSG_ABORTED);
                return null;
            }
            this.prompt = promptOld + "/manipulator";
            this.manipulationPhase(pepperJob);
            this.prompt = promptOld + "/exporter";
            if (!this.exportPhase(pepperJob)) {
                out.println(MSG_ABORTED);
                return null;
            }
            this.prompt = promptOld;
            out.println("Type 'convert' to start the conversion, 'save' to save the workflow description and 'exit' to exit. ");
            String input = null;
            while ((input = this.getUserInput(in, out)) != null) {
                String[] parts = input.split(" ");
                String command = parts[0];
                Vector<String> params = new Vector<String>();
                int i = 0;
                for (String part : parts) {
                    if (i > 0) {
                        params.add(part);
                    }
                    ++i;
                }
                if (COMMAND.SAVE.getName().equalsIgnoreCase(command) || COMMAND.SAVE.getAbbreviation().equalsIgnoreCase(command)) {
                    File outputFile = null;
                    if (parts.length == 1) {
                        out.println("Please enter the file location to store Pepper workflow description. ");
                        input = this.getUserInput(in, out);
                        if (input != null) {
                            outputFile = new File(input);
                        }
                    } else {
                        outputFile = new File((String)params.get(params.size() - 1));
                    }
                    if (outputFile != null) {
                        try {
                            ConvertWizardConsole.deresolveURIs(outputFile, pepperJob);
                            URI workflowURI = pepperJob.save(URI.createFileURI((String)outputFile.getAbsolutePath()));
                            out.println("Stored Pepper workflow description at '" + outputFile.getAbsolutePath() + "'. ");
                            pepperJob.load(workflowURI);
                        }
                        catch (Exception e) {
                            out.println("Could not store Pepper workflow to '" + outputFile.getAbsolutePath() + "', because of: " + e.getMessage());
                            if (this.isDebug.booleanValue()) {
                                e.printStackTrace(out);
                            }
                        }
                    }
                } else if (COMMAND.CONVERT.getName().equalsIgnoreCase(command) || COMMAND.CONVERT.getAbbreviation().equalsIgnoreCase(command)) {
                    return pepperJob;
                }
                out.println("Type 'convert' to start the conversion, 'save' to save the workflow description and enter to exit. ");
            }
        }
        catch (ExitWizardException e) {
            out.println(MSG_ABORTED);
            return null;
        }
        return null;
    }

    public static void deresolveURIs(File outputFile, PepperJob pepperJob) throws IOException {
        URI base = outputFile.isDirectory() ? URI.createFileURI((String)(outputFile.getCanonicalPath() + "/")) : URI.createFileURI((String)(outputFile.getCanonicalFile().getParentFile().getCanonicalPath() + "/"));
        for (StepDesc stepDesc : pepperJob.getStepDescs()) {
            if (stepDesc.getCorpusDesc() == null || stepDesc.getCorpusDesc().getCorpusPath() == null) continue;
            URI before = stepDesc.getCorpusDesc().getCorpusPath();
            stepDesc.getCorpusDesc().setCorpusPath(stepDesc.getCorpusDesc().getCorpusPath().deresolve(base, true, true, true));
            if (stepDesc.getCorpusDesc().getCorpusPath().equals(before)) continue;
            stepDesc.getCorpusDesc().setCorpusPath(URI.createFileURI((String)("./" + stepDesc.getCorpusDesc().getCorpusPath())));
        }
    }

    public boolean importPhase(PepperJob pepperJob) {
        int state = 0;
        String input = null;
        StepDesc stepDesc = null;
        this.out.println(MSG_IMPORT_CORPUS.replace("(further) ", ""));
        HashMap<Integer, PepperModuleDesc> number2Module = null;
        HashMap<String, PepperModuleDesc> name2Module = null;
        String legend = null;
        HashMap<Integer, String> number2PropName = null;
        String propLegend = null;
        PepperModuleDesc moduleDesc = null;
        String promptOld = this.prompt;
        while ((input = this.getUserInput(this.in, this.out)) != null || state == 2) {
            if (state == 0) {
                if (!input.isEmpty()) {
                    String path;
                    File corpusPath = new File(input);
                    if (!corpusPath.exists()) {
                        this.out.println("\tThe path to corpus does not exist '" + corpusPath.getAbsolutePath() + "' please type in another one. ");
                        continue;
                    }
                    stepDesc = pepperJob.createStepDesc();
                    stepDesc.setModuleType(MODULE_TYPE.IMPORTER);
                    try {
                        path = corpusPath.getCanonicalPath();
                    }
                    catch (IOException e) {
                        path = corpusPath.getAbsolutePath();
                    }
                    if (corpusPath.isDirectory() && !path.endsWith("/")) {
                        path = path + "/";
                    }
                    this.out.println("import corpus from: " + path);
                    stepDesc.getCorpusDesc().setCorpusPath(URI.createFileURI((String)path));
                    if (number2Module == null || name2Module == null) {
                        number2Module = new HashMap<Integer, PepperModuleDesc>();
                        name2Module = new HashMap<String, PepperModuleDesc>();
                        legend = this.createModuleLegend(stepDesc.getCorpusDesc().getCorpusPath(), number2Module, name2Module, MODULE_TYPE.IMPORTER);
                    }
                    this.out.println(legend);
                    this.out.println(MSG_IM);
                    ++state;
                    continue;
                }
                return stepDesc != null;
            }
            if (state == 1) {
                try {
                    Integer num = Integer.valueOf(input);
                    moduleDesc = (PepperModuleDesc)number2Module.get(num);
                }
                catch (NumberFormatException e) {
                    moduleDesc = (PepperModuleDesc)name2Module.get(input);
                }
                if (moduleDesc == null) {
                    this.out.println(legend);
                    this.out.println(MSG_NO_VALID_MODULE);
                    continue;
                }
                this.out.println("\tchosen importer: '" + moduleDesc + "'. \n");
                stepDesc.setName(moduleDesc.getName());
                if (moduleDesc.getProperties() != null) {
                    state = 2;
                    this.prompt = promptOld + "/prop";
                    number2PropName = new HashMap<Integer, String>();
                    propLegend = this.createPropertyLegend(moduleDesc.getProperties(), number2PropName);
                    this.out.println(propLegend);
                    this.out.println(MSG_PROP);
                    continue;
                }
                pepperJob.addStepDesc(stepDesc);
                this.out.println(MSG_NO_PROPS);
                this.out.println(MSG_IMPORT_CORPUS);
                propLegend = null;
                state = 0;
                continue;
            }
            if (state != 2 || this.readProp(number2PropName, input, stepDesc, pepperJob)) continue;
            pepperJob.addStepDesc(stepDesc);
            state = 0;
            this.prompt = promptOld;
            this.out.println(MSG_IMPORT_CORPUS);
        }
        return true;
    }

    public void manipulationPhase(PepperJob pepperJob) {
        int state = 1;
        String input = null;
        StepDesc stepDesc = null;
        String promptOld = this.prompt;
        HashMap<Integer, PepperModuleDesc> number2Module = new HashMap<Integer, PepperModuleDesc>();
        HashMap<String, PepperModuleDesc> name2Module = new HashMap<String, PepperModuleDesc>();
        String legend = this.createModuleLegend(null, number2Module, name2Module, MODULE_TYPE.MANIPULATOR);
        this.out.println(legend);
        this.out.println(MSG_MAN);
        HashMap<Integer, String> number2PropName = null;
        String propLegend = null;
        PepperModuleDesc moduleDesc = null;
        while ((input = this.getUserInput(this.in, this.out)) != null || state == 2) {
            if (state == 1) {
                if (input.isEmpty()) {
                    return;
                }
                stepDesc = pepperJob.createStepDesc();
                stepDesc.setModuleType(MODULE_TYPE.MANIPULATOR);
                try {
                    Integer num = Integer.valueOf(input);
                    moduleDesc = (PepperModuleDesc)number2Module.get(num);
                }
                catch (NumberFormatException e) {
                    moduleDesc = (PepperModuleDesc)name2Module.get(input);
                }
                if (moduleDesc == null) {
                    this.out.println(legend);
                    this.out.println(MSG_NO_VALID_MODULE);
                    continue;
                }
                this.out.println("\tchosen manipulator: '" + moduleDesc + "'. \n");
                stepDesc.setName(moduleDesc.getName());
                if (moduleDesc.getProperties() != null) {
                    state = 2;
                    this.prompt = promptOld + "/prop";
                    number2PropName = new HashMap<Integer, String>();
                    propLegend = this.createPropertyLegend(moduleDesc.getProperties(), number2PropName);
                    this.out.println(propLegend);
                    this.out.println(MSG_PROP);
                    continue;
                }
                pepperJob.addStepDesc(stepDesc);
                this.out.println(MSG_NO_PROPS);
                this.out.println(MSG_IMPORT_CORPUS);
                propLegend = null;
                state = 0;
                continue;
            }
            if (state != 2 || this.readProp(number2PropName, input, stepDesc, pepperJob)) continue;
            pepperJob.addStepDesc(stepDesc);
            state = 1;
            this.prompt = promptOld;
            this.out.println(legend);
            this.out.println(MSG_MAN);
        }
        this.prompt = promptOld;
    }

    public boolean exportPhase(PepperJob pepperJob) {
        int state = 0;
        String input = null;
        StepDesc stepDesc = null;
        this.out.println(MSG_EX_CORPUS.replace("(further) ", ""));
        HashMap<Integer, PepperModuleDesc> number2Module = null;
        HashMap<String, PepperModuleDesc> name2Module = null;
        String legend = null;
        HashMap<Integer, String> number2PropName = null;
        String propLegend = null;
        PepperModuleDesc moduleDesc = null;
        String promptOld = this.prompt;
        while ((input = this.getUserInput(this.in, this.out)) != null || state == 2) {
            if (state == 0) {
                if (!input.isEmpty()) {
                    String path;
                    File corpusPath = new File(input);
                    if (!corpusPath.exists() && !corpusPath.mkdirs()) {
                        logger.warn("Cannot create folder for corpus path '{}'. ", (Object)corpusPath.getAbsolutePath());
                    }
                    try {
                        path = corpusPath.getCanonicalPath();
                    }
                    catch (IOException e) {
                        path = corpusPath.getAbsolutePath();
                    }
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    this.out.println("export corpus to: " + path);
                    stepDesc = pepperJob.createStepDesc();
                    stepDesc.setModuleType(MODULE_TYPE.EXPORTER);
                    stepDesc.getCorpusDesc().setCorpusPath(URI.createFileURI((String)path));
                    if (number2Module == null || name2Module == null) {
                        number2Module = new HashMap<Integer, PepperModuleDesc>();
                        name2Module = new HashMap<String, PepperModuleDesc>();
                        legend = this.createModuleLegend(null, number2Module, name2Module, MODULE_TYPE.EXPORTER);
                    }
                    this.out.println(legend);
                    this.out.println(MSG_EX);
                    ++state;
                    continue;
                }
                return stepDesc != null;
            }
            if (state == 1) {
                try {
                    Integer num = Integer.valueOf(input);
                    moduleDesc = (PepperModuleDesc)number2Module.get(num);
                }
                catch (NumberFormatException e) {
                    moduleDesc = (PepperModuleDesc)name2Module.get(input);
                }
                if (moduleDesc == null) {
                    this.out.println(legend);
                    this.out.println(MSG_NO_VALID_MODULE);
                    continue;
                }
                this.out.println("\tchosen exporter: '" + moduleDesc + "'. \n");
                stepDesc.setName(moduleDesc.getName());
                if (moduleDesc.getProperties() != null) {
                    state = 2;
                    this.prompt = promptOld + "/prop";
                    number2PropName = new HashMap<Integer, String>();
                    propLegend = this.createPropertyLegend(moduleDesc.getProperties(), number2PropName);
                    this.out.println(propLegend);
                    this.out.println(MSG_PROP);
                    continue;
                }
                pepperJob.addStepDesc(stepDesc);
                this.out.println(MSG_NO_PROPS);
                this.out.println(MSG_EX_CORPUS);
                propLegend = null;
                state = 0;
                continue;
            }
            if (state != 2 || this.readProp(number2PropName, input, stepDesc, pepperJob)) continue;
            pepperJob.addStepDesc(stepDesc);
            state = 0;
            this.prompt = promptOld;
            this.out.println(MSG_IMPORT_CORPUS);
        }
        return true;
    }

    private Pair<List<PepperModuleDesc>, Integer> getModuleDescriptions(URI corpusPath, MODULE_TYPE moduleType) {
        ArrayList<PepperModuleDesc> modules = new ArrayList<PepperModuleDesc>();
        Integer numOfRecommended = 0;
        if (MODULE_TYPE.IMPORTER.equals((Object)moduleType)) {
            Set<String> possibleImporters = null;
            try {
                possibleImporters = this.getPepper().findAppropriateImporters(corpusPath);
            }
            catch (FileNotFoundException e) {
                this.out.println("Cannot read corpus path '" + corpusPath + "'. " + e.getMessage());
                return new ImmutablePair(modules, (Object)numOfRecommended);
            }
            for (PepperModuleDesc moduleDesc : this.getPepper().getRegisteredImporters()) {
                if (possibleImporters.contains(moduleDesc.getName())) {
                    Integer n = numOfRecommended;
                    Integer n2 = numOfRecommended = Integer.valueOf(numOfRecommended + 1);
                    modules.add(0, moduleDesc);
                    continue;
                }
                modules.add(moduleDesc);
            }
        } else {
            for (PepperModuleDesc moduleDesc : this.getPepper().getRegisteredModules()) {
                if (!moduleType.equals((Object)moduleDesc.getModuleType())) continue;
                modules.add(moduleDesc);
            }
        }
        return new ImmutablePair(modules, (Object)numOfRecommended);
    }

    private String createModuleLegend(URI corpusPath, Map<Integer, PepperModuleDesc> number2Module, Map<String, PepperModuleDesc> name2Module, MODULE_TYPE moduleType) {
        Pair<List<PepperModuleDesc>, Integer> moduleDescs = this.getModuleDescriptions(corpusPath, moduleType);
        List modules = (List)moduleDescs.getLeft();
        int numOfRecommended = (Integer)moduleDescs.getRight();
        String retStr = null;
        String[][] map = new String[modules.size() + 1][3];
        map[0][0] = "no";
        map[0][1] = "module name";
        map[0][2] = MODULE_TYPE.IMPORTER.equals((Object)moduleType) || MODULE_TYPE.EXPORTER.equals((Object)moduleType) ? "format" : "description";
        Integer[] length = new Integer[]{5, 30, 40};
        Integer num = 1;
        for (PepperModuleDesc moduleDesc : modules) {
            number2Module.put(num, moduleDesc);
            name2Module.put(moduleDesc.getName(), moduleDesc);
            String prefix = "";
            prefix = numOfRecommended >= num ? "* " : "  ";
            map[num.intValue()][0] = prefix + num;
            map[num.intValue()][1] = moduleDesc.getName();
            if (MODULE_TYPE.IMPORTER.equals((Object)moduleType) || MODULE_TYPE.EXPORTER.equals((Object)moduleType)) {
                if (moduleDesc.getSupportedFormats().size() > 0) {
                    int i = 0;
                    StringBuilder str = new StringBuilder();
                    str.append("(");
                    for (FormatDesc format : moduleDesc.getSupportedFormats()) {
                        if (i > 0) {
                            str.append("; ");
                        }
                        str.append(format.getFormatName());
                        str.append(", ");
                        str.append(format.getFormatVersion());
                        ++i;
                    }
                    str.append(")");
                    map[num.intValue()][2] = str.toString();
                }
            } else {
                map[num.intValue()][2] = moduleDesc.getDesc();
            }
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
        }
        retStr = PepperUtil.createTable(length, map, true, true, true);
        return retStr;
    }

    private String createPropertyLegend(PepperModuleProperties props, Map<Integer, String> number2propName) {
        String retStr = null;
        if (props != null) {
            String[][] map = new String[props.getPropertyDesctriptions().size() + 1][3];
            map[0][0] = "no";
            map[0][1] = "property name";
            map[0][2] = "description";
            Integer[] length = new Integer[]{3, 30, 40};
            int i = 1;
            for (PepperModuleProperty<?> prop : props.getPropertyDesctriptions()) {
                map[i][0] = String.valueOf(i);
                map[i][1] = prop.getName();
                map[i][2] = prop.getDescription();
                number2propName.put(i, prop.getName());
                ++i;
            }
            retStr = PepperUtil.createTable(length, map, true, true, true);
        }
        return retStr;
    }

    private String getUserInput(BufferedReader in, PrintStream out) {
        String userInput = "";
        try {
            out.println();
            out.print(this.prompt);
            out.print(">");
            userInput = in.readLine();
            if (userInput != null) {
                userInput = userInput.trim();
            }
        }
        catch (IOException ioe) {
            out.println("Cannot read command.");
        }
        if ("exit".equalsIgnoreCase(userInput)) {
            throw new ExitWizardException();
        }
        return userInput;
    }

    private boolean readProp(Map<Integer, String> number2propName, String input, StepDesc stepDesc, PepperJob pepperJob) {
        if (input != null && !input.isEmpty()) {
            int eqPosition = StringUtils.indexOf((CharSequence)input, (CharSequence)"=");
            if (eqPosition > 0) {
                String qualifier = input.substring(0, eqPosition);
                try {
                    Integer num = Integer.valueOf(qualifier);
                    qualifier = number2propName.get(num);
                }
                catch (NumberFormatException num) {
                    // empty catch block
                }
                String value = input.substring(eqPosition + 1, input.length());
                if (stepDesc.getProps() == null) {
                    stepDesc.setProps(new Properties());
                }
                stepDesc.getProps().put(qualifier, value);
                this.out.println("\tAdded property: " + qualifier + " = " + value);
            } else {
                this.out.println(MSG_NO_VALID_PROP);
            }
            return true;
        }
        return false;
    }

    public static class ExitWizardException
    extends RuntimeException {
    }

    public static enum COMMAND {
        SAVE("save", "s", "path to file", "Stores the Pepper workflow description to passed file location. "),
        CONVERT("convert", "c", null, "Starts the conversion process of the created Pepper workflow. ");

        private String name = null;
        private String abbreviation = null;
        private String parameters = null;
        private String description = null;

        private COMMAND(String name, String abbreviation, String parameters, String description) {
            this.name = name;
            this.abbreviation = abbreviation;
            this.parameters = parameters;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getParameters() {
            return this.parameters;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

