/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.corpus_tools.pepper.core.DocumentBus;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.modules.DocumentController;

public class InitialDocumentBus
extends DocumentBus {
    protected static final String ID_INTITIAL = "initial";

    public InitialDocumentBus(String outputModuleControllerId) {
        super(ID_INTITIAL, outputModuleControllerId);
    }

    public InitialDocumentBus(List<String> outputModuleControllerIds) {
        super(ID_INTITIAL, outputModuleControllerIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(DocumentController documentController) {
        if (documentController == null) {
            throw new PepperFWException("Cannot add a null value as DocumentController into documentBus.");
        }
        if (!documentController.isAsleep()) {
            documentController.sendToSleep();
        }
        this.lock.lock();
        try {
            Collection<ConcurrentLinkedQueue<DocumentController>> queues = this.getDocumentBus().values();
            for (ConcurrentLinkedQueue<DocumentController> queue : queues) {
                queue.add(documentController);
            }
            this.waitUntilAllDocumentsArePut.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

