/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.common.PepperConfiguration;
import org.corpus_tools.pepper.common.StepDesc;
import org.corpus_tools.pepper.core.ModuleResolver;
import org.corpus_tools.pepper.exceptions.PepperConvertException;
import org.corpus_tools.pepper.exceptions.PepperException;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperManipulator;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="ModuleResolverComponent", configurationPid="ModuleResolverComponent", immediate=true, enabled=true, servicefactory=false)
public class ModuleResolverImpl
implements ModuleResolver {
    private static final Logger logger = LoggerFactory.getLogger(ModuleResolverImpl.class);
    private ComponentContext componentContext = null;
    protected ComponentFactory pepperImporterComponentFactory = null;
    protected List<ComponentFactory> pepperImporterComponentFactories;
    protected ComponentFactory pepperManipulatorComponentFactory;
    protected List<ComponentFactory> pepperManipulatorComponentFactories;
    protected ComponentFactory pepperExporterComponentFactory;
    protected List<ComponentFactory> pepperExporterComponentFactories;
    public static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private volatile PepperConfiguration pepperConfiguration = null;
    private volatile Map<String, Integer> numberOfModuleInstances = null;

    public ModuleResolverImpl() {
        this.init();
    }

    private void init() {
        this.numberOfModuleInstances = new Hashtable<String, Integer>();
    }

    @Override
    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    @Override
    @Activate
    public void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    @Override
    public String getStatus() {
        StringBuilder infoString = new StringBuilder();
        List<PepperImporter> importers = this.getPepperImporters();
        Integer numOfFactories = 0;
        if (this.getPepperImporterComponentFactories() != null) {
            numOfFactories = this.getPepperImporterComponentFactories().size();
        }
        Integer numOfImporters = 0;
        if (importers != null) {
            numOfImporters = importers.size();
        }
        infoString.append("=========================================================== \n");
        infoString.append("registered importer-factories and importers (");
        infoString.append(numOfFactories);
        infoString.append("/ " + numOfImporters + "): \n");
        if (importers != null) {
            for (PepperImporter importer : importers) {
                infoString.append("\t");
                infoString.append(importer.getName());
                infoString.append("\n");
                if (importer.getSupportedFormats() == null) continue;
                for (FormatDesc formatDef : importer.getSupportedFormats()) {
                    infoString.append("\t\t");
                    infoString.append(formatDef.getFormatName());
                    infoString.append(", ");
                    infoString.append(formatDef.getFormatVersion());
                    infoString.append("\n");
                }
            }
        } else {
            infoString.append("\tno importers registered...\n");
        }
        List<PepperManipulator> manipulators = this.getPepperManipulators();
        numOfFactories = 0;
        if (this.getPepperManipulatorComponentFactories() != null) {
            numOfFactories = this.getPepperManipulatorComponentFactories().size();
        }
        Integer numOfManipulators = 0;
        if (manipulators != null) {
            numOfManipulators = manipulators.size();
        }
        infoString.append("=========================================================== \n");
        infoString.append("registered manipulator-factories and manipulators (");
        infoString.append(numOfFactories);
        infoString.append("/ ");
        infoString.append(numOfManipulators);
        infoString.append("): \n");
        if (manipulators != null) {
            for (PepperManipulator manipulator : manipulators) {
                infoString.append("\t");
                infoString.append(manipulator.getName());
                infoString.append("\n");
            }
        } else {
            infoString.append("\tno manipulators registered...\n");
        }
        List<PepperExporter> exporters = this.getPepperExporters();
        numOfFactories = 0;
        if (this.getPepperExporterComponentFactories() != null) {
            numOfFactories = this.getPepperExporterComponentFactories().size();
        }
        Integer numOfExporters = 0;
        if (exporters != null) {
            numOfExporters = exporters.size();
        }
        infoString.append("=========================================================== \n");
        infoString.append("registered exporter-factories and exporters (");
        infoString.append(numOfFactories);
        infoString.append("/ ");
        infoString.append(numOfExporters);
        infoString.append("): \n");
        if (exporters != null) {
            for (PepperExporter exporter : exporters) {
                infoString.append("\t");
                infoString.append(exporter.getName());
                infoString.append("\n");
                if (exporter.getSupportedFormats() == null) continue;
                for (FormatDesc formatDef : exporter.getSupportedFormats()) {
                    infoString.append("\t\t");
                    infoString.append(formatDef.getFormatName());
                    infoString.append(", ");
                    infoString.append(formatDef.getFormatVersion());
                    infoString.append("\n");
                }
            }
        } else {
            infoString.append("\tno exporters registered...\n");
        }
        infoString.append("=========================================================== \n");
        return infoString.toString();
    }

    @Override
    @Reference(unbind="removePepperImporterComponentFactory", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(component.factory=PepperImporterComponentFactory)")
    public void addPepperImporterComponentFactory(ComponentFactory pepperImporterComponentFactory) {
        if (pepperImporterComponentFactory == null) {
            throw new PepperException("Cannot add an empty pepperImporterComponentFactory.");
        }
        if (this.pepperImporterComponentFactories == null) {
            this.pepperImporterComponentFactories = new Vector<ComponentFactory>();
        }
        this.getPepperImporterComponentFactories().add(pepperImporterComponentFactory);
    }

    @Override
    public void removePepperImporterComponentFactory(ComponentFactory pepperImporterComponentFactory) {
        if (this.pepperImporterComponentFactories == null) {
            this.getPepperImporterComponentFactories().remove(pepperImporterComponentFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentFactory> getPepperImporterComponentFactories() {
        if (this.pepperImporterComponentFactories == null) {
            ModuleResolverImpl moduleResolverImpl = this;
            synchronized (moduleResolverImpl) {
                if (this.pepperImporterComponentFactories == null) {
                    this.pepperImporterComponentFactories = new Vector<ComponentFactory>();
                }
            }
        }
        return this.pepperImporterComponentFactories;
    }

    @Override
    @Reference(unbind="removePepperManipulatorComponentFactory", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(component.factory=PepperManipulatorComponentFactory)")
    public void addPepperManipulatorComponentFactory(ComponentFactory pepperManipulatorComponentFactory) {
        if (pepperManipulatorComponentFactory == null) {
            throw new PepperException("Cannot add an empty pepperManipulatorComponentFactory.");
        }
        if (this.pepperManipulatorComponentFactories == null) {
            this.pepperManipulatorComponentFactories = new Vector<ComponentFactory>();
        }
        this.getPepperManipulatorComponentFactories().add(pepperManipulatorComponentFactory);
    }

    @Override
    public void removePepperManipulatorComponentFactory(ComponentFactory pepperManipulatorComponentFactory) {
        if (this.pepperManipulatorComponentFactories == null) {
            this.getPepperManipulatorComponentFactories().remove(pepperManipulatorComponentFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentFactory> getPepperManipulatorComponentFactories() {
        if (this.pepperManipulatorComponentFactories == null) {
            ModuleResolverImpl moduleResolverImpl = this;
            synchronized (moduleResolverImpl) {
                if (this.pepperManipulatorComponentFactories == null) {
                    this.pepperManipulatorComponentFactories = new Vector<ComponentFactory>();
                }
            }
        }
        return this.pepperManipulatorComponentFactories;
    }

    @Override
    @Reference(unbind="removePepperExporterComponentFactory", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(component.factory=PepperExporterComponentFactory)")
    public void addPepperExporterComponentFactory(ComponentFactory pepperExporterComponentFactory) {
        if (pepperExporterComponentFactory == null) {
            throw new PepperException("Cannot add an empty pepperExporterComponentFactory.");
        }
        if (this.pepperExporterComponentFactories == null) {
            this.pepperExporterComponentFactories = new Vector<ComponentFactory>();
        }
        this.getPepperExporterComponentFactories().add(pepperExporterComponentFactory);
    }

    @Override
    public void removePepperExporterComponentFactory(ComponentFactory pepperExporterComponentFactory) {
        if (this.pepperExporterComponentFactories == null) {
            this.getPepperExporterComponentFactories().remove(pepperExporterComponentFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentFactory> getPepperExporterComponentFactories() {
        if (this.pepperExporterComponentFactories == null) {
            ModuleResolverImpl moduleResolverImpl = this;
            synchronized (moduleResolverImpl) {
                if (this.pepperExporterComponentFactories == null) {
                    this.pepperExporterComponentFactories = new Vector<ComponentFactory>();
                }
            }
        }
        return this.pepperExporterComponentFactories;
    }

    protected void setResources(PepperModule module) {
        String prop;
        String env;
        if (Strings.isNullOrEmpty((String)module.getSymbolicName())) {
            throw new PepperModuleException("Cannot set resources to module '" + module.getName() + "', because its symbolic name is empty.");
        }
        String propName = module.getSymbolicName() + ".resources";
        String resourcePathStr = null;
        resourcePathStr = System.getProperty(propName);
        if (Strings.isNullOrEmpty((String)resourcePathStr) && !Strings.isNullOrEmpty((String)(env = System.getenv("pepper.modules.resources")))) {
            resourcePathStr = env + "/" + module.getSymbolicName();
        }
        if (Strings.isNullOrEmpty((String)resourcePathStr) && !Strings.isNullOrEmpty((String)(prop = System.getProperty("pepper.modules.resources")))) {
            resourcePathStr = prop + "/" + module.getSymbolicName();
        }
        if (Strings.isNullOrEmpty((String)resourcePathStr)) {
            resourcePathStr = this.retrieveResourcePathFromBundle(module);
        }
        if (resourcePathStr == null) {
            logger.warn("Cannot set resource for Pepper module '" + module.getName() + "'.");
        } else {
            URI resourcePathURI = URI.createFileURI((String)resourcePathStr);
            File resourcePathFile = new File(resourcePathURI.toFileString());
            if (!resourcePathFile.exists()) {
                logger.warn("Resource folder '" + resourcePathFile.getAbsolutePath() + "' for pepper module '" + module.getSymbolicName() + "' does not exist and will be created. ");
                if (!resourcePathFile.mkdirs()) {
                    logger.warn("Cannot create folder {}. ", (Object)resourcePathFile);
                }
            }
            module.setResources(resourcePathURI);
        }
    }

    protected String retrieveResourcePathFromBundle(PepperModule module) {
        String resourcePathStr = null;
        if (module.getComponentContext() != null && module.getComponentContext().getBundleContext() != null && module.getComponentContext().getBundleContext().getBundle() != null && module.getComponentContext().getBundleContext().getBundle().getLocation() != null && module.getComponentContext() != null) {
            Vector<String> bundleLocations = new Vector<String>();
            String[] bundleNames = System.getProperty(PROP_OSGI_BUNDLES).split(",");
            if (bundleNames.length > 0) {
                for (String bundleName : bundleNames) {
                    if ((bundleName = bundleName.replace("reference:", "")).contains("@")) {
                        int pos = bundleName.indexOf("@");
                        bundleName = bundleName.substring(0, pos);
                    }
                    bundleLocations.add(bundleName);
                }
            }
            String currLocation = module.getComponentContext().getBundleContext().getBundle().getLocation();
            currLocation = currLocation.replace("initial@reference:file:", "");
            if ((currLocation = currLocation.replace("../", "")).endsWith("/")) {
                currLocation = currLocation.substring(0, currLocation.length() - 1);
            }
            String location = null;
            for (String bundleLocation : bundleLocations) {
                if (!bundleLocation.contains(currLocation)) continue;
                location = bundleLocation;
                break;
            }
            if (location == null) {
                logger.warn("Cannot find location of resource folder for Pepper module '" + module.getName() + "'. This could cause problems running the module. Tried to detect the location via system property '" + PROP_OSGI_BUNDLES + "' which was '" + System.getProperty(PROP_OSGI_BUNDLES) + "'. ");
            } else {
                if (location.endsWith(".jar")) {
                    location = location.replace(".jar", "/");
                } else {
                    if (!location.endsWith("/")) {
                        location = location + "/";
                    }
                    location = location + "src/main/resources/";
                }
                resourcePathStr = location;
                if (resourcePathStr.startsWith("file:")) {
                    resourcePathStr = resourcePathStr.replace("file:", "");
                }
            }
        }
        return resourcePathStr;
    }

    @Override
    public synchronized void setConfiguration(PepperConfiguration pepperConfiguration) {
        this.pepperConfiguration = pepperConfiguration;
    }

    @Override
    public PepperConfiguration getConfiguration() {
        return this.pepperConfiguration;
    }

    protected void setTemporaries(PepperModule module, int number) {
        if (Strings.isNullOrEmpty((String)module.getSymbolicName())) {
            throw new PepperModuleException("Cannot set temporaries to module '" + module.getName() + "', because its symbolic name is empty.");
        }
        File genTmpPath = this.getConfiguration().getTempPath();
        if (genTmpPath == null) {
            throw new PepperFWException("Cannot start converting, because the system property 'pepper.temporaries' isn't set. This might be an internal failure.");
        }
        File tmpPath = new File(genTmpPath.getAbsolutePath() + "/" + module.getSymbolicName() + "/" + number);
        try {
            tmpPath.mkdirs();
        }
        catch (Exception e) {
            throw new PepperException("Cannot create temporary folder for module: " + module.getName(), e);
        }
        module.setTemproraries(URI.createFileURI((String)tmpPath.getAbsolutePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer increaseNumberOfModules(PepperModule module) {
        Integer retVal = null;
        if (module == null) {
            throw new PepperFWException("Cannot increase number of modules, because module is empty. ");
        }
        String moduleSymbolicName = module.getSymbolicName();
        if (Strings.isNullOrEmpty((String)moduleSymbolicName)) {
            throw new PepperFWException("Cannot increase number of module '" + module.getName() + "', because the symbolic name of module is empty.");
        }
        ModuleResolverImpl moduleResolverImpl = this;
        synchronized (moduleResolverImpl) {
            if (this.numberOfModuleInstances.containsKey(moduleSymbolicName)) {
                Integer number;
                retVal = number = this.numberOfModuleInstances.get(moduleSymbolicName);
                Integer n = number;
                Integer n2 = number = Integer.valueOf(number + 1);
                this.numberOfModuleInstances.put(moduleSymbolicName, number);
            } else {
                this.numberOfModuleInstances.put(moduleSymbolicName, 1);
                retVal = 1;
            }
        }
        return retVal;
    }

    @Override
    public List<PepperImporter> getPepperImporters() {
        Vector<PepperImporter> pepperImporters = null;
        if (this.getPepperImporterComponentFactories() != null) {
            ArrayList<ComponentFactory> factories = new ArrayList<ComponentFactory>(this.getPepperImporterComponentFactories());
            for (ComponentFactory componentFactory : factories) {
                PepperImporter importer;
                Object instance = null;
                try {
                    instance = componentFactory.newInstance(null).getInstance();
                }
                catch (ComponentException componentException) {
                    // empty catch block
                }
                if (instance == null || !(instance instanceof PepperImporter)) continue;
                if (pepperImporters == null) {
                    pepperImporters = new Vector<PepperImporter>();
                }
                if (Strings.isNullOrEmpty((String)(importer = (PepperImporter)instance).getSymbolicName())) {
                    throw new PepperModuleException("Cannot register PepperModule, because the symbolic name of module '" + importer.getName() + "' is empty.");
                }
                this.setTemporaries(importer, this.increaseNumberOfModules(importer));
                this.setResources(importer);
                pepperImporters.add(importer);
            }
        }
        return pepperImporters;
    }

    @Override
    public List<PepperManipulator> getPepperManipulators() {
        Vector<PepperManipulator> pepperManipulators = null;
        if (this.getPepperManipulatorComponentFactories() != null) {
            try {
                ArrayList<ComponentFactory> factories = new ArrayList<ComponentFactory>(this.getPepperManipulatorComponentFactories());
                for (ComponentFactory componentFactory : factories) {
                    Object instance = null;
                    try {
                        instance = componentFactory.newInstance(null).getInstance();
                    }
                    catch (ComponentException componentException) {
                        // empty catch block
                    }
                    if (instance == null || !(instance instanceof PepperManipulator)) continue;
                    if (pepperManipulators == null) {
                        pepperManipulators = new Vector<PepperManipulator>();
                    }
                    PepperManipulator manipulator = (PepperManipulator)instance;
                    this.setTemporaries(manipulator, this.increaseNumberOfModules(manipulator));
                    this.setResources(manipulator);
                    pepperManipulators.add(manipulator);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        return pepperManipulators;
    }

    @Override
    public List<PepperExporter> getPepperExporters() {
        Vector<PepperExporter> pepperExporters = null;
        if (this.getPepperExporterComponentFactories() != null) {
            ArrayList<ComponentFactory> factories = new ArrayList<ComponentFactory>(this.getPepperExporterComponentFactories());
            for (ComponentFactory componentFactory : factories) {
                Object instance = null;
                try {
                    instance = componentFactory.newInstance(null).getInstance();
                }
                catch (ComponentException componentException) {
                    // empty catch block
                }
                if (instance == null || !(instance instanceof PepperExporter)) continue;
                if (pepperExporters == null) {
                    pepperExporters = new Vector<PepperExporter>();
                }
                PepperExporter exporter = (PepperExporter)instance;
                this.setTemporaries(exporter, this.increaseNumberOfModules(exporter));
                this.setResources(exporter);
                pepperExporters.add(exporter);
            }
        }
        return pepperExporters;
    }

    @Override
    public PepperModule getPepperModule(StepDesc stepDesc) {
        PepperModule pepperModule = null;
        if (this.pepperImporterComponentFactories != null) {
            if (this.getPepperImporters() == null || this.getPepperImporters().size() == 0) {
                throw new PepperConvertException("Cannot convert data, because no Pepper module is registered.");
            }
            List<PepperModule> modules = null;
            if (MODULE_TYPE.IMPORTER.equals((Object)stepDesc.getModuleType())) {
                modules = this.getPepperImporters();
            } else if (MODULE_TYPE.MANIPULATOR.equals((Object)stepDesc.getModuleType())) {
                modules = this.getPepperManipulators();
            } else if (MODULE_TYPE.EXPORTER.equals((Object)stepDesc.getModuleType())) {
                modules = this.getPepperExporters();
            }
            if (modules == null) {
                throw new PepperException("Cannot resolve a module for step description '" + stepDesc + "', since no Pepper modules are registered.");
            }
            for (PepperModule pepperModule2 : modules) {
                if (stepDesc.getName() != null) {
                    if (!stepDesc.getName().equalsIgnoreCase(pepperModule2.getName())) continue;
                    pepperModule = pepperModule2;
                    break;
                }
                if (stepDesc.getCorpusDesc() == null || stepDesc.getCorpusDesc().getFormatDesc() == null) continue;
                if (pepperModule2 instanceof PepperImporter) {
                    if (!((PepperImporter)pepperModule2).getSupportedFormats().contains(stepDesc.getCorpusDesc().getFormatDesc())) continue;
                    pepperModule = pepperModule2;
                    break;
                }
                if (!(pepperModule2 instanceof PepperExporter) || !((PepperExporter)pepperModule2).getSupportedFormats().contains(stepDesc.getCorpusDesc().getFormatDesc())) continue;
                pepperModule = pepperModule2;
                break;
            }
        }
        return pepperModule;
    }

    @Override
    public PepperImporter getPepperImporter(StepDesc stepDesc) {
        return (PepperImporter)this.getPepperModule(stepDesc);
    }

    @Override
    public PepperManipulator getPepperManipulator(StepDesc stepDesc) {
        return (PepperManipulator)this.getPepperModule(stepDesc);
    }

    @Override
    public PepperExporter getPepperExporter(StepDesc stepDesc) {
        return (PepperExporter)this.getPepperModule(stepDesc);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (pepperImporterComponentFactories: ");
        result.append(this.pepperImporterComponentFactories);
        result.append(", pepperManipulatorComponentFactories: ");
        result.append(this.pepperManipulatorComponentFactories);
        result.append(", pepperExporterComponentFactories: ");
        result.append(this.pepperExporterComponentFactories);
        result.append(')');
        return result.toString();
    }
}

