/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.corpus_tools.pepper.exceptions.PepperException;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.pepper.modules.exceptions.PepperModulePropertyException;
import org.eclipse.emf.common.util.URI;

public class PepperModuleProperties
implements Serializable {
    private static final long serialVersionUID = -7789891973429166813L;
    private static final String PREFIX_PEPPER = "pepper";
    private static final String PREFIX_PEPPER_BEFORE = "pepper.before.";
    private static final String PREFIX_PEPPER_AFTER = "pepper.after.";
    public static final String PROP_AFTER_ADD_SLAYER = "pepper.after.addSLayer";
    private static final String PROP_AFTER_ADD_SLAYER_DESC = "Consumes a semicolon separated list of names for {@link SLayer} objects. For each list element, one layer is created and added to all nodes and relations of a document-structure after the mapping was processed.";
    public static final String PROP_AFTER_COPY_RES = "pepper.after.copyRes";
    public static final String PROP_BEFORE_ADD_SLAYER = "pepper.before.addSLayer";
    private static final String PROP_BEFORE_ADD_SLAYER_DESC = "Consumes a semicolon separated list of names for {@link SLayer} objects. For each list element, one layer is created and added to all nodes and relations of a document-structure before the mapping was processed.";
    public static final String PROP_BEFORE_READ_META = "pepper.before.readMeta";
    private static final String PROP_BEFORE_READ_META_DESC = "Reads meta data for corpora and subcorpora in a very simple attribute-value format like: a=b. To enable the reading of meta data set this property to the file ending of the metadata file.  For instance in case of the file is named data.meta: pepper.before.readMeta=meta. The file is expected to be UTF-8 encoded.";
    public static final String PROP_AFTER_REPORT_CORPUSGRAPH = "pepper.after.reportCorpusGraph";
    private static final String PROP_AFTER_REPORT_CORPUSGRAPH_DESC = "When set to true, prints the corpus graph to standard out after a module has processed it. This property is mainly used for importers, to visualize the created corpus structure. The default value is 'false'.";
    private static final String PROP_AFTER_COPY_RES_DESC = "Copies one or more source files to one or more target files after processing. This is very helpful, in case of customizations should be done in target format. If you use relative paths, the are anchored to either the location of the workflow description file or where Pepper was started. The syntax is as follows: SOURCE_FILE -> TARGET_FILE (; SOURCE_FILE -> TARGET_FILE)*.";
    public static final String PROP_AFTER_RENAME_ANNOTATIONS = "pepper.after.renameAnnos";
    private static final String PROP_AFTER_RENAME_ANNOTATIONS_DESC = "Renames all annotations matching the search template to the new namespace, name or value. To rename an annotation, use the following syntax: 'old_namespace::old_name=old_value := new_namespace::new_name=new_value', determining the name is mandatory whereas the namespace and value are optional. For instance a pos annotation can be renamed as follows: 'salt::pos:=part-of-speech'. A list of renamings must be separated with ';'.";
    public static final String PROP_AFTER_REMOVE_ANNOTATIONS = "pepper.after.removeAnnos";
    private static final String PROP_AFTER_REMOVE_ANNOTATIONS_DESC = "Removes all annotations matching the search template. Several templates are separated by a semicolon. To remove annoattions use the following syntax: 'namespace::name=value (;namespace::name=value) := new_namespace::new_name=new_value'. ";
    public static final String PROP_AFTER_TOKENIZE = "pepper.after.tokenize";
    private static final String PROP_AFTER_TOKENIZE_DESC = "Tokenizes all primary data in the document structrue.";
    protected Map<String, PepperModuleProperty<?>> pepperModuleProperties = null;

    public PepperModuleProperties() {
        this.addProperty(PepperModuleProperty.create().withName(PROP_BEFORE_ADD_SLAYER).withType(String.class).withDescription(PROP_BEFORE_ADD_SLAYER_DESC).build());
        this.addProperty(PepperModuleProperty.create().withName(PROP_BEFORE_READ_META).withType(String.class).withDescription(PROP_BEFORE_READ_META_DESC).build());
        this.addProperty(PepperModuleProperty.create().withName(PROP_AFTER_ADD_SLAYER).withType(String.class).withDescription(PROP_AFTER_ADD_SLAYER_DESC).build());
        this.addProperty(PepperModuleProperty.create().withName(PROP_AFTER_COPY_RES).withType(String.class).withDescription(PROP_AFTER_COPY_RES_DESC).build());
        this.addProperty(PepperModuleProperty.create().withName(PROP_AFTER_REPORT_CORPUSGRAPH).withType(Boolean.class).withDescription(PROP_AFTER_REPORT_CORPUSGRAPH_DESC).withDefaultValue(false).build());
        this.addProperty(PepperModuleProperty.create().withName(PROP_AFTER_RENAME_ANNOTATIONS).withType(String.class).withDescription(PROP_AFTER_RENAME_ANNOTATIONS_DESC).build());
        this.addProperty(PepperModuleProperty.create().withName(PROP_AFTER_REMOVE_ANNOTATIONS).withType(String.class).withDescription(PROP_AFTER_REMOVE_ANNOTATIONS_DESC).build());
        this.addProperty(PepperModuleProperty.create().withName(PROP_AFTER_TOKENIZE).withType(Boolean.class).withDescription(PROP_AFTER_TOKENIZE_DESC).withDefaultValue(false).build());
    }

    public void addProperties(URI propURI) {
        if (propURI != null) {
            this.setPropertyValues(new File(propURI.toFileString()));
        }
    }

    public Properties getProperties() {
        Properties retVal = new Properties();
        Collection<String> names = this.getPropertyNames();
        if (names != null) {
            for (String name : names) {
                PepperModuleProperty<?> prop;
                if (name == null || (prop = this.getProperty(name)).getValue() == null) continue;
                retVal.put(name, prop.getValue());
            }
        }
        return retVal;
    }

    public void setPropertyValues(File propFile) {
        if (propFile != null && propFile.exists()) {
            Properties props = new Properties();
            try (FileInputStream f = new FileInputStream(propFile);){
                props.load(f);
            }
            catch (FileNotFoundException e) {
                throw new PepperModulePropertyException("Cannot load property file.", e);
            }
            catch (IOException e) {
                throw new PepperModulePropertyException("Cannot load property file.", e);
            }
            this.setPropertyValues(props);
        }
    }

    public void setPropertyValues(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.setPropertyValue(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public <T> void setPropertyValue(String propName, T propValue) {
        PepperModuleProperty<Object> prop = this.getProperty(propName);
        if (prop != null) {
            prop.setValueString(propValue.toString());
        } else {
            prop = PepperModuleProperty.create().withName(propName).withType(String.class).withDescription("this entry is automatically created by pepper and no description exists.").build();
            prop.setValueString(propValue.toString());
            this.addProperty(prop);
        }
        this.checkProperty(prop);
    }

    public boolean checkProperties() {
        Collection<PepperModuleProperty<?>> properties = this.getPropertyDesctriptions();
        for (PepperModuleProperty<?> prop : properties) {
            this.checkProperty(prop);
        }
        return true;
    }

    public boolean checkProperty(PepperModuleProperty<?> prop) {
        if (prop.isRequired() && prop.getValue() == null) {
            throw new PepperModulePropertyException("The following property is required, but its value was not set: " + prop);
        }
        return true;
    }

    public void addProperty(PepperModuleProperty<?> property) {
        if (property.getName() == null || property.getName().isEmpty()) {
            throw new PepperException("Cannot add a property description without a name.");
        }
        if (this.pepperModuleProperties == null) {
            this.pepperModuleProperties = new HashMap();
        }
        this.pepperModuleProperties.put(property.getName(), property);
    }

    public PepperModuleProperty<?> getProperty(String propName) {
        PepperModuleProperty<?> retVal = null;
        if (this.pepperModuleProperties != null) {
            retVal = this.pepperModuleProperties.get(propName);
        }
        return retVal;
    }

    public Collection<String> getPropertyNames() {
        Vector<String> names = new Vector<String>();
        if (this.pepperModuleProperties != null) {
            Set<String> keys = this.pepperModuleProperties.keySet();
            for (String key : keys) {
                names.add(key);
            }
        }
        return names;
    }

    public Collection<PepperModuleProperty<?>> getPropertyDesctriptions() {
        ArrayList retVal = new ArrayList(this.pepperModuleProperties.values());
        Collections.sort(retVal);
        return retVal;
    }

    public void removePropertyValue(String propName) {
        PepperModuleProperty<?> prop = this.pepperModuleProperties.get(propName);
        prop.setValue(null);
    }

    public List<Character> stringToCharList(String input) {
        ArrayList<Character> simpleTokSeparators = new ArrayList<Character>();
        boolean isOpen = false;
        boolean isEscaped = false;
        for (char chr : input.toCharArray()) {
            if (chr == '\\' && !isEscaped) {
                isEscaped = true;
            } else if (chr == '\'' && !isEscaped) {
                isOpen = !isOpen;
            } else if (isOpen) {
                simpleTokSeparators.add(Character.valueOf(chr));
                if (chr == '\\') {
                    isEscaped = false;
                }
            }
            if (chr == '\\') continue;
            isEscaped = false;
        }
        return simpleTokSeparators;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (String name : this.getPropertyNames()) {
            PepperModuleProperty<?> prop = this.getProperty(name);
            buf.append(prop + ", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

