/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.IntrospectionError;

public final class Introspection {
    public static PropertyDescriptor getProperty(String propertyName, Object target) {
        Preconditions.checkNotNullOrEmpty(propertyName);
        Preconditions.checkNotNull(target);
        BeanInfo beanInfo = null;
        Class<?> type = target.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(type);
        }
        catch (Exception t) {
            throw new IntrospectionError(String.format("Unable to get BeanInfo for type %s", type.getName()), t);
        }
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            if (!propertyName.equals(descriptor.getName())) continue;
            return descriptor;
        }
        throw new IntrospectionError(Introspection.propertyNotFoundErrorMessage(propertyName, target));
    }

    private static String propertyNotFoundErrorMessage(String propertyName, Object target) {
        String targetTypeName = target.getClass().getName();
        String property = Strings.quote(propertyName);
        Method getter = Introspection.findGetter(propertyName, target);
        if (getter == null) {
            return String.format("No getter for property %s in %s", property, targetTypeName);
        }
        if (!Modifier.isPublic(getter.getModifiers())) {
            return String.format("No public getter for property %s in %s", property, targetTypeName);
        }
        return String.format("Unable to find property %s in %s", property, targetTypeName);
    }

    private static Method findGetter(String propertyName, Object target) {
        String capitalized = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method getter = Introspection.findMethod("get" + capitalized, target);
        if (getter != null) {
            return getter;
        }
        return Introspection.findMethod("is" + capitalized, target);
    }

    private static Method findMethod(String name, Object target) {
        for (Class<?> clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                continue;
            }
        }
        return null;
    }

    private Introspection() {
    }
}

