/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.internal.Invalidity;
import org.corpus_tools.salt.util.internal.ValidationResult;

public class Validator {
    private boolean withRepairing = false;
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    private Validator(boolean withRepairing) {
        this.withRepairing = withRepairing;
    }

    private void validate(SCorpusGraph corpusGraph) {
        if (corpusGraph == null) {
            return;
        }
        for (SCorpus corpus : corpusGraph.getCorpora()) {
            this.validate(corpus);
        }
        for (SDocument document : corpusGraph.getDocuments()) {
            this.validate(document);
        }
    }

    private void validate(SCorpus corpus) {
        if (corpus == null) {
            return;
        }
        boolean containsDocuments = false;
        boolean containsCorpora = false;
        for (SRelation relation : corpus.getGraph().getOutRelations(corpus.getId())) {
            if (relation.getTarget() instanceof SDocument) {
                if (containsCorpora) {
                    this.result.add(new Invalidity(relation, "Salt model not valid, the corpus '" + ((SNode)relation.getSource()).getId() + "' contains corpora and documents as well."));
                    break;
                }
                containsDocuments = true;
                continue;
            }
            if (!(relation.getTarget() instanceof SCorpus)) continue;
            if (containsDocuments) {
                this.result.add(new Invalidity(relation, "Salt model not valid, the corpus '" + ((SNode)relation.getSource()).getId() + "' contains corpora and documents as well."));
                break;
            }
            containsCorpora = true;
        }
    }

    private boolean validate(SRelation<? extends SNode, ? extends SNode> relation) {
        boolean toRemove = false;
        if (relation.getSource() == null) {
            this.result.add(new Invalidity(relation, "The relation '" + relation.getId() + "' has no source node. "));
            toRemove = true;
        }
        if (relation.getTarget() == null) {
            this.result.add(new Invalidity(relation, "The relation '" + relation.getId() + "' has no target node. "));
            toRemove = true;
        }
        if (relation.getSource() != null && relation.getTarget() != null && ((SNode)relation.getSource()).equals(relation.getTarget())) {
            this.result.add(new Invalidity(relation, "The source and target of relation '" + relation.getId() + "' points to the same node '" + ((SNode)relation.getSource()).getId() + "'. "));
            toRemove = true;
        }
        return toRemove;
    }

    private boolean validate(STextualRelation relation) {
        boolean toRemove = this.validate((SRelation<? extends SNode, ? extends SNode>)relation);
        if (relation.getStart() == null) {
            this.result.add(new Invalidity(relation, "The " + STextualRelation.class.getSimpleName() + " '" + relation.getId() + "' has no start value."));
            toRemove = true;
        }
        if (relation.getEnd() == null) {
            this.result.add(new Invalidity(relation, "The " + STextualRelation.class.getSimpleName() + " '" + relation.getId() + "' has no end value."));
            toRemove = true;
        }
        if (relation.getStart() != null && relation.getEnd() != null && (Integer)relation.getEnd() < (Integer)relation.getStart()) {
            this.result.add(new Invalidity(relation, "The start value '" + relation.getStart() + "' of " + STextualRelation.class.getSimpleName() + " '" + relation.getId() + "' is bigger than its end value '" + relation.getEnd() + "'. "));
        }
        if (relation.getStart() != null) {
            if (relation.getTarget() != null && ((STextualDS)relation.getTarget()).getText() != null && (Integer)relation.getStart() > ((STextualDS)relation.getTarget()).getText().length()) {
                this.result.add(new Invalidity(relation, "The start value '" + relation.getStart() + "' of " + STextualRelation.class.getSimpleName() + " '" + relation.getId() + "' is than the target text' size. It's length is '" + ((STextualDS)relation.getTarget()).getText().length() + "'."));
                if (this.withRepairing) {
                    relation.setStart(((STextualDS)relation.getTarget()).getText().length());
                }
            }
            if ((Integer)relation.getStart() < 0) {
                this.result.add(new Invalidity(relation, "The start value '" + relation.getStart() + "' of " + STextualRelation.class.getSimpleName() + " '" + relation.getId() + "' is samller then 0. "));
                if (this.withRepairing) {
                    relation.setStart(0);
                }
            }
        }
        if (relation.getEnd() != null) {
            if (relation.getTarget() != null && ((STextualDS)relation.getTarget()).getText() != null && (Integer)relation.getEnd() > ((STextualDS)relation.getTarget()).getText().length()) {
                this.result.add(new Invalidity(relation, "The end value '" + relation.getEnd() + "' of " + STextualRelation.class.getSimpleName() + " '" + relation.getId() + "' is not higher than the target text' size. It's length is '" + ((STextualDS)relation.getTarget()).getText().length() + "'."));
                if (this.withRepairing) {
                    relation.setEnd(((STextualDS)relation.getTarget()).getText().length());
                }
            }
            if ((Integer)relation.getEnd() < 0) {
                this.result.add(new Invalidity(relation, "The end value '" + relation.getStart() + "' of " + STextualRelation.class.getSimpleName() + " '" + relation.getId() + "' is samller then 0. "));
                if (this.withRepairing) {
                    relation.setEnd(0);
                }
            }
        }
        return toRemove;
    }

    private void validate(STextualDS text) {
        if (text != null && text.getText() == null) {
            this.result.add(new Invalidity(text, "The primary text node '" + text.getId() + "' does not contain a text. "));
            if (this.withRepairing) {
                text.setText("");
            }
        }
    }

    private boolean validate(SDocument document) {
        if (document == null) {
            return false;
        }
        boolean isValid = true;
        if (document.getDocumentGraph() != null) {
            this.validate(document.getDocumentGraph());
        }
        return isValid;
    }

    private void validate(SDocumentGraph documentGraph) {
        if (documentGraph == null) {
            return;
        }
        for (STextualDS texts : documentGraph.getTextualDSs()) {
            this.validate(texts);
        }
        for (SRelation rel : documentGraph.getRelations()) {
            boolean toRemove = false;
            toRemove = this.validate(rel);
            if (rel instanceof STextualRelation) {
                this.validate((STextualRelation)rel);
            }
            if (!this.withRepairing || !toRemove) continue;
            documentGraph.removeRelation(rel);
        }
    }

    public static class Builder<T> {
        private final T saltObject;

        public Builder(T saltObject) {
            this.saltObject = saltObject;
        }

        public ValidationResult andFindInvalidities() {
            Validator validator = new Validator(false);
            this.validate(validator);
            return validator.getResult();
        }

        public ValidationResult andRepairInvalidities() {
            Validator validator = new Validator(true);
            this.validate(validator);
            return validator.getResult();
        }

        private void validate(Validator validator) {
            if (this.saltObject == null) {
                return;
            }
            if (this.saltObject instanceof SCorpusGraph) {
                validator.validate((SCorpusGraph)this.saltObject);
            } else if (this.saltObject instanceof SCorpus) {
                validator.validate((SCorpus)this.saltObject);
            } else if (this.saltObject instanceof SDocument) {
                validator.validate((SDocument)this.saltObject);
            } else if (this.saltObject instanceof SDocumentGraph) {
                validator.validate((SDocumentGraph)this.saltObject);
            }
        }
    }
}

