/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.pepper.common.CorpusDesc;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.common.JOB_STATUS;
import org.corpus_tools.pepper.common.MEMORY_POLICY;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.common.PepperConfiguration;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.PepperUtil;
import org.corpus_tools.pepper.common.StepDesc;
import org.corpus_tools.pepper.core.DocumentBus;
import org.corpus_tools.pepper.core.DocumentControllerImpl;
import org.corpus_tools.pepper.core.InitialDocumentBus;
import org.corpus_tools.pepper.core.ModuleResolver;
import org.corpus_tools.pepper.core.Step;
import org.corpus_tools.pepper.core.TerminalDocumentBus;
import org.corpus_tools.pepper.core.WorkflowDescriptionReader;
import org.corpus_tools.pepper.exceptions.NotInitializedException;
import org.corpus_tools.pepper.exceptions.PepperException;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.exceptions.PepperInActionException;
import org.corpus_tools.pepper.exceptions.WorkflowException;
import org.corpus_tools.pepper.modules.DocumentController;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleXMLResourceException;
import org.corpus_tools.pepper.util.XMLStreamWriter;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PepperJobImpl
extends PepperJob {
    private static final Logger logger = LoggerFactory.getLogger(PepperJobImpl.class);
    protected SaltProject saltProject = null;
    private PepperConfiguration props = null;
    protected ModuleResolver moduleResolver = null;
    private List<Step> manipulationSteps = null;
    private List<Step> importSteps = null;
    private List<Step> exportSteps = null;
    protected List<DocumentBus> documentBuses = null;
    protected List<DocumentBus> initialDocumentBuses = null;
    protected boolean isWired = false;
    protected volatile boolean isImportedCorpusStructure = false;
    protected List<DocumentController> documentControllers = null;
    protected boolean isReadyToStart = false;
    private Long startTime = 0L;
    protected volatile ReentrantLock inProgress = new ReentrantLock();
    private final AtomicBoolean cancellationRequested = new AtomicBoolean(false);
    protected volatile MEMORY_POLICY memPolicy = MEMORY_POLICY.MODERATE;
    private volatile int maxNumOfDocuments = 10;
    private volatile Lock numOfDocsLock = new ReentrantLock();
    private volatile Condition numOfDocsCondition = this.numOfDocsLock.newCondition();
    private Set<DocumentController> activeDocuments = null;

    public PepperJobImpl(String jobId) {
        if (jobId == null || jobId.isEmpty()) {
            throw new PepperFWException("Cannot initialize a PepperJob with an empty id.");
        }
        this.id = jobId;
        this.setSaltProject(SaltFactory.createSaltProject());
    }

    @Override
    public SaltProject getSaltProject() {
        return this.saltProject;
    }

    public void setSaltProject(SaltProject saltProject) {
        if (this.inProgress.isLocked()) {
            throw new PepperInActionException("Cannot set a new salt project to job '" + this.getId() + "', since this job was already started.");
        }
        this.saltProject = saltProject;
    }

    public PepperConfiguration getConfiguration() {
        if (this.props == null) {
            this.props = new PepperConfiguration();
        }
        return this.props;
    }

    public void setConfiguration(PepperConfiguration conf) {
        if (this.inProgress.isLocked()) {
            throw new PepperInActionException("Cannot set a new configuration to job '" + this.getId() + "', since this job was already started.");
        }
        this.props = conf;
        this.setMemPolicy(this.getConfiguration().getMemPolicy());
        this.setMaxNumerOfDocuments(this.getConfiguration().getMaxAmountOfDocuments());
    }

    public ModuleResolver getModuleResolver() {
        return this.moduleResolver;
    }

    public void setModuleResolver(ModuleResolver moduleResolver) {
        if (this.inProgress.isLocked()) {
            throw new PepperInActionException("Cannot set a new module resolver to job '" + this.getId() + "', since this job was already started.");
        }
        this.moduleResolver = moduleResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Step> getManipulationSteps() {
        if (this.manipulationSteps == null) {
            PepperJobImpl pepperJobImpl = this;
            synchronized (pepperJobImpl) {
                if (this.manipulationSteps == null) {
                    this.manipulationSteps = new Vector<Step>();
                }
            }
        }
        return this.manipulationSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Step> getImportSteps() {
        if (this.importSteps == null) {
            PepperJobImpl pepperJobImpl = this;
            synchronized (pepperJobImpl) {
                if (this.importSteps == null) {
                    this.importSteps = new Vector<Step>();
                }
            }
        }
        return this.importSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Step> getExportSteps() {
        if (this.exportSteps == null) {
            PepperJobImpl pepperJobImpl = this;
            synchronized (pepperJobImpl) {
                if (this.exportSteps == null) {
                    this.exportSteps = new Vector<Step>();
                }
            }
        }
        return this.exportSteps;
    }

    public List<Step> getAllSteps() {
        Vector<Step> allSteps = new Vector<Step>();
        if (this.getImportSteps() != null) {
            allSteps.addAll(this.getImportSteps());
        }
        if (this.getManipulationSteps() != null) {
            allSteps.addAll(this.getManipulationSteps());
        }
        if (this.getExportSteps() != null) {
            allSteps.addAll(this.getExportSteps());
        }
        return allSteps;
    }

    @Override
    public synchronized void addStepDesc(StepDesc stepDesc) {
        super.addStepDesc(stepDesc);
        this.addStep(stepDesc);
    }

    public synchronized Step addStep(StepDesc stepDesc) {
        if (this.inProgress.isLocked()) {
            throw new PepperInActionException("Cannot add a new step description to job '" + this.getId() + "', since this job was already started.");
        }
        if (stepDesc == null) {
            throw new WorkflowException("Cannot deal with an empty StepDesc object for job '" + this.getId() + "'.");
        }
        if (this.getModuleResolver() == null) {
            throw new PepperFWException("Cannot add step '" + stepDesc + "', because no module resolver is set.");
        }
        Step step = null;
        if (MODULE_TYPE.MANIPULATOR.equals((Object)stepDesc.getModuleType())) {
            step = new Step("ma" + (this.getManipulationSteps().size() + 1), stepDesc);
        } else if (MODULE_TYPE.IMPORTER.equals((Object)stepDesc.getModuleType())) {
            step = new Step("im" + (this.getImportSteps().size() + 1), stepDesc);
        } else if (MODULE_TYPE.EXPORTER.equals((Object)stepDesc.getModuleType())) {
            step = new Step("ex" + (this.getExportSteps().size() + 1), stepDesc);
        } else {
            throw new WorkflowException("Cannot add step description, because the 'MODULE_TYPE' is not set.");
        }
        this.addStep(step);
        return step;
    }

    public synchronized void addStep(Step step) {
        if (this.inProgress.isLocked()) {
            throw new PepperInActionException("Cannot add a new step to job '" + this.getId() + "', since this job was already started.");
        }
        if (step == null) {
            throw new WorkflowException("Cannot deal with an empty step object for job '" + this.getId() + "'.");
        }
        if (step.getModuleController() == null || step.getModuleController().getPepperModule() == null) {
            if (this.getModuleResolver() == null) {
                throw new PepperFWException("Cannot add the given step '" + step.getId() + "', because it does not contain a module controller and the module resolver for this job '" + this.getId() + "' is not set. So the Pepper module can not be estimated.");
            }
            if (this.getSaltProject() == null) {
                throw new PepperFWException("Cannot add a step '" + step.getId() + "', since no '" + SaltProject.class.getSimpleName() + "' is set for job '" + this.getId() + "'.");
            }
            PepperModule pepperModule = this.getModuleResolver().getPepperModule(step);
            if (pepperModule == null) {
                throw new WorkflowException("No Pepper module matching to step '" + step.getId() + "' was found: " + step);
            }
            pepperModule.setSaltProject(this.getSaltProject());
            step.setPepperModule(pepperModule);
        }
        step.getModuleController().setJob(this);
        if (MODULE_TYPE.MANIPULATOR.equals((Object)step.getModuleType())) {
            this.getManipulationSteps().add(step);
        } else if (MODULE_TYPE.IMPORTER.equals((Object)step.getModuleType())) {
            this.getImportSteps().add(step);
        } else if (MODULE_TYPE.EXPORTER.equals((Object)step.getModuleType())) {
            this.getExportSteps().add(step);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DocumentBus> getDocumentBuses() {
        if (this.documentBuses == null) {
            PepperJobImpl pepperJobImpl = this;
            synchronized (pepperJobImpl) {
                if (this.documentBuses == null) {
                    this.documentBuses = new Vector<DocumentBus>();
                }
            }
        }
        return this.documentBuses;
    }

    protected synchronized void wire() {
        if (this.getImportSteps().size() == 0) {
            throw new NotInitializedException("Cannot wire job '" + this + "', since no import steps were given.");
        }
        if (this.getExportSteps().size() == 0) {
            throw new NotInitializedException("Cannot wire job '" + this + "', since no export steps were given.");
        }
        Vector<String> importStepIds = new Vector<String>();
        for (Step step : this.getImportSteps()) {
            importStepIds.add(step.getModuleController().getId());
        }
        Vector<String> exportStepIds = new Vector<String>();
        for (Step step : this.getExportSteps()) {
            exportStepIds.add(step.getModuleController().getId());
        }
        this.initialDocumentBuses = new Vector<DocumentBus>();
        for (Step step : this.getImportSteps()) {
            InitialDocumentBus initialDocumentBus = new InitialDocumentBus(step.getModuleController().getId());
            initialDocumentBus.setPepperJob(this);
            initialDocumentBus.setMemPolicy(this.getMemPolicy());
            step.getModuleController().setInputDocumentBus(initialDocumentBus);
            this.initialDocumentBuses.add(initialDocumentBus);
            this.getDocumentBuses().add(initialDocumentBus);
        }
        TerminalDocumentBus terminalDocumentBus = new TerminalDocumentBus(exportStepIds);
        terminalDocumentBus.setPepperJob(this);
        terminalDocumentBus.setMemPolicy(this.getMemPolicy());
        this.getDocumentBuses().add(terminalDocumentBus);
        for (Step exportStep : this.getExportSteps()) {
            exportStep.getModuleController().setOutputDocumentBus(terminalDocumentBus);
        }
        if (0 < this.getManipulationSteps().size()) {
            Step lastManipulationStep;
            Step step = this.getManipulationSteps().get(0);
            if (step == null) {
                throw new PepperFWException("The first step in list of manipulation steps is null.");
            }
            Vector<String> firstManipulationStepIds = new Vector<String>();
            firstManipulationStepIds.add(step.getModuleController().getId());
            DocumentBus firstDocumentBus = new DocumentBus(importStepIds, firstManipulationStepIds);
            firstDocumentBus.setPepperJob(this);
            firstDocumentBus.setMemPolicy(this.getMemPolicy());
            this.getDocumentBuses().add(firstDocumentBus);
            for (Step step2 : this.getImportSteps()) {
                step2.getModuleController().setOutputDocumentBus(firstDocumentBus);
            }
            step.getModuleController().setInputDocumentBus(firstDocumentBus);
            if (this.getManipulationSteps().size() > 1) {
                Step lastStep = null;
                for (Step manipulationStep : this.getManipulationSteps()) {
                    if (manipulationStep == null) {
                        throw new PepperFWException("A manipulation step is null.");
                    }
                    if (lastStep != null) {
                        DocumentBus documentBus = new DocumentBus(lastStep.getModuleController().getId(), manipulationStep.getModuleController().getId());
                        documentBus.setPepperJob(this);
                        documentBus.setMemPolicy(this.getMemPolicy());
                        this.getDocumentBuses().add(documentBus);
                        lastStep.getModuleController().setOutputDocumentBus(documentBus);
                        manipulationStep.getModuleController().setInputDocumentBus(documentBus);
                    }
                    lastStep = manipulationStep;
                }
            }
            if ((lastManipulationStep = this.getManipulationSteps().get(this.getManipulationSteps().size() - 1)) == null) {
                throw new PepperFWException("The last step in list of manipulation steps is null.");
            }
            Vector<String> vector = new Vector<String>();
            vector.add(lastManipulationStep.getModuleController().getId());
            DocumentBus lastDocumentBus = new DocumentBus(vector, exportStepIds);
            lastDocumentBus.setPepperJob(this);
            lastDocumentBus.setMemPolicy(this.getMemPolicy());
            this.getDocumentBuses().add(lastDocumentBus);
            lastManipulationStep.getModuleController().setOutputDocumentBus(lastDocumentBus);
            for (Step exportStep : this.getExportSteps()) {
                exportStep.getModuleController().setInputDocumentBus(lastDocumentBus);
            }
        } else {
            DocumentBus documentBus = new DocumentBus(importStepIds, exportStepIds);
            documentBus.setPepperJob(this);
            documentBus.setMemPolicy(this.getMemPolicy());
            this.getDocumentBuses().add(documentBus);
            for (Step importStep : this.getImportSteps()) {
                importStep.getModuleController().setOutputDocumentBus(documentBus);
            }
            for (Step exportStep : this.getExportSteps()) {
                exportStep.getModuleController().setInputDocumentBus(documentBus);
            }
        }
        this.isWired = true;
    }

    protected synchronized void importCorpusStructures() {
        try {
            if (!this.isWired) {
                this.wire();
            }
            Vector futures = new Vector();
            int numOfImportStep = 0;
            for (Step step : this.getImportSteps()) {
                if (this.getSaltProject() == null) {
                    throw new PepperFWException("Cannot import corpus structure, because no salt project is set.");
                }
                SCorpusGraph sCorpusGraph = null;
                if (this.getSaltProject().getCorpusGraphs().size() > numOfImportStep && this.getSaltProject().getCorpusGraphs().get(numOfImportStep) != null) {
                    sCorpusGraph = (SCorpusGraph)this.getSaltProject().getCorpusGraphs().get(numOfImportStep);
                } else {
                    sCorpusGraph = SaltFactory.createSCorpusGraph();
                    this.getSaltProject().addCorpusGraph(sCorpusGraph);
                }
                futures.add(step.getModuleController().importCorpusStructure(sCorpusGraph));
                ++numOfImportStep;
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new PepperModuleException("Failed to import corpus by module. Nested exception was: ", e.getCause());
                }
                catch (InterruptedException e) {
                    throw new PepperFWException("Failed to import corpus by module. Nested exception was: ", e.getCause());
                }
                catch (CancellationException e) {
                    throw new PepperFWException("Failed to import corpus by module. Nested exception was: ", e.getCause());
                }
            }
            int i = 0;
            for (Step step : this.getImportSteps()) {
                if (this.getSaltProject().getCorpusGraphs().get(i) == null) {
                    throw new PepperModuleException("The importer '" + step.getModuleController().getPepperModule() + "' did not import a corpus structure.");
                }
                List<Identifier> importOrder = this.unifyProposedImportOrders((SCorpusGraph)this.getSaltProject().getCorpusGraphs().get(i));
                for (Identifier sDocumentId : importOrder) {
                    DocumentControllerImpl documentController = new DocumentControllerImpl();
                    SDocument sDoc = (SDocument)sDocumentId.getIdentifiableElement();
                    if (sDoc.getDocumentGraph() == null) {
                        sDoc.setDocumentGraph(SaltFactory.createSDocumentGraph());
                    }
                    documentController.setDocument(sDoc);
                    if (this.getConfiguration() != null) {
                        documentController.setCallGC(this.getConfiguration().getGcAfterDocumentSleep());
                    }
                    this.getDocumentControllers().add(documentController);
                    File docFile = null;
                    String prefix = sDoc.getName();
                    File tmpPath = new File(this.getConfiguration().getWorkspace().getAbsolutePath() + "/" + this.getId());
                    if (!tmpPath.exists() && !tmpPath.mkdirs()) {
                        logger.warn("Cannot create folder {}. ", (Object)tmpPath);
                    }
                    try {
                        if (prefix.length() < 3) {
                            prefix = prefix + "artificial";
                        }
                        docFile = File.createTempFile(prefix, ".salt", tmpPath);
                    }
                    catch (IOException e) {
                        throw new PepperFWException("Cannot store document '" + sDoc.getName() + "' to file '" + docFile + "' in folder for temporary files '" + tmpPath + "'. " + e.getMessage(), e);
                    }
                    documentController.setLocation(URI.createFileURI((String)docFile.getAbsolutePath()));
                    if (!this.getConfiguration().getKeepDocuments().booleanValue()) {
                        docFile.deleteOnExit();
                    }
                    this.initialDocumentBuses.get(i).put(documentController);
                    documentController.addModuleControllers(step.getModuleController());
                    for (Step manipulationStep : this.getManipulationSteps()) {
                        documentController.addModuleControllers(manipulationStep.getModuleController());
                    }
                    for (Step exportStep : this.getExportSteps()) {
                        documentController.addModuleControllers(exportStep.getModuleController());
                    }
                }
                this.initialDocumentBuses.get(i).finish("initial");
                ++i;
            }
            this.isImportedCorpusStructure = true;
        }
        catch (RuntimeException e) {
            if (e instanceof PepperException) {
                throw (PepperException)e;
            }
            throw new PepperFWException("An exception occured in job '" + this.getId() + "' while importing the corpus-structure. See nested exception: ", e);
        }
    }

    protected List<Identifier> unifyProposedImportOrders(SCorpusGraph sCorpusGraph) {
        List<Object> retVal = new Vector<Identifier>();
        if (sCorpusGraph == null) {
            throw new PepperFWException("Cannot unify the import order, for an empty SCorpusGraph object.");
        }
        Vector<List<Identifier>> listOfOrders = new Vector<List<Identifier>>();
        for (Step step : this.getAllSteps()) {
            if (step.getModuleController() == null) {
                throw new PepperFWException("Cannot unify proposed import orders, since step '" + step.getId() + "' does not contain a module controller.");
            }
            if (step.getModuleController().getPepperModule() == null) {
                throw new PepperFWException("Cannot unify proposed import orders, since module controller '" + step.getModuleController().getId() + "' does not contain a Pepper module.");
            }
            List<Identifier> importOrder = step.getModuleController().getPepperModule().proposeImportOrder(sCorpusGraph);
            if (importOrder == null || importOrder.size() <= 0) continue;
            if (importOrder.size() < sCorpusGraph.getDocuments().size()) {
                for (SDocument sDoc : sCorpusGraph.getDocuments()) {
                    if (importOrder.contains(sDoc.getIdentifier())) continue;
                    importOrder.add(sDoc.getIdentifier());
                }
            }
            listOfOrders.add(importOrder);
        }
        if (listOfOrders.size() == 0) {
            for (SDocument sDocument : sCorpusGraph.getDocuments()) {
                retVal.add(sDocument.getIdentifier());
            }
        } else if (listOfOrders.size() == 1) {
            retVal = (List)listOfOrders.get(0);
        } else {
            retVal = (List)listOfOrders.get(0);
            logger.warn("Sorry the feature of unifying more than one list of proposed import orders is not yet implemented. ");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DocumentController> getDocumentControllers() {
        if (this.documentControllers == null) {
            PepperJobImpl pepperJobImpl = this;
            synchronized (pepperJobImpl) {
                if (this.documentControllers == null) {
                    this.documentControllers = new Vector<DocumentController>();
                }
            }
        }
        return this.documentControllers;
    }

    @Override
    public String getStatusReport() {
        StringBuilder retVal = new StringBuilder();
        retVal.append("--------------------------- pepper job status ---------------------------");
        retVal.append("\n");
        retVal.append("id:\t\t\t'");
        retVal.append(this.getId());
        retVal.append("\n");
        retVal.append("active documents:\t");
        retVal.append(this.getNumOfActiveDocuments());
        retVal.append(" of ");
        retVal.append(this.getMaxNumberOfDocuments());
        retVal.append("\n");
        retVal.append("status:\t\t\t");
        retVal.append((Object)this.getStatus());
        retVal.append("\n");
        StringBuilder detailedStr = new StringBuilder();
        double progressOverAll = 0.0;
        int numOfDocuments = 0;
        if (this.getDocumentControllers().isEmpty()) {
            retVal.append("- no documents found to display progress -\n");
        } else {
            String sleep = " (sleep)";
            int distance = 0;
            for (DocumentController docController : this.getDocumentControllers()) {
                String globalId = docController.getGlobalId();
                if (distance >= globalId.length()) continue;
                distance = globalId.length();
            }
            distance = distance + 4 + sleep.length() + DOCUMENT_STATUS.IN_PROGRESS.toString().length();
            StringBuilder docInfo = null;
            for (DocumentController docController : this.getDocumentControllers()) {
                docInfo = new StringBuilder();
                ++numOfDocuments;
                double progress = docController.getProgress();
                progressOverAll += progress;
                String progressStr = new DecimalFormat("###.##").format(progress * 100.0) + "%";
                docInfo.append(docController.getGlobalId());
                docInfo.append("(");
                docInfo.append((Object)docController.getGlobalStatus());
                if (docController.isAsleep()) {
                    docInfo.append("/sleep");
                } else {
                    docInfo.append("/");
                    if (!(DOCUMENT_STATUS.COMPLETED.equals((Object)docController.getGlobalStatus()) || DOCUMENT_STATUS.DELETED.equals((Object)docController.getGlobalStatus()) || DOCUMENT_STATUS.FAILED.equals((Object)docController.getGlobalStatus()))) {
                        if (docController.getCurrentModuleController() == null || docController.getCurrentModuleController().getPepperModule() == null) {
                            docInfo.append("???");
                        } else {
                            docInfo.append(docController.getCurrentModuleController().getPepperModule().getName());
                        }
                    }
                }
                docInfo.append(")");
                detailedStr.append(String.format("%-" + distance + "s%8s", docInfo.toString(), progressStr));
                detailedStr.append("\n");
            }
            retVal.append("total progress:\t\t");
            if (numOfDocuments != 0) {
                retVal.append(new DecimalFormat("###.##").format(progressOverAll / (double)numOfDocuments * 100.0) + "%");
            }
            retVal.append("\n");
            retVal.append("processing time:\t");
            retVal.append(DurationFormatUtils.formatDurationHMS((long)this.getProcessingTime()));
            retVal.append("\n");
            if (this.getConfiguration().getDetaialedStatReport().booleanValue()) {
                retVal.append(detailedStr.toString());
            }
        }
        retVal.append("-------------------------------------------------------------------------");
        retVal.append("\n");
        return retVal.toString();
    }

    protected synchronized Collection<Pair<Step, Collection<String>>> checkReadyToStart() {
        ArrayList<Pair<Step, Collection<String>>> retVal = new ArrayList<Pair<Step, Collection<String>>>();
        for (Step step : this.getAllSteps()) {
            if (step.getModuleController().getPepperModule().isReadyToStart()) continue;
            ImmutablePair stepReason = new ImmutablePair((Object)step, step.getModuleController().getPepperModule().getStartProblems());
            retVal.add((Pair<Step, Collection<String>>)stepReason);
            logger.error("Cannot run pepper job '" + this.getId() + "', because one of the involved modules '" + step.getModuleController().getPepperModule().getFingerprint() + "' is not ready to run.");
        }
        return retVal;
    }

    private Long getStartTime() {
        return this.startTime;
    }

    public Long getProcessingTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public void convert() {
        if (!this.inProgress.tryLock()) {
            throw new PepperInActionException("Cannot run convert() of job '" + this.getId() + "', since this job was already started.");
        }
        this.inProgress.lock();
        try {
            Collection<Pair<Step, Collection<String>>> notReadyModules;
            this.startTime = System.currentTimeMillis();
            this.status = JOB_STATUS.INITIALIZING;
            if (!this.isWired) {
                this.wire();
            }
            if (!this.isReadyToStart && (notReadyModules = this.checkReadyToStart()).size() != 0) {
                StringBuilder str = new StringBuilder();
                for (Pair<Step, Collection<String>> problems : notReadyModules) {
                    str.append("[");
                    str.append(problems.getLeft());
                    str.append(": ");
                    str.append(problems.getRight());
                    str.append("], ");
                }
                throw new PepperException("Cannot run Pepper job '" + this.getId() + "', because at least one of the involved jobs is not ready to run: '" + str.toString() + "'. ");
            }
            this.status = JOB_STATUS.IMPORTING_CORPUS_STRUCTURE;
            if (!this.isImportedCorpusStructure) {
                this.importCorpusStructures();
            }
            if (this.cancellationRequested.get()) {
                this.status = JOB_STATUS.ENDED_WITH_ERRORS;
                return;
            }
            this.status = JOB_STATUS.IMPORTING_DOCUMENT_STRUCTURE;
            Vector<ImmutablePair> futures = new Vector<ImmutablePair>();
            for (Step step : this.getAllSteps()) {
                if (step.getModuleController().getPepperModule().getSaltProject() == null) {
                    step.getModuleController().getPepperModule().setSaltProject(this.getSaltProject());
                }
                futures.add(new ImmutablePair((Object)step.getModuleController(), step.getModuleController().processDocumentStructures()));
            }
            int stepNum = 0;
            StringBuilder str = new StringBuilder();
            for (Step step : this.getAllSteps()) {
                str.append("+----------------------------------- step ");
                str.append(++stepNum);
                str.append(" -----------------------------------+\n");
                String string = "|%-15s%-63s|\n";
                str.append(String.format(string, step.getModuleType().toString().toLowerCase() + ":", step.getName()));
                str.append(String.format(string, "path:", step.getCorpusDesc().getCorpusPath()));
                if (MODULE_TYPE.IMPORTER.equals((Object)step.getModuleType())) {
                    int idxCorpusGraph = this.getSaltProject().getCorpusGraphs().indexOf(((PepperImporter)step.getModuleController().getPepperModule()).getCorpusGraph());
                    str.append(String.format(string, "corpus index:", idxCorpusGraph));
                }
                boolean hasProperties = false;
                StringBuilder propStr = new StringBuilder();
                if (step.getModuleController().getPepperModule().getProperties().getPropertyDesctriptions() != null) {
                    String string2 = "|               %-25s%-38s|\n";
                    for (PepperModuleProperty<?> prop : step.getModuleController().getPepperModule().getProperties().getPropertyDesctriptions()) {
                        if (prop.getValue() == null) continue;
                        hasProperties = true;
                        propStr.append(String.format(string2, prop.getName() + ":", prop.getValue()));
                    }
                }
                String string3 = "|%-15s%-63s|\n";
                if (hasProperties) {
                    str.append(String.format(string3, "properties:", ""));
                    str.append(propStr.toString());
                } else {
                    str.append(String.format(string3, "properties:", "- none -"));
                }
                str.append("|                                                                              |\n");
            }
            str.append("+------------------------------------------------------------------------------+\n");
            logger.info(str.toString());
            boolean stillRunning = true;
            while (stillRunning) {
                stillRunning = false;
                if (this.cancellationRequested.get()) {
                    for (Pair pair : futures) {
                        ((Future)pair.getRight()).cancel(true);
                    }
                } else {
                    for (Pair pair : futures) {
                        try {
                            if (((Future)pair.getRight()).isDone()) continue;
                            stillRunning = true;
                            break;
                        }
                        catch (CancellationException e) {
                            if (e.getCause() != null && e.getCause() instanceof PepperException) {
                                throw (PepperException)e.getCause();
                            }
                            throw new PepperFWException("Failed to process document by module '" + pair.getLeft() + "'. Nested exception was: ", e.getCause());
                        }
                    }
                }
                Thread.yield();
            }
            this.status = JOB_STATUS.ENDED;
        }
        catch (RuntimeException e) {
            this.status = JOB_STATUS.ENDED_WITH_ERRORS;
            if (e instanceof PepperException) {
                throw (PepperException)e;
            }
            throw new PepperFWException("An exception occured in job '" + this.getId() + "' while importing the corpus-structure. See nested exception: " + e.getMessage(), e);
        }
        finally {
            this.inProgress.unlock();
        }
    }

    @Override
    public void convertFrom() {
        if (this.getExportSteps().size() > 0) {
            logger.warn("Cannot consider given export steps, any export step is ignored when invoking 'convertFrom()'. To create a conversion process with export steps use 'convert()' instead. ");
            this.exportSteps.clear();
        }
        this.addStepDesc(new StepDesc().setName("DoNothingExporter").setModuleType(MODULE_TYPE.EXPORTER).setCorpusDesc(new CorpusDesc().setCorpusPath(URI.createFileURI((String)PepperUtil.getTempFile().getAbsolutePath()))));
        this.convert();
    }

    @Override
    public void convertTo() {
        if (this.getImportSteps().size() > 0) {
            logger.warn("Cannot consider given import steps, any import step is ignored when invoking 'convertTo()'. To create a conversion process with import steps use 'convert()' instead. ");
            this.importSteps.clear();
        }
        this.addStepDesc(new StepDesc().setName("DoNothingImporter").setModuleType(MODULE_TYPE.IMPORTER).setCorpusDesc(new CorpusDesc().setCorpusPath(URI.createFileURI((String)PepperUtil.getTempFile().getAbsolutePath()))));
        this.convert();
    }

    @Override
    public void cancelConversion() {
        this.cancellationRequested.set(true);
    }

    public boolean isCancellationRequested() {
        return this.cancellationRequested.get();
    }

    public MEMORY_POLICY getMemPolicy() {
        return this.memPolicy;
    }

    protected void setMemPolicy(MEMORY_POLICY memPolicy) {
        this.memPolicy = memPolicy;
    }

    protected void setMaxNumerOfDocuments(int maxNumOfDocuments) {
        this.maxNumOfDocuments = maxNumOfDocuments;
    }

    public int getMaxNumberOfDocuments() {
        return this.maxNumOfDocuments;
    }

    public int getNumOfActiveDocuments() {
        return this.getActiveDocuments().size();
    }

    public Set<DocumentController> getActiveDocuments() {
        if (this.activeDocuments == null) {
            this.activeDocuments = new HashSet<DocumentController>();
        }
        return this.activeDocuments;
    }

    public boolean getPermissionForProcessDoument(DocumentController controller) {
        if (!MEMORY_POLICY.GREEDY.equals((Object)this.getMemPolicy())) {
            this.numOfDocsLock.lock();
            try {
                while (this.getNumOfActiveDocuments() >= this.getMaxNumberOfDocuments()) {
                    this.numOfDocsCondition.await();
                }
                this.getActiveDocuments().add(controller);
            }
            catch (InterruptedException e) {
                throw new PepperFWException("Something went wrong, when waiting for lock 'numOfDocsCondition'.", e);
            }
            finally {
                this.numOfDocsLock.unlock();
            }
        }
        return true;
    }

    public void releaseDocument(DocumentController controller) {
        this.numOfDocsLock.lock();
        try {
            this.getActiveDocuments().remove(controller);
            this.numOfDocsCondition.signal();
        }
        finally {
            this.numOfDocsLock.unlock();
        }
    }

    @Override
    public URI save(URI uri) {
        if (uri == null) {
            throw new PepperException("Cannot save Pepper job '" + this.getId() + "', because the passed uri is empty. ");
        }
        File file = null;
        if ("pepper".equals(uri.fileExtension())) {
            file = new File(uri.toFileString());
        } else {
            String directory = uri.toFileString();
            if (!directory.endsWith("/")) {
                directory = directory + "/";
            }
            file = new File(directory + this.getId() + "." + "pepper");
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            if (!file.getParentFile().canWrite()) {
                throw new PepperModuleXMLResourceException("Cannot create folder '" + file.getParentFile().getAbsolutePath() + "' to store Pepper workflow file, because of an access permission. ");
            }
            throw new PepperModuleXMLResourceException("Cannot create folder '" + file.getParentFile().getAbsolutePath() + "' to store Pepper workflow file. ");
        }
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter xml = new XMLStreamWriter(xof.createXMLStreamWriter(new FileWriter(file.getAbsolutePath())));
            xml.setPrettyPrint(true);
            xml.writeStartDocument();
            xml.writeStartElement("pepper-job");
            if (this.getId() != null) {
                xml.writeAttribute("id", this.getId());
            }
            xml.writeAttribute("version", "1.0");
            ArrayList<StepDesc> importers = new ArrayList<StepDesc>();
            ArrayList<StepDesc> manipulators = new ArrayList<StepDesc>();
            ArrayList<StepDesc> exporters = new ArrayList<StepDesc>();
            for (StepDesc step : this.getStepDescs()) {
                if (MODULE_TYPE.IMPORTER.equals((Object)step.getModuleType())) {
                    importers.add(step);
                    continue;
                }
                if (MODULE_TYPE.MANIPULATOR.equals((Object)step.getModuleType())) {
                    manipulators.add(step);
                    continue;
                }
                if (!MODULE_TYPE.EXPORTER.equals((Object)step.getModuleType())) continue;
                exporters.add(step);
            }
            for (StepDesc step : importers) {
                xml.writeStartElement("importer");
                PepperJobImpl.save_module(xml, step);
                xml.writeEndElement();
            }
            for (StepDesc step : manipulators) {
                xml.writeStartElement("manipulator");
                PepperJobImpl.save_module(xml, step);
                xml.writeEndElement();
            }
            for (StepDesc step : exporters) {
                xml.writeStartElement("exporter");
                PepperJobImpl.save_module(xml, step);
                xml.writeEndElement();
            }
            xml.writeEndElement();
            xml.writeEndDocument();
            xml.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new PepperException("Cannot store Pepper job '" + this.getId() + "' because of a nested exception. ", e);
        }
        return URI.createFileURI((String)file.getAbsolutePath());
    }

    private static void save_module(XMLStreamWriter xml, StepDesc step) throws XMLStreamException {
        if (step.getName() != null) {
            xml.writeAttribute("name", step.getName());
        }
        if (step.getCorpusDesc().getFormatDesc().getFormatName() != null) {
            xml.writeAttribute("formatName", step.getCorpusDesc().getFormatDesc().getFormatName());
        }
        if (step.getCorpusDesc().getFormatDesc().getFormatVersion() != null) {
            xml.writeAttribute("formatVersion", step.getCorpusDesc().getFormatDesc().getFormatVersion());
        }
        if (step.getVersion() != null) {
            xml.writeAttribute("name", step.getName());
        }
        if (step.getCorpusDesc() != null && step.getCorpusDesc().getCorpusPath() != null) {
            xml.writeAttribute("path", step.getCorpusDesc().getCorpusPath().toFileString());
        }
        if (step.getProps() != null && step.getProps().size() > 0) {
            xml.writeStartElement("customization");
            for (Object key : step.getProps().keySet()) {
                xml.writeStartElement("property");
                xml.writeAttribute("key", key.toString());
                if (step.getProps().get(key) != null) {
                    xml.writeCharacters(step.getProps().get(key).toString());
                }
                xml.writeEndElement();
            }
            xml.writeEndElement();
        }
    }

    @Override
    public void clear() {
        if (this.stepDescs != null) {
            this.stepDescs.clear();
        }
        if (this.importSteps != null) {
            this.importSteps.clear();
        }
        if (this.manipulationSteps != null) {
            this.manipulationSteps.clear();
        }
        if (this.exportSteps != null) {
            this.exportSteps.clear();
        }
    }

    @Override
    public void load(URI uri) {
        if (uri.isFile()) {
            XMLReader xmlReader;
            SAXParser parser;
            File wdFile = new File(uri.toFileString());
            this.setBaseDir(uri.trimSegments(1));
            SAXParserFactory factory = SAXParserFactory.newInstance();
            WorkflowDescriptionReader contentHandler = new WorkflowDescriptionReader();
            contentHandler.setPepperJob(this);
            contentHandler.setLocation(uri);
            this.clear();
            try {
                parser = factory.newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReader.setContentHandler(contentHandler);
            }
            catch (ParserConfigurationException e) {
                throw new PepperModuleXMLResourceException("Cannot load Pepper workflow description file '" + wdFile.getAbsolutePath() + "': " + e.getMessage() + ". ", e);
            }
            catch (Exception e) {
                throw new PepperModuleXMLResourceException("Cannot load Pepper workflow description file '" + wdFile.getAbsolutePath() + "': " + e.getMessage() + ". ", e);
            }
            try {
                FileInputStream inputStream = new FileInputStream(wdFile);
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                InputSource is = new InputSource(reader);
                is.setEncoding("UTF-8");
                xmlReader.parse(is);
            }
            catch (SAXException e) {
                try {
                    parser = factory.newSAXParser();
                    xmlReader = parser.getXMLReader();
                    xmlReader.setContentHandler(contentHandler);
                    xmlReader.parse(wdFile.getAbsolutePath());
                }
                catch (Exception e1) {
                    throw new PepperModuleXMLResourceException("Cannot load Pepper workflow description file '" + wdFile.getAbsolutePath() + "': " + e1.getMessage() + ". ", e1);
                }
            }
            catch (Exception e) {
                if (e instanceof PepperModuleException) {
                    throw (PepperModuleException)e;
                }
                throw new PepperModuleXMLResourceException("Cannot load Pepper workflow description file'" + wdFile + "', because of a nested exception: " + e.getMessage() + ". ", e);
            }
        } else {
            throw new UnsupportedOperationException("Currently Pepper can only load workflow description from local files.");
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getId());
        if (!this.getStepDescs().isEmpty()) {
            str.append("{");
            for (StepDesc stepDesc : this.getStepDescs()) {
                str.append(stepDesc.getName());
                str.append(", ");
            }
            str.append("}");
        } else {
            str.append("{");
            if (this.getImportSteps() != null) {
                for (Step step : this.getImportSteps()) {
                    str.append(step.getName());
                    str.append(", ");
                }
            }
            if (this.getManipulationSteps() != null) {
                for (Step step : this.getManipulationSteps()) {
                    str.append(step.getName());
                    str.append(", ");
                }
            }
            if (this.getExportSteps() != null) {
                for (Step step : this.getExportSteps()) {
                    str.append(step.getName());
                    str.append(", ");
                }
            }
            str.append("}");
        }
        return str.toString();
    }
}

