/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.core.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.exceptions.SaltInvalidModelException;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.exceptions.SaltTraverserException;
import org.slf4j.LoggerFactory;

public class GraphTraverserModule {
    private Map<GraphTraverseHandler, List<String>> traverseIdTable = new HashMap<GraphTraverseHandler, List<String>>();
    protected SGraph graph = null;

    public SGraph getGraph() {
        return this.graph;
    }

    public void setGraph(SGraph graph) {
        this.graph = graph;
    }

    public void traverse(List<SNode> startNodes, SGraph.GRAPH_TRAVERSE_TYPE traverseType, String traverseId, GraphTraverseHandler traverseHandler) {
        this.traverse(startNodes, traverseType, traverseId, traverseHandler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverse(List<? extends SNode> startNodes, SGraph.GRAPH_TRAVERSE_TYPE traverseType, String traverseId, GraphTraverseHandler traverseHandler, boolean isCycleSafe) {
        if (this.getGraph() == null) {
            throw new SaltTraverserException("Cannot start traversing graph, because the graph is null.");
        }
        if (startNodes == null || startNodes.size() == 0) {
            throw new SaltTraverserException("Cannot start traversing graph '" + this.getGraph().getId() + "', because the given start nodes are empty.");
        }
        if (traverseType == null) {
            throw new SaltTraverserException("Cannot start traversing graph '" + this.getGraph().getId() + "', because the given traverseType is empty.");
        }
        if (traverseHandler == null) {
            throw new SaltTraverserException("Cannot start traversing graph '" + this.getGraph().getId() + "', because the given callback handler 'traverseHandler' is empty.");
        }
        Map<GraphTraverseHandler, List<String>> map = this.traverseIdTable;
        synchronized (map) {
            List<Object> ids;
            if (this.traverseIdTable.containsKey(traverseHandler)) {
                ids = this.traverseIdTable.get(traverseHandler);
                if (ids.contains(traverseId)) {
                    throw new SaltTraverserException("Cannot start traversing graph '" + this.getGraph().getId() + "', because the traverse id '" + traverseId + "' is already registered for the given callback handler '" + traverseHandler + "'.");
                }
                ids.add(traverseId);
            } else {
                ids = new ArrayList<String>();
                ids.add(traverseId);
                this.traverseIdTable.put(traverseHandler, ids);
            }
        }
        Traverser traverser = new Traverser();
        traverser.startNodes = startNodes;
        traverser.traverseType = traverseType;
        traverser.traverseId = traverseId;
        traverser.traverseHandler = traverseHandler;
        traverser.isCycleSafe = isCycleSafe;
        traverser.setGraph(this.getGraph());
        traverser.run();
        Map<GraphTraverseHandler, List<String>> map2 = this.traverseIdTable;
        synchronized (map2) {
            if (this.traverseIdTable.get(traverseHandler).size() > 1) {
                this.traverseIdTable.get(traverseHandler).remove(traverseId);
            } else {
                this.traverseIdTable.remove(traverseHandler);
            }
        }
        if (traverser.getException() != null) {
            throw traverser.getException();
        }
    }

    static class Traverser
    implements Runnable {
        List<SNode> startNodes = null;
        SGraph.GRAPH_TRAVERSE_TYPE traverseType = null;
        String traverseId = null;
        GraphTraverseHandler traverseHandler = null;
        boolean isCycleSafe = true;
        private SGraph graph = null;
        private SaltException exception = null;
        private List<SNode> currentNodePath = null;

        Traverser() {
        }

        public void setGraph(SGraph graph) {
            this.graph = graph;
        }

        public SGraph getGraph() {
            return this.graph;
        }

        private void setException(SaltException exception) {
            this.exception = exception;
        }

        public SaltException getException() {
            return this.exception;
        }

        protected SNode nextChild(NodeEntry entry) {
            List outRels;
            SNode retVal = null;
            if (entry.order == 0 && (outRels = this.getGraph().getOutRelations(entry.node.getId())) != null && !outRels.isEmpty()) {
                entry.iterator = outRels.iterator();
            }
            if (entry.iterator != null && entry.iterator.hasNext()) {
                try {
                    entry.rel = (SRelation)entry.iterator.next();
                    retVal = (SNode)entry.rel.getTarget();
                    entry.order++;
                }
                catch (ConcurrentModificationException ex) {
                    LoggerFactory.getLogger(GraphTraverserModule.class).warn("Graph was changed during traversal", (Throwable)ex);
                    entry.iterator = null;
                }
            }
            if (entry.iterator == null && (outRels = this.getGraph().getOutRelations(entry.node.getId())) != null && !outRels.isEmpty() && entry.order < outRels.size()) {
                entry.rel = (SRelation)outRels.get(entry.order);
                retVal = (SNode)entry.rel.getTarget();
                entry.order++;
            }
            return retVal;
        }

        @Override
        public void run() {
            try {
                if (SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST.equals((Object)this.traverseType)) {
                    for (SNode startNode : this.startNodes) {
                        if (!this.traverseHandler.checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, null, startNode, 0L)) continue;
                        HashSet<SNode> visitedNodes = null;
                        if (this.isCycleSafe) {
                            visitedNodes = new HashSet<SNode>();
                        }
                        Stack<NodeEntry> parentStack = new Stack<NodeEntry>();
                        NodeEntry currentEntry = new NodeEntry(startNode, 0);
                        while (!parentStack.isEmpty() || currentEntry != null) {
                            SNode nextChild;
                            NodeEntry peekEntry;
                            if (currentEntry != null) {
                                if (this.isCycleSafe && visitedNodes.contains(currentEntry.node)) {
                                    StringBuffer text = new StringBuffer();
                                    if (this.currentNodePath != null) {
                                        for (SNode node : this.currentNodePath) {
                                            if (node != null) {
                                                text.append(node.getId());
                                            } else {
                                                text.append("null");
                                            }
                                            text.append(" --> ");
                                        }
                                    }
                                    text.append(currentEntry.node.getId());
                                    throw new SaltInvalidModelException("A cycle in graph '" + this.graph.getId() + "' has been detected, while traversing with type '" + (Object)((Object)this.traverseType) + "'. The cycle has been detected when visiting node '" + currentEntry.node + "' while current path was '" + text.toString() + "'.");
                                }
                                peekEntry = null;
                                if (!parentStack.isEmpty()) {
                                    peekEntry = (NodeEntry)parentStack.peek();
                                }
                                parentStack.push(currentEntry);
                                if (this.isCycleSafe) {
                                    visitedNodes.add(currentEntry.node);
                                }
                                nextChild = this.nextChild(currentEntry);
                                if (peekEntry == null) {
                                    this.traverseHandler.nodeReached(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, currentEntry.node, null, null, 0L);
                                } else {
                                    this.traverseHandler.nodeReached(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, currentEntry.node, peekEntry.rel, peekEntry.rel != null ? (SNode)peekEntry.rel.getSource() : null, peekEntry.order);
                                }
                                if (nextChild != null) {
                                    if (this.traverseHandler.checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, currentEntry.rel, nextChild, currentEntry.order)) {
                                        currentEntry = new NodeEntry(nextChild, 0);
                                        continue;
                                    }
                                    currentEntry = null;
                                    continue;
                                }
                                currentEntry = null;
                                continue;
                            }
                            peekEntry = (NodeEntry)parentStack.peek();
                            if (peekEntry == null) continue;
                            nextChild = this.nextChild(peekEntry);
                            if (nextChild != null) {
                                if (this.traverseHandler.checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, peekEntry.rel, nextChild, peekEntry.order)) {
                                    currentEntry = new NodeEntry(nextChild, 0);
                                    continue;
                                }
                                currentEntry = null;
                                continue;
                            }
                            parentStack.pop();
                            if (this.isCycleSafe) {
                                visitedNodes.remove(peekEntry.node);
                            }
                            SNode peekNode = peekEntry.node;
                            peekEntry = null;
                            if (!parentStack.isEmpty()) {
                                peekEntry = (NodeEntry)parentStack.peek();
                            }
                            if (peekEntry == null) {
                                this.traverseHandler.nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, peekNode, null, null, 0L);
                                continue;
                            }
                            this.traverseHandler.nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, peekNode, peekEntry.rel, peekEntry.rel != null ? (SNode)peekEntry.rel.getSource() : null, peekEntry.order);
                        }
                    }
                } else if (SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST.equals((Object)this.traverseType)) {
                    for (SNode startNode : this.startNodes) {
                        this.currentNodePath = new ArrayList<SNode>();
                        if (!this.traverseHandler.checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, this.traverseId, null, startNode, 0L)) continue;
                        this.currentNodePath.add(startNode);
                        this.bottomUpDepthFirstRec(null, 0L);
                    }
                } else if (SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_BREADTH_FIRST.equals((Object)this.traverseType)) {
                    for (SNode startNode : this.startNodes) {
                        this.currentNodePath = new ArrayList<SNode>();
                        if (!this.traverseHandler.checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_BREADTH_FIRST, this.traverseId, null, startNode, 0L)) continue;
                        this.currentNodePath.add(startNode);
                    }
                    this.breadthFirst();
                } else if (SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_BREADTH_FIRST.equals((Object)this.traverseType)) {
                    for (SNode startNode : this.startNodes) {
                        this.currentNodePath = new ArrayList<SNode>();
                        if (!this.traverseHandler.checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_BREADTH_FIRST, this.traverseId, null, startNode, 0L)) continue;
                        this.currentNodePath.add(startNode);
                    }
                    this.breadthFirst();
                }
            }
            catch (SaltException e) {
                this.setException(e);
            }
            catch (Exception e2) {
                SaltException e = new SaltException("An exception occured while traversing the graph '" + this.graph.getId() + "' with path '" + this.currentNodePath + "'. because of " + e2.getMessage() + ". ", e2);
                this.setException(e);
            }
        }

        private void breadthFirst() {
            if (this.isCycleSafe) {
                throw new SaltException("Not able to detect cycles with breadth first search");
            }
            if (this.currentNodePath == null || this.currentNodePath.isEmpty()) {
                throw new SaltParameterException("Cannot traverse node starting at empty start node.");
            }
            boolean isTopDown = this.traverseType != SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_BREADTH_FIRST;
            SNode fromNode = null;
            SRelation fromRel = null;
            ArrayList<SNode> queuedNodes = new ArrayList<SNode>();
            ArrayList<SNode> queueReachedFrom = new ArrayList<SNode>();
            ArrayList<SRelation> queueReachedFromRel = new ArrayList<SRelation>();
            ArrayList<Integer> queueReachedOrder = new ArrayList<Integer>();
            queuedNodes.addAll(this.startNodes);
            for (SNode startNode : this.startNodes) {
                queueReachedFrom.add(startNode);
                queueReachedFromRel.add(null);
                queueReachedOrder.add(0);
            }
            this.currentNodePath.clear();
            while (!queuedNodes.isEmpty()) {
                SNode tNode = (SNode)queuedNodes.remove(0);
                fromNode = (SNode)queueReachedFrom.remove(0);
                fromRel = (SRelation)queueReachedFromRel.remove(0);
                Integer order = (Integer)queueReachedOrder.remove(0);
                List edgesIn = this.getGraph().getInRelations(tNode.getId());
                List edgesOut = this.getGraph().getOutRelations(tNode.getId());
                List edges = null;
                this.currentNodePath.add(tNode);
                this.traverseHandler.nodeReached(this.traverseType, this.traverseId, tNode, fromRel, fromNode, order.intValue());
                edges = isTopDown ? edgesOut : edgesIn;
                if (edges != null) {
                    int orderCount = 0;
                    for (SRelation e : edges) {
                        SNode n = null;
                        SNode sNode = n = isTopDown ? (SNode)e.getTarget() : (SNode)e.getSource();
                        if (this.traverseHandler.checkConstraint(this.traverseType, this.traverseId, e, n, order.intValue())) {
                            queuedNodes.add(n);
                            queueReachedFrom.add(fromNode);
                            queueReachedFromRel.add(e);
                            queueReachedOrder.add(orderCount);
                        }
                        ++orderCount;
                    }
                }
                this.traverseHandler.nodeLeft(this.traverseType, this.traverseId, tNode, fromRel, fromNode, order.intValue());
                this.currentNodePath.remove(0);
            }
        }

        private void topDownDepthFirstRec(SRelation<SNode, SNode> rel, long order) {
            if (this.currentNodePath == null || this.currentNodePath.size() == 0) {
                throw new SaltParameterException("Cannot traverse node starting at empty start node.");
            }
            SNode currNode = this.currentNodePath.get(this.currentNodePath.size() - 1);
            SNode parent = null;
            if (this.currentNodePath.size() > 1) {
                parent = this.currentNodePath.get(this.currentNodePath.size() - 2);
            }
            this.traverseHandler.nodeReached(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, currNode, rel, parent, order);
            List childEdges = this.getGraph().getOutRelations(currNode.getId());
            if (childEdges != null) {
                int i = 0;
                for (SRelation childRel : childEdges) {
                    SNode childNode;
                    if (!this.traverseHandler.checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, childRel, childNode = (SNode)childRel.getTarget(), order)) continue;
                    if (this.isCycleSafe && this.currentNodePath.contains(childNode)) {
                        StringBuffer text = new StringBuffer();
                        for (SNode node : this.currentNodePath) {
                            text.append(node.getId());
                            text.append(" --> ");
                        }
                        text.append(childNode.getId());
                        throw new SaltInvalidModelException("A cycle in graph '" + this.graph.getId() + "' has been detected, while traversing with type '" + (Object)((Object)this.traverseType) + "'. The cycle has been detected when visiting node '" + childNode + "' while current path was '" + text.toString() + "'.");
                    }
                    this.currentNodePath.add(childNode);
                    this.topDownDepthFirstRec(childRel, i);
                    this.currentNodePath.remove(this.currentNodePath.size() - 1);
                    ++i;
                }
            }
            this.traverseHandler.nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traverseId, currNode, rel, parent, order);
        }

        private void bottomUpDepthFirstRec(SRelation<SNode, SNode> edge, long order) {
            if (this.currentNodePath == null || this.currentNodePath.size() == 0) {
                throw new SaltParameterException("Cannot traverse node starting at empty start node.");
            }
            SNode currNode = this.currentNodePath.get(this.currentNodePath.size() - 1);
            SNode child = null;
            if (this.currentNodePath.size() > 1) {
                child = this.currentNodePath.get(this.currentNodePath.size() - 1);
            }
            this.traverseHandler.nodeReached(SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, this.traverseId, currNode, edge, child, order);
            List parentEdges = this.getGraph().getInRelations(currNode.getId());
            if (parentEdges != null) {
                int i = 0;
                for (SRelation parentEdge : parentEdges) {
                    SNode parentNode = (SNode)parentEdge.getSource();
                    if (this.isCycleSafe && this.currentNodePath.contains(parentNode)) {
                        throw new SaltInvalidModelException("A cycle in graph '" + this.graph.getId() + "' has been detected, while traversing with type '" + (Object)((Object)this.traverseType) + "'. The cycle has been detected when visiting node '" + parentNode + "' while current path was '" + this.currentNodePath + "'.");
                    }
                    this.currentNodePath.add(parentNode);
                    if (this.traverseHandler.checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, this.traverseId, parentEdge, parentNode, order)) {
                        this.bottomUpDepthFirstRec(parentEdge, i);
                        ++i;
                    }
                    this.currentNodePath.remove(this.currentNodePath.size() - 1);
                }
            }
            this.traverseHandler.nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, this.traverseId, currNode, edge, child, order);
        }

        private static class NodeEntry {
            private final SNode node;
            private int order;
            private Iterator<SRelation<SNode, SNode>> iterator;
            private SRelation<SNode, SNode> rel;

            public NodeEntry(SNode node, int order) {
                this.node = node;
                this.order = order;
            }

            public String toString() {
                return (this.node != null ? this.node.toString() : "") + ": " + this.order;
            }
        }
    }
}

