/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula;

import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.impl.PepperExporterImpl;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.paula.PAULAExporterProperties;
import org.corpus_tools.peppermodules.paula.Salt2PAULAMapper;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="PAULAExporterComponent", factory="PepperExporterComponentFactory")
public class PAULAExporter
extends PepperExporterImpl
implements PepperExporter {
    public static final String MODULE_NAME = "PAULAExporter";
    private Map<Identifier, URI> sDocumentResourceTable = null;

    public PAULAExporter() {
        this.setName(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-PAULAModules"));
        this.setDesc("The PAULA exporter exports data comming a Salt model to the PAULA format. ");
        this.addSupportedFormat("paula", "1.0", null);
        this.setProperties(new PAULAExporterProperties());
    }

    public void exportCorpusStructure() {
        for (SCorpusGraph sCorpusGraph : this.getSaltProject().getCorpusGraphs()) {
            if (sCorpusGraph == null) {
                throw new PepperFWException("No SCorpusGraph was passed for exportCorpusStructure(SCorpusGraph corpusGraph). This might be a bug of the pepper framework.");
            }
            Salt2PAULAMapper mapper = new Salt2PAULAMapper();
            mapper.setResourcePath(this.getResources());
            this.sDocumentResourceTable = this.mapCorpusStructure(sCorpusGraph, this.getCorpusDesc().getCorpusPath());
            if (this.sDocumentResourceTable == null) {
                throw new PepperModuleException((PepperModule)this, "mapCorpusStructure() returned an empty table. This might be a bug of pepper module.");
            }
            if (this.sDocumentResourceTable != null && this.sDocumentResourceTable.size() != 0) continue;
            throw new PepperModuleException((PepperModule)this, "Cannot export SCorpusGraph '" + sCorpusGraph.getName() + "', because of an unknown reason.");
        }
    }

    public Map<Identifier, URI> mapCorpusStructure(SCorpusGraph sCorpusGraph, URI corpusPath) {
        if (sCorpusGraph == null) {
            throw new PepperModuleException("Cannot export corpus structure, because sCorpusGraph is null.");
        }
        if (corpusPath == null) {
            throw new PepperModuleException("Cannot export corpus structure, because the path to export to is null.");
        }
        Hashtable<Identifier, URI> retVal = null;
        int numberOfCreatedDirectories = 0;
        List<SDocument> sDocumentList = Collections.synchronizedList(sCorpusGraph.getDocuments());
        Hashtable<Identifier, URI> tempRetVal = new Hashtable<Identifier, URI>();
        String corpusPathString = corpusPath.toFileString().replace("//", "/");
        corpusPathString = !corpusPathString.endsWith("/") ? corpusPathString.concat("/") : corpusPath.toFileString();
        for (SDocument sDocument : sDocumentList) {
            String completeDocumentPath = corpusPathString;
            String relativeDocumentPath = sDocument.getIdentifier().getValue().toString().replace("salt:/", "");
            completeDocumentPath = relativeDocumentPath.substring(0, 1).equals(File.pathSeparator) ? completeDocumentPath.concat(relativeDocumentPath.substring(1)) : completeDocumentPath.concat(relativeDocumentPath);
            if (new File(completeDocumentPath).isDirectory()) {
                ++numberOfCreatedDirectories;
                tempRetVal.put(sDocument.getIdentifier(), URI.createFileURI((String)completeDocumentPath));
                continue;
            }
            if (!new File(completeDocumentPath).mkdirs()) {
                throw new PepperModuleException("Cannot create directory " + completeDocumentPath);
            }
            ++numberOfCreatedDirectories;
            tempRetVal.put(sDocument.getIdentifier(), URI.createFileURI((String)completeDocumentPath));
        }
        if (numberOfCreatedDirectories > 0) {
            retVal = tempRetVal;
        }
        tempRetVal = null;
        return retVal;
    }

    public PepperMapper createPepperMapper(Identifier Identifier2) {
        Salt2PAULAMapper mapper = new Salt2PAULAMapper();
        if (this.sDocumentResourceTable == null) {
            throw new PepperFWException("this.sDocumentResourceTable() is not initialized. This might be a bug of pepper module '" + this.getName() + "'.");
        }
        URI resource = this.sDocumentResourceTable.get(Identifier2);
        mapper.setResourceURI(resource);
        mapper.setResourcePath(this.getResources());
        return mapper;
    }
}

