/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula;

import java.util.Collection;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.paula.PAULA2SaltMapper;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="PAULAImporterComponent", factory="PepperImporterComponentFactory")
public class PAULAImporter
extends PepperImporterImpl
implements PepperImporter {
    private String[] PAULA_FILE_ENDINGS = new String[]{"xml", "paula"};

    public PAULAImporter() {
        this.setName("PAULAImporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-PAULAModules"));
        this.setDesc("The PAULA importer imports data comming from the PAULA format to a Salt model. ");
        this.addSupportedFormat("paula", "1.0", null);
        this.getDocumentEndings().add("LEAF_FOLDER");
    }

    public PepperMapper createPepperMapper(Identifier Identifier2) {
        PAULA2SaltMapper mapper = new PAULA2SaltMapper();
        mapper.setPAULA_FILE_ENDINGS(this.PAULA_FILE_ENDINGS);
        if (Identifier2.getIdentifiableElement() instanceof SCorpus) {
            Collection pathes = this.getIdentifier2ResourceTable().values();
            int i = 0;
            for (URI path : pathes) {
                if (!path.equals(this.getIdentifier2ResourceTable().get(Identifier2))) continue;
                ++i;
            }
            if (i > 1) {
                mapper.setIsArtificialSCorpus(true);
            }
        }
        return mapper;
    }
}

