/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.paula.PAULA2SaltMapper;
import org.corpus_tools.peppermodules.paula.readers.PAULAReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class PAULAFileDelegator {
    private static final Logger logger = LoggerFactory.getLogger(PAULAFileDelegator.class);
    private File paulaPath = null;
    private List<File> paulaFiles = null;
    private PAULA2SaltMapper mapper = null;
    private List<File> processedPAULAFiles = null;
    private List<File> notProcessedPAULAFiles = null;
    private static volatile SAXParserFactory factory = SAXParserFactory.newInstance();

    public void setPaulaPath(File paulaPath) {
        this.paulaPath = paulaPath;
    }

    public File getPaulaPath() {
        return this.paulaPath;
    }

    public List<File> getPaulaFiles() {
        if (this.paulaFiles == null) {
            this.paulaFiles = new ArrayList<File>();
        }
        return this.paulaFiles;
    }

    public void setMapper(PAULA2SaltMapper mapper) {
        this.mapper = mapper;
    }

    public PAULA2SaltMapper getMapper() {
        return this.mapper;
    }

    public void startPaulaFiles() {
        if (this.getPaulaFiles() == null || this.getPaulaFiles().size() == 0) {
            throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot start reading paula-files, because no files are given.");
        }
        if (this.getPaulaPath() == null) {
            throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot start reading paula-files, because paula-path is not set. Please set paula-path first.");
        }
        this.processedPAULAFiles = new ArrayList<File>();
        this.notProcessedPAULAFiles = new ArrayList<File>();
        for (File paulaFile : this.getPaulaFiles()) {
            this.notProcessedPAULAFiles.add(paulaFile);
        }
        while (this.notProcessedPAULAFiles.size() > 0) {
            File paulaFile = this.notProcessedPAULAFiles.get(0);
            this.startPaulaFile(paulaFile);
        }
    }

    public void startPaulaFile(File paulaFile) {
        Long timestamp = System.nanoTime();
        if (paulaFile == null) {
            throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot start reading paula-file, because given file is empty.");
        }
        if (!paulaFile.isAbsolute()) {
            paulaFile = new File(this.getPaulaPath().getAbsolutePath() + "/" + paulaFile.toString());
        }
        if (paulaFile.isDirectory()) {
            throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot read the given paula-file ('" + paulaFile.getAbsolutePath() + "'), because it is a directory.");
        }
        Boolean isAlreadyProcessed = false;
        for (File paulaFile2 : this.processedPAULAFiles) {
            if (!paulaFile.getAbsolutePath().equals(paulaFile2.getAbsolutePath())) continue;
            isAlreadyProcessed = true;
        }
        if (!isAlreadyProcessed.booleanValue()) {
            logger.debug("[PAULAImporter] Importing paula-file: {}.", (Object)paulaFile.getAbsolutePath());
            this.notProcessedPAULAFiles.remove(paulaFile);
            this.processedPAULAFiles.add(paulaFile);
            PAULAReader paulaReader = new PAULAReader();
            paulaReader.setPaulaFileDelegator(this);
            paulaReader.setMapper(this.getMapper());
            paulaReader.setPaulaFile(paulaFile);
            try {
                SAXParser parser = factory.newSAXParser();
                XMLReader xmlReader = parser.getXMLReader();
                xmlReader.setContentHandler(paulaReader);
                xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", paulaReader);
                xmlReader.setDTDHandler(paulaReader);
                try {
                    FileInputStream inputStream = new FileInputStream(paulaFile.getAbsolutePath());
                    InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    InputSource is = new InputSource(reader);
                    is.setSystemId(paulaFile.getAbsolutePath());
                    is.setEncoding("UTF-8");
                    xmlReader.parse(is);
                }
                catch (SAXException e) {
                    try {
                        parser = factory.newSAXParser();
                        xmlReader = parser.getXMLReader();
                        xmlReader.setContentHandler(paulaReader);
                        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", paulaReader);
                        xmlReader.setDTDHandler(paulaReader);
                        xmlReader.parse(paulaFile.getAbsolutePath());
                    }
                    catch (Exception e1) {
                        throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot load paula file from resource '" + paulaFile.getAbsolutePath() + "'.", (Throwable)e1);
                    }
                }
            }
            catch (SAXNotRecognizedException e) {
                throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot read file '" + paulaFile.getAbsolutePath() + "'. Nested SAXNotSupported Exception is " + e.getLocalizedMessage());
            }
            catch (SAXNotSupportedException e) {
                throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot read file '" + paulaFile.getAbsolutePath() + "'. Nested SAXNotSupported Exception is " + e.getLocalizedMessage());
            }
            catch (ParserConfigurationException e) {
                throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot read file '" + paulaFile.getAbsolutePath() + "'. Nested ParserConfiguration Exception is " + e.getLocalizedMessage());
            }
            catch (SAXException e) {
                throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot read file '" + paulaFile.getAbsolutePath() + "'. Nested SAX Exception is " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new PepperModuleException((PepperMapper)this.getMapper(), "Cannot read file '" + paulaFile.getAbsolutePath() + "'. Nested IO Exception is " + e.getLocalizedMessage());
            }
            this.getMapper().addProgress(1.0 / (double)(this.processedPAULAFiles.size() + this.notProcessedPAULAFiles.size()));
            logger.debug("[PAULAImporter] Needed time to read document '{}':\t{}", (Object)paulaFile.getName(), (Object)((System.nanoTime() - timestamp) / 1000000L));
        }
    }
}

