/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula;

import com.google.common.collect.LinkedHashMultimap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepper.util.XMLStreamWriter;
import org.corpus_tools.peppermodules.paula.PAULAExporterProperties;
import org.corpus_tools.peppermodules.paula.PAULAXMLDictionary;
import org.corpus_tools.peppermodules.paula.PAULA_TYPE;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SMedialDS;
import org.corpus_tools.salt.common.SMedialRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SPathElement;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Salt2PAULAMapper
extends PepperMapperImpl
implements PAULAXMLDictionary,
FilenameFilter {
    private static final Logger logger = LoggerFactory.getLogger((String)"PAULAExporter");
    private URI resourcePath = null;
    public static final String PATH_DTD = "dtd_11/";
    private final XMLOutputFactory xmlFactory = XMLOutputFactory.newFactory();
    private Map<File, PAULAPrinter> paulaPrinters = new HashMap<File, PAULAPrinter>();
    public static final String ID_PREFIX = "id";

    public URI getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(URI resources) {
        this.resourcePath = resources;
    }

    @Override
    public boolean accept(File f, String s) {
        return s.toLowerCase().endsWith(".dtd");
    }

    public DOCUMENT_STATUS mapSCorpus() {
        SCorpus corpus = this.getCorpus();
        if (corpus != null && corpus.getMetaAnnotations() != null && !corpus.getMetaAnnotations().isEmpty()) {
            if (this.getResourcePath() != null) {
                File dtdDirectory = new File(this.getResourcePath().toFileString() + "/" + PATH_DTD);
                if (dtdDirectory.exists() && dtdDirectory.listFiles(this) != null) {
                    for (File DTDFile : dtdDirectory.listFiles(this)) {
                        this.copyFile(URI.createFileURI((String)DTDFile.getAbsolutePath()), this.getResourceURI().toFileString());
                    }
                } else {
                    logger.warn("Cannot copy dtds fom resource directory, because resource directory '" + dtdDirectory.getAbsolutePath() + "' does not exist.");
                }
            } else {
                logger.warn("There is no reference to a resource path!");
            }
            this.mapSMetaAnnotations((SAnnotationContainer)this.getCorpus());
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot export document structure because sDocument is null");
        }
        if (this.getDocument().getDocumentGraph() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot export document structure because sDocumentGraph is null");
        }
        if (this.getResourceURI() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot export document structure because documentPath is null for '" + this.getDocument().getIdentifier() + "'.");
        }
        if (this.getResourcePath() != null) {
            File dtdDirectory = new File(this.getResourcePath().toFileString() + "/" + PATH_DTD);
            if (dtdDirectory.exists() && dtdDirectory.listFiles(this) != null) {
                for (File DTDFile : dtdDirectory.listFiles(this)) {
                    this.copyFile(URI.createFileURI((String)DTDFile.getAbsolutePath()), this.getResourceURI().toFileString());
                }
            } else {
                logger.warn("Cannot copy dtds fom resource directory, because resource directory '" + dtdDirectory.getAbsolutePath() + "' does not exist.");
            }
        } else {
            logger.warn("There is no reference to a resource path!");
        }
        try {
            this.mapTextualDataSources();
            this.mapTokens();
            this.mapSMedialDS();
            this.mapSpans();
            this.mapStructures();
            this.mapPointingRelations();
            this.mapSMetaAnnotations((SAnnotationContainer)this.getDocument());
        }
        catch (Exception ex) {
            throw new PepperModuleException((PepperMapper)this, "Could write document " + this.getDocument().getId() + " to path " + this.getResourcePath(), (Throwable)ex);
        }
        finally {
            for (PAULAPrinter printer : this.paulaPrinters.values()) {
                printer.close();
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    private PAULAPrinter getPAULAPrinter(File paulaFile) {
        PAULAPrinter retVal = this.paulaPrinters.get(paulaFile);
        if (retVal == null) {
            retVal = new PAULAPrinter(paulaFile);
            this.paulaPrinters.put(paulaFile, retVal);
        }
        return retVal;
    }

    private void mapSMetaAnnotations(SAnnotationContainer container) {
        if (container != null && container.getMetaAnnotations() != null && container.getMetaAnnotations().size() > 0) {
            String pathName = this.getResourceURI().toFileString();
            if (!pathName.endsWith("/")) {
                pathName = pathName + "/";
            }
            File annoFile = new File(pathName + "anno.xml");
            annoFile.getParentFile().mkdirs();
            try (PAULAPrinter printer = this.getPAULAPrinter(annoFile);){
                printer.xml.writeDTD("<!DOCTYPE paula SYSTEM \"paula_text.dtd\">");
                printer.xml.writeStartElement("paula");
                printer.xml.writeAttribute("version", "1.1");
                printer.xml.writeStartElement("header");
                printer.xml.writeAttribute("paula_id", "anno.xml");
                printer.xml.writeAttribute("type", PAULA_TYPE.STRUCT.toString());
                printer.xml.writeEndElement();
                printer.xml.writeStartElement("structList");
                printer.xml.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
                printer.xml.writeAttribute("type", "annoSet");
                printer.xml.writeStartElement("struct");
                printer.xml.writeAttribute(ID_PREFIX, "anno_1");
                printer.xml.writeEndElement();
                printer.xml.writeEndElement();
                printer.xml.writeEndElement();
                printer.xml.writeEndDocument();
            }
            catch (XMLStreamException e) {
                throw new PepperModuleException((PepperMapper)this, "Cannot write in file '" + annoFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
            }
            for (SMetaAnnotation meta : container.getMetaAnnotations()) {
                String type = meta.getQName().replace("::", ".");
                String paulaID = "anno_" + type;
                String annoFileName = paulaID + "." + "xml";
                File metaAnnoFile = new File(pathName + annoFileName);
                metaAnnoFile.getParentFile().mkdirs();
                try {
                    PAULAPrinter printer = this.getPAULAPrinter(metaAnnoFile);
                    Throwable throwable = null;
                    try {
                        String annoString;
                        if (!printer.hasPreamble) {
                            printer.printPreambel(PAULA_TYPE.FEAT, type, annoFile);
                        }
                        if ((annoString = meta.getValue_STEXT()) == null) continue;
                        printer.xml.writeEmptyElement("feat");
                        printer.xml.writeAttribute("xlink:href", "#anno_1");
                        printer.xml.writeAttribute("value", annoString);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (printer == null) continue;
                        if (throwable != null) {
                            try {
                                printer.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        printer.close();
                    }
                }
                catch (XMLStreamException e) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot write in file '" + metaAnnoFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
                }
            }
        }
    }

    public void mapTextualDataSources() {
        for (STextualDS sTextualDS : this.getDocument().getDocumentGraph().getTextualDSs()) {
            File paulaFile = this.generateFileName((SNode)sTextualDS);
            try (PAULAPrinter printer = this.getPAULAPrinter(paulaFile);){
                printer.xml.writeDTD("<!DOCTYPE paula SYSTEM \"paula_text.dtd\">");
                printer.xml.writeStartElement("paula");
                printer.xml.writeAttribute("version", "1.1");
                printer.xml.writeStartElement("header");
                printer.xml.writeAttribute("paula_id", paulaFile.getName().replace(".xml", ""));
                printer.xml.writeAttribute("type", PAULA_TYPE.TEXT.toString());
                printer.xml.writeEndElement();
                boolean originalPrettyPrintVal = printer.xml.getPrettyPrint();
                printer.xml.setPrettyPrint(Boolean.valueOf(false));
                printer.xml.writeStartElement("body");
                printer.xml.writeCharacters(sTextualDS.getText());
                printer.xml.writeEndElement();
                printer.xml.setPrettyPrint(Boolean.valueOf(originalPrettyPrintVal));
                printer.xml.writeEndElement();
            }
        }
    }

    public void mapTokens() {
        PAULAPrinter printer = null;
        for (STextualRelation sTextRel : this.getDocument().getDocumentGraph().getTextualRelations()) {
            SToken sToken = (SToken)sTextRel.getSource();
            if (sToken != null) {
                File paulaFile = this.generateFileName((SNode)sToken);
                printer = this.getPAULAPrinter(paulaFile);
                if (!printer.hasPreamble) {
                    printer.printPreambel(PAULA_TYPE.TOK, "tok", this.generateFileName((SNode)sTextRel.getTarget()));
                }
                try {
                    if (((PAULAExporterProperties)this.getProperties()).isHumanReadable().booleanValue()) {
                        printer.xml.writeComment(this.escapeComment(this.getDocument().getDocumentGraph().getText((SNode)sToken)));
                    }
                    printer.xml.writeEmptyElement("mark");
                    printer.xml.writeAttribute(ID_PREFIX, this.checkId(sToken.getPath().fragment()));
                    Integer start = (Integer)sTextRel.getStart() + 1;
                    Integer end = (Integer)sTextRel.getEnd() - (Integer)sTextRel.getStart();
                    String xPointer = "#xpointer(string-range(//body,''," + start + "," + end + "))";
                    printer.xml.writeAttribute("xlink:href", xPointer);
                }
                catch (ClassCastException | XMLStreamException e) {
                    e.printStackTrace();
                    throw new PepperModuleException((PepperMapper)this, "Cannot write in file '" + paulaFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
                }
            }
            this.mapAnnotations((SAnnotationContainer)sToken);
        }
        if (printer != null) {
            printer.close();
        }
    }

    public void mapSMedialDS() {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        if (this.getDocument().getDocumentGraph().getMedialRelations() != null && this.getDocument().getDocumentGraph().getMedialRelations().size() > 0) {
            for (SMedialRelation rel : this.getDocument().getDocumentGraph().getMedialRelations()) {
                map.put((Object)rel.getTarget(), (Object)rel.getSource());
            }
        } else if (this.getDocument().getDocumentGraph().getMedialDSs() != null && this.getDocument().getDocumentGraph().getMedialDSs().size() > 0) {
            for (SMedialDS audioDS : this.getDocument().getDocumentGraph().getMedialDSs()) {
                map.putAll((Object)audioDS, (Iterable)this.getDocument().getDocumentGraph().getTokens());
            }
        }
        if (map.size() > 0) {
            StringBuffer fileName = new StringBuffer();
            fileName.append(this.getResourceURI().toFileString());
            if (!fileName.toString().endsWith("/")) {
                fileName.append("/");
            }
            fileName.append(this.getDocument().getName());
            fileName.append(".");
            fileName.append(PAULA_TYPE.MARK.getFileInfix());
            fileName.append(".");
            fileName.append("audio");
            fileName.append(".");
            fileName.append("xml");
            File audioMarkFile = new File(fileName.toString());
            PAULAPrinter printer = this.getPAULAPrinter(audioMarkFile);
            if (!printer.hasPreamble) {
                printer.printPreambel(PAULA_TYPE.MARK, "audio", this.generateFileName((SNode)this.getDocument().getDocumentGraph().getTokens().get(0)));
            }
            for (SMedialDS audio : map.keySet()) {
                try {
                    printer.xml.writeEmptyElement("mark");
                    if (audio.getPath().fragment() != null) {
                        printer.xml.writeAttribute(ID_PREFIX, this.checkId(audio.getPath().fragment()));
                    } else {
                        printer.xml.writeAttribute(ID_PREFIX, audio.getId());
                    }
                    printer.xml.writeAttribute("xlink:href", this.generateXPointer(new ArrayList(map.get((Object)audio)), printer.base));
                }
                catch (XMLStreamException e) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot write in file '" + audioMarkFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
                }
            }
            File audioFeatFile = new File(audioMarkFile.getAbsolutePath().replace(".xml", "_feat.xml"));
            printer = this.getPAULAPrinter(audioFeatFile);
            printer.printPreambel(PAULA_TYPE.FEAT, "audio", audioMarkFile);
            for (SMedialDS audio : this.getDocument().getDocumentGraph().getMedialDSs()) {
                String target = audioMarkFile.getAbsoluteFile().getParent();
                if (!target.endsWith("/")) {
                    target = target + "/";
                }
                target = target + audio.getMediaReference().lastSegment();
                File audioFile = new File(target);
                try {
                    String source = audio.getMediaReference().toFileString();
                    if (source == null) {
                        source = audio.getMediaReference().toString();
                    }
                    Files.copy(new File(source).toPath(), audioFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot copy audio file '" + audio.getMediaReference() + "', to +'" + target + "'. ", (Throwable)e);
                }
                try {
                    printer.xml.writeEmptyElement("feat");
                    printer.xml.writeAttribute("xlink:href", "#" + audio.getPath().fragment());
                    printer.xml.writeAttribute("value", audioFile.getName());
                }
                catch (XMLStreamException e) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot write in file '" + audioFeatFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
                }
            }
        }
    }

    public void mapSpans() {
        PAULAPrinter printer = null;
        for (SSpan sSpan : this.getDocument().getDocumentGraph().getSpans()) {
            List tokens = this.getDocument().getDocumentGraph().getSortedTokenByText(this.getDocument().getDocumentGraph().getOverlappedTokens((SNode)sSpan));
            if (!tokens.isEmpty()) {
                File paulaFile = this.generateFileName((SNode)sSpan);
                printer = this.getPAULAPrinter(paulaFile);
                if (!printer.hasPreamble) {
                    printer.printPreambel(PAULA_TYPE.MARK, this.generatePaulaType((IdentifiableElement)sSpan), this.generateFileName((SNode)tokens.get(0)));
                }
                try {
                    if (((PAULAExporterProperties)this.getProperties()).isHumanReadable().booleanValue()) {
                        printer.xml.writeComment(this.escapeComment(this.getDocument().getDocumentGraph().getText((SNode)sSpan)));
                    }
                    printer.xml.writeEmptyElement("mark");
                    if (sSpan.getPath().fragment() != null) {
                        printer.xml.writeAttribute(ID_PREFIX, this.checkId(sSpan.getPath().fragment()));
                    } else {
                        printer.xml.writeAttribute(ID_PREFIX, sSpan.getId());
                    }
                    printer.xml.writeAttribute("xlink:href", this.generateXPointer(tokens, printer.base));
                }
                catch (XMLStreamException e) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot write in file '" + paulaFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
                }
            }
            this.mapAnnotations((SAnnotationContainer)sSpan);
        }
        if (printer != null) {
            printer.close();
        }
    }

    private void mapStructures() {
        for (SStructure struct : this.getDocument().getDocumentGraph().getStructures()) {
            File paulaFile = this.generateFileName((SNode)struct);
            PAULAPrinter printer = this.getPAULAPrinter(paulaFile);
            if (!printer.hasPreamble) {
                printer.printPreambel(PAULA_TYPE.STRUCT, this.generatePaulaType((IdentifiableElement)struct), null);
            }
            try {
                if (((PAULAExporterProperties)this.getProperties()).isHumanReadable().booleanValue()) {
                    printer.xml.writeComment(this.escapeComment(this.getDocument().getDocumentGraph().getText((SNode)struct)));
                }
                printer.xml.writeStartElement("struct");
                printer.xml.writeAttribute(ID_PREFIX, this.checkId(struct.getPath().fragment()));
                for (Relation relation : this.getDocument().getDocumentGraph().getOutRelations(struct.getId())) {
                    if (!(relation instanceof SDominanceRelation)) continue;
                    SDominanceRelation domRel = (SDominanceRelation)relation;
                    printer.xml.writeEmptyElement("rel");
                    String idVal = this.checkId(domRel.getPath().fragment());
                    if (idVal != null) {
                        printer.xml.writeAttribute(ID_PREFIX, idVal);
                    }
                    if (domRel.getType() != null && !domRel.getType().isEmpty()) {
                        printer.xml.writeAttribute("type", domRel.getType());
                    }
                    printer.xml.writeAttribute("xlink:href", this.generateXPointer((IdentifiableElement)domRel.getTarget(), printer.base));
                    this.mapAnnotations((SAnnotationContainer)domRel);
                }
                printer.xml.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new PepperModuleException((PepperMapper)this, "Cannot write in file '" + paulaFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
            }
            this.mapAnnotations((SAnnotationContainer)struct);
        }
    }

    private void mapPointingRelations() {
        for (SPointingRelation pointRel : this.getDocument().getDocumentGraph().getPointingRelations()) {
            String type = "";
            type = pointRel.getType() == null || pointRel.getType().isEmpty() ? "notype" : pointRel.getType();
            File paulaFile = this.generateFileName((SRelation<? extends SNode, ? extends SNode>)pointRel);
            PAULAPrinter printer = this.getPAULAPrinter(paulaFile);
            if (!printer.hasPreamble) {
                printer.printPreambel(PAULA_TYPE.REL, type, null);
            }
            if (pointRel.getSource() == null || pointRel.getTarget() == null) continue;
            try {
                printer.xml.writeEmptyElement("rel");
                String idVal = this.checkId(pointRel.getPath().fragment());
                if (idVal != null) {
                    printer.xml.writeAttribute(ID_PREFIX, idVal);
                }
                printer.xml.writeAttribute("xlink:href", this.generateXPointer((IdentifiableElement)pointRel.getSource(), printer.base));
                printer.xml.writeAttribute("target", this.generateXPointer((IdentifiableElement)pointRel.getTarget(), printer.base));
            }
            catch (XMLStreamException e) {
                throw new PepperModuleException((PepperMapper)this, "Cannot write in file '" + paulaFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
            }
            this.mapAnnotations((SAnnotationContainer)pointRel);
        }
    }

    private void mapAnnotations(SAnnotationContainer annoSource) {
        if (annoSource != null) {
            for (SAnnotation anno : annoSource.getAnnotations()) {
                String annoString = null;
                annoString = anno.getValue_SURI() != null ? this.copyFile(anno.getValue_SURI(), this.getResourceURI().toFileString()) : anno.getValue_STEXT();
                File paulaFile = this.generateFileName((Label)anno);
                PAULAPrinter printer = this.getPAULAPrinter(paulaFile);
                if (!printer.hasPreamble) {
                    String type = anno.getQName().replace("::", ".");
                    if (annoSource instanceof SNode) {
                        printer.printPreambel(PAULA_TYPE.FEAT, type, this.generateFileName((SNode)annoSource));
                    } else if (annoSource instanceof SRelation) {
                        printer.printPreambel(PAULA_TYPE.FEAT, type, this.generateFileName((SRelation<? extends SNode, ? extends SNode>)((SRelation)annoSource)));
                    }
                }
                try {
                    if (annoString == null) continue;
                    printer.xml.writeEmptyElement("feat");
                    printer.xml.writeAttribute("xlink:href", this.generateXPointer((IdentifiableElement)annoSource, printer.base));
                    printer.xml.writeAttribute("value", annoString);
                }
                catch (XMLStreamException e) {
                    throw new PepperModuleException((PepperMapper)this, "Cannot write in file '" + paulaFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
                }
            }
        }
    }

    public String checkId(String id) {
        if (id != null && Character.isDigit(id.charAt(0))) {
            return ID_PREFIX + id;
        }
        return id;
    }

    public String generateXPointer(IdentifiableElement target, File base) {
        StringBuilder retVal = new StringBuilder();
        if (target != null) {
            File baseFile = null;
            if (target instanceof SNode) {
                baseFile = this.generateFileName((SNode)target);
            } else if (target instanceof SRelation) {
                baseFile = this.generateFileName((SRelation<? extends SNode, ? extends SNode>)((SRelation)target));
            }
            if (!baseFile.equals(base)) {
                retVal.append(baseFile.getName());
            }
            retVal.append("#");
            String fragment = ((SPathElement)target).getPath().fragment();
            if (fragment == null) {
                fragment = target.getId();
            }
            retVal.append(this.checkId(fragment));
        }
        return retVal.toString();
    }

    public String generateXPointer(List<? extends IdentifiableElement> targets, File base) {
        StringBuilder retVal = new StringBuilder();
        if (targets != null && targets.size() > 0) {
            if (targets.size() == 1) {
                retVal.append(this.generateXPointer(targets.get(0), base));
            } else {
                int i = 0;
                for (IdentifiableElement identifiableElement : targets) {
                    if (i != 0) {
                        retVal.append(" ");
                    }
                    retVal.append(this.generateXPointer(identifiableElement, base));
                    ++i;
                }
            }
        }
        return retVal.toString();
    }

    public String generatePaulaType(IdentifiableElement id) {
        String layers = this.getProps().getEmptyNamespace();
        if (id != null) {
            Set sLayers = null;
            if (id instanceof SNode) {
                sLayers = ((SNode)id).getLayers();
            } else if (id instanceof SRelation) {
                sLayers = ((SRelation)id).getLayers();
            }
            if (sLayers.size() > 0) {
                if (sLayers.size() == 1) {
                    layers = ((SLayer)sLayers.iterator().next()).getName();
                } else {
                    ArrayList<String> layerList = new ArrayList<String>();
                    for (SLayer sLayer : sLayers) {
                        layerList.add(sLayer.getName());
                    }
                    Collections.sort(layerList, String.CASE_INSENSITIVE_ORDER);
                    boolean i = false;
                    for (String layerName : layerList) {
                        if (!i) {
                            layers = layerName;
                            continue;
                        }
                        layers = layers + "." + layerName;
                    }
                }
            }
        }
        return layers;
    }

    private STextualDS getSTextForSToken(SToken tok) {
        STextualDS textualDS = null;
        for (SRelation rel : tok.getOutRelations()) {
            if (!(rel instanceof STextualRelation)) continue;
            textualDS = (STextualDS)((STextualRelation)rel).getTarget();
            break;
        }
        return textualDS;
    }

    public File generateFileName(SNode sNode) {
        File retFile = null;
        if (sNode != null) {
            StringBuilder fileName = new StringBuilder();
            if (sNode instanceof STextualDS) {
                fileName.append(this.getDocument().getName());
                if (this.getDocument().getDocumentGraph().getTextualDSs().size() > 1) {
                    fileName.append(".");
                    fileName.append(sNode.getPath().fragment());
                }
                fileName.append(".");
                fileName.append(PAULA_TYPE.TEXT.getFileInfix());
            } else if (sNode instanceof SToken) {
                fileName.append(this.getDocument().getName());
                STextualDS sText = this.getSTextForSToken((SToken)sNode);
                if (sText != null && this.getDocument().getDocumentGraph().getTextualDSs().size() > 1) {
                    fileName.append(".");
                    fileName.append(sText.getPath().fragment());
                }
                fileName.append(".");
                fileName.append(PAULA_TYPE.TOK.getFileInfix());
            } else {
                String layers = this.generatePaulaType((IdentifiableElement)sNode);
                fileName.append(layers);
                if (!layers.isEmpty()) {
                    fileName.append(".");
                }
                fileName.append(this.getDocument().getName());
                fileName.append(".");
                if (sNode instanceof SSpan) {
                    fileName.append(PAULA_TYPE.MARK.getFileInfix());
                } else if (sNode instanceof SStructure) {
                    fileName.append(PAULA_TYPE.STRUCT.getFileInfix());
                }
            }
            fileName.append(".");
            fileName.append("xml");
            String pathName = this.getResourceURI().toFileString();
            if (!pathName.endsWith("/")) {
                pathName = pathName + "/";
            }
            retFile = new File(pathName + fileName.toString());
            retFile.getParentFile().mkdirs();
        }
        return retFile;
    }

    public File generateFileName(SRelation<? extends SNode, ? extends SNode> sRelation) {
        if (sRelation instanceof SDominanceRelation) {
            return this.generateFileName((SNode)sRelation.getSource());
        }
        if (sRelation instanceof SPointingRelation) {
            StringBuilder fileName = new StringBuilder();
            String layers = this.generatePaulaType((IdentifiableElement)sRelation);
            fileName.append(layers);
            if (!layers.isEmpty()) {
                fileName.append(".");
            }
            fileName.append(this.getDocument().getName());
            fileName.append(".");
            String type = "";
            type = sRelation.getType() == null || sRelation.getType().isEmpty() ? "notype" : sRelation.getType();
            fileName.append(type);
            fileName.append(".");
            fileName.append("xml");
            String pathName = this.getResourceURI().toFileString();
            if (!pathName.endsWith("/")) {
                pathName = pathName + "/";
            }
            File retFile = new File(pathName + fileName.toString());
            retFile.getParentFile().mkdirs();
            return retFile;
        }
        return null;
    }

    public File generateFileName(Label anno) {
        File baseFileName = null;
        if (anno.getContainer() instanceof SNode) {
            baseFileName = this.generateFileName((SNode)anno.getContainer());
        } else if (anno.getContainer() instanceof SRelation) {
            baseFileName = this.generateFileName((SRelation<? extends SNode, ? extends SNode>)((SRelation)anno.getContainer()));
        }
        StringBuilder fileName = new StringBuilder();
        fileName.append(baseFileName.getName().replace(".xml", ""));
        fileName.append("_");
        fileName.append(anno.getName());
        fileName.append(".xml");
        return new File(baseFileName.getParent() + "/" + fileName.toString());
    }

    private String copyFile(URI file, String outputPath) {
        File inFile = new File(file.toFileString());
        File outFile = new File(outputPath + "/" + inFile.getName());
        FileInputStream in = null;
        FileOutputStream out = null;
        String outFileString = null;
        try {
            int c;
            in = new FileInputStream(file.toFileString());
            out = new FileOutputStream(outFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            outFileString = "file:/" + outFile.getName();
        }
        catch (IOException e) {
            throw new PepperModuleException((PepperMapper)this, "Cannot copy file '" + file + "' to path '" + outFileString + "'", (Throwable)e);
        }
        return outFileString;
    }

    private String escapeComment(String txt) {
        if (txt == null) {
            return null;
        }
        String result = txt.replace("--", "<hyphen><hyphen>");
        if (result.endsWith("-")) {
            result = result + " ";
        }
        return result;
    }

    public PAULAExporterProperties getProps() {
        return (PAULAExporterProperties)this.getProperties();
    }

    class PAULAPrinter
    implements AutoCloseable {
        XMLStreamWriter xml = null;
        private PrintWriter output = null;
        private File paulaFile = null;
        private File base = null;
        boolean hasPreamble = false;

        public PAULAPrinter(File paulaFile) {
            this.paulaFile = paulaFile;
            try {
                this.output = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(paulaFile), "UTF8")), false);
                this.xml = new XMLStreamWriter(Salt2PAULAMapper.this.xmlFactory.createXMLStreamWriter(this.output));
                this.xml.setPrettyPrint(Salt2PAULAMapper.this.getProps().isHumanReadable());
                this.xml.writeStartDocument();
            }
            catch (IOException e) {
                throw new PepperModuleException((PepperMapper)Salt2PAULAMapper.this, "Cannot open file '" + paulaFile.getAbsolutePath() + "' to write to, because of a nested exception. ", (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new PepperModuleException((PepperMapper)Salt2PAULAMapper.this, "Cannot write in file '" + paulaFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
            }
        }

        @Override
        public void close() {
            try {
                if (this.hasPreamble) {
                    this.xml.writeEndDocument();
                    this.xml.flush();
                }
                this.xml.close();
            }
            catch (XMLStreamException e) {
                throw new PepperModuleException((PepperMapper)Salt2PAULAMapper.this, "Cannot write in file '" + this.paulaFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
            }
            this.output.flush();
            this.output.close();
        }

        public boolean hasPreamble() {
            return this.hasPreamble;
        }

        public void printPreambel(PAULA_TYPE paulaType, String type, File base) {
            if (!this.hasPreamble) {
                if (paulaType == null) {
                    throw new PepperModuleException((PepperMapper)Salt2PAULAMapper.this, "Cannot create '" + (Object)((Object)paulaType) + "' file beginning: This seems to be an internal problem.");
                }
                if (type.isEmpty()) {
                    type = paulaType.getFileInfix();
                }
                this.base = base;
                try {
                    this.xml.writeDTD(paulaType.getDocTypeTag());
                    this.xml.writeStartElement("paula");
                    this.xml.writeAttribute("version", "1.1");
                    this.xml.writeEmptyElement("header");
                    this.xml.writeAttribute("paula_id", this.paulaFile.getName().replace(".xml", ""));
                    this.xml.writeStartElement(paulaType.getListElementName());
                    this.xml.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
                    this.xml.writeAttribute("type", type);
                    if (base != null) {
                        this.xml.writeAttribute("xml:base", base.getName());
                    }
                }
                catch (XMLStreamException e) {
                    throw new PepperModuleException((PepperMapper)Salt2PAULAMapper.this, "Cannot write in file '" + this.paulaFile.getAbsolutePath() + "', because of a nested exception. ", (Throwable)e);
                }
                this.hasPreamble = true;
            }
        }
    }
}

