/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula.readers;

import org.corpus_tools.peppermodules.paula.readers.PAULASpecificReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PAULAFeatReader
extends PAULASpecificReader {
    private static final String KW_ANNO = "anno";
    private static final String KW_ANNO_2 = "meta";
    private static final String KW_ANNO_FEAT = "annoFeat";
    private Boolean isMetaFeat = false;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.isTAGorAttribute(qName, "featList")) {
            if (this.getXmlBase() != null && !this.getXmlBase().isEmpty()) {
                String[] parts = this.getXmlBase().split("[.]");
                if (parts.length >= 2 && parts[parts.length - 2].equalsIgnoreCase(KW_ANNO)) {
                    this.isMetaFeat = true;
                } else if (KW_ANNO_2.equalsIgnoreCase(this.getXmlBase())) {
                    this.isMetaFeat = true;
                }
            }
        } else if (this.isTAGorAttribute(qName, "feat")) {
            String featID = null;
            String featHref = null;
            String featTar = null;
            String featVal = null;
            String featDesc = null;
            String featExp = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (this.isTAGorAttribute(attributes.getQName(i), "id")) {
                    featID = attributes.getValue(i);
                    continue;
                }
                if (this.isTAGorAttribute(attributes.getQName(i), "xlink:href")) {
                    featHref = attributes.getValue(i);
                    continue;
                }
                if (this.isTAGorAttribute(attributes.getQName(i), "target")) {
                    featTar = attributes.getValue(i);
                    continue;
                }
                if (this.isTAGorAttribute(attributes.getQName(i), "value")) {
                    featVal = attributes.getValue(i);
                    continue;
                }
                if (this.isTAGorAttribute(attributes.getQName(i), "description")) {
                    featDesc = attributes.getValue(i);
                    continue;
                }
                if (!this.isTAGorAttribute(attributes.getQName(i), "example")) continue;
                featExp = attributes.getValue(i);
            }
            this.checkForFileReference(featHref);
            this.checkForFileReference(featTar);
            if (!KW_ANNO_FEAT.equals(this.getPaulaType())) {
                if (this.isMetaFeat.booleanValue()) {
                    this.getMapper().paulaFEAT_METAConnector(this.getPaulaFile(), this.getPaulaID(), this.getPaulaType(), this.getXmlBase(), featID, featHref, featTar, featVal, featDesc, featExp);
                } else if ((featVal == null || featVal.isEmpty()) && featTar != null && !featTar.isEmpty()) {
                    this.getMapper().paulaRELConnector(this.getPaulaFile(), this.getPaulaID(), this.getPaulaType(), this.getXmlBase(), featID, featHref, featTar);
                } else {
                    this.getMapper().paulaFEATConnector(this.getPaulaFile(), this.getPaulaID(), this.getPaulaType(), this.getXmlBase(), featID, featHref, featTar, featVal, featDesc, featExp);
                }
            }
        }
    }
}

