/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula.readers;

import org.corpus_tools.peppermodules.paula.readers.PAULASpecificReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PAULAStructReader
extends PAULASpecificReader {
    private long numStruct = 0L;
    private long numRel = 0L;
    private String structID = null;
    private static final String KW_ANNO_TYPE = "annoSet";
    private Boolean isAnnoSet = false;

    public PAULAStructReader() {
        this.init();
    }

    private void init() {
        this.numStruct = 0L;
        this.numRel = 0L;
        this.isAnnoSet = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (this.isTAGorAttribute(qName, "structList")) {
            if (this.getPaulaType() != null && this.getPaulaType().equalsIgnoreCase(KW_ANNO_TYPE)) {
                this.isAnnoSet = true;
            }
        } else if (this.isTAGorAttribute(qName, "struct")) {
            if (!this.isAnnoSet.booleanValue()) {
                ++this.numStruct;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!this.isTAGorAttribute(attributes.getQName(i), "id")) continue;
                    this.structID = attributes.getValue(i);
                }
            }
        } else if (this.isTAGorAttribute(qName, "rel") && !this.isAnnoSet.booleanValue()) {
            ++this.numRel;
            String relID = "";
            String relType = "";
            String relHref = "";
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (this.isTAGorAttribute(attributes.getQName(i), "id")) {
                    relID = attributes.getValue(i);
                    continue;
                }
                if (this.isTAGorAttribute(attributes.getQName(i), "type")) {
                    relType = attributes.getValue(i);
                    continue;
                }
                if (!this.isTAGorAttribute(attributes.getQName(i), "xlink:href")) continue;
                relHref = attributes.getValue(i);
            }
            this.checkForFileReference(relHref);
            this.getMapper().paulaSTRUCTConnector(this.getPaulaFile(), this.getPaulaID(), this.getPaulaType(), this.getXmlBase(), this.structID, relID, relHref, relType);
        }
    }

    @Override
    public void endDocument() {
        this.getMapper().endDocument(this, this.getPaulaFile());
    }
}

