/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.paula.PAULA2SaltMapper;
import org.corpus_tools.peppermodules.paula.PAULAImporterProperties;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="PAULAImporterComponent", factory="PepperImporterComponentFactory")
public class PAULAImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String FORMAT_NAME = "paula";
    public static final String FORMAT_VERSION = "1.0";
    private String[] PAULA_FILE_ENDINGS = new String[]{"xml", "paula"};

    public PAULAImporter() {
        this.setName("PAULAImporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-PAULAModules"));
        this.setDesc("The PAULA importer imports data comming from the PAULA format to a Salt model. ");
        this.addSupportedFormat(FORMAT_NAME, FORMAT_VERSION, null);
        this.setProperties(new PAULAImporterProperties());
        this.getDocumentEndings().add("LEAF_FOLDER");
    }

    public SelfTestDesc getSelfTestDesc() {
        return new SelfTestDesc(this.getResources().appendSegment("selfTests").appendSegment("paulaImporter").appendSegment("in").appendSegment("rootCorpus"), this.getResources().appendSegment("selfTests").appendSegment("paulaImporter").appendSegment("expected"));
    }

    public Double isImportable(URI corpusPath) {
        Double retValue = 0.0;
        for (String content : this.sampleFileContent(corpusPath, this.PAULA_FILE_ENDINGS)) {
            Pattern pattern = Pattern.compile("<?xml version=(\"|')1[.]0(\"|')");
            Matcher matcher = pattern.matcher(content);
            Pattern pattern2 = Pattern.compile("<paula version=");
            Matcher matcher2 = pattern2.matcher(content);
            if (!matcher.find() || !matcher2.find()) continue;
            retValue = 1.0;
            break;
        }
        return retValue;
    }

    public PepperMapper createPepperMapper(Identifier Identifier2) {
        PAULA2SaltMapper mapper = new PAULA2SaltMapper();
        mapper.setPAULA_FILE_ENDINGS(this.PAULA_FILE_ENDINGS);
        if (Identifier2.getIdentifiableElement() instanceof SCorpus) {
            Collection pathes = this.getIdentifier2ResourceTable().values();
            int i = 0;
            for (URI path : pathes) {
                if (!path.equals(this.getIdentifier2ResourceTable().get(Identifier2))) continue;
                ++i;
            }
            if (i > 1) {
                mapper.setIsArtificialSCorpus(true);
            }
        }
        return mapper;
    }
}

