/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.paula.util.xPointer;

public class XPtrRef {
    private static final String TOOLNAME = "XPtrRef";
    private POINTERTYPE type = POINTERTYPE.NOTSET;
    private boolean isRange = true;
    private String docName = null;
    private String id = null;
    private String left = null;
    private String right = null;
    private static final String MSG_STD = "XPtrRef>\t";
    private static final String MSG_ERR = "ERROR(XPtrRef):\t";
    private static final String ERR_EMPTY_DOCNAME = "ERROR(XPtrRef):\tThe given document name is empty.";
    private static final String ERR_EMPTY_ID = "ERROR(XPtrRef):\tThe given id value for target of the reference is empty.";
    private static final String ERR_EMPTY_LEFT = "ERROR(XPtrRef):\tThe given value for left border id of the reference is empty.";
    private static final String ERR_EMPTY_RIGHT = "ERROR(XPtrRef):\tThe given value for right border id of the reference is empty.";
    private static final String ERR_NO_RANGE = "ERROR(XPtrRef):\tThe target of this XPointer reference is a simple element, not a range.";
    private static final String ERR_IS_RANGE = "ERROR(XPtrRef):\tThe target of this XPointer reference is a range, not a simple element.";
    private static final String ERR_INCORRECT_TYPE = "ERROR(XPtrRef):\tPointer type could not be 'NOTSET'.";

    public XPtrRef(String docName, String id) throws Exception {
        if (docName == null || docName.equalsIgnoreCase("")) {
            throw new Exception(ERR_EMPTY_DOCNAME);
        }
        if (id == null || id.equalsIgnoreCase("")) {
            throw new Exception(ERR_EMPTY_ID);
        }
        this.id = id;
        this.docName = docName;
        this.isRange = false;
    }

    public XPtrRef(String docName, String left, String right) throws Exception {
        if (docName == null || docName.equalsIgnoreCase("")) {
            throw new Exception(ERR_EMPTY_DOCNAME);
        }
        if (left == null || left.equalsIgnoreCase("")) {
            throw new Exception(ERR_EMPTY_LEFT);
        }
        if (right == null || right.equalsIgnoreCase("")) {
            throw new Exception(ERR_EMPTY_RIGHT);
        }
        this.left = left;
        this.right = right;
        this.docName = docName;
        this.isRange = true;
    }

    public void setType(POINTERTYPE type) throws Exception {
        if (type == POINTERTYPE.NOTSET) {
            throw new Exception(ERR_INCORRECT_TYPE);
        }
        this.type = type;
    }

    public POINTERTYPE getType() {
        return this.type;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public String getDoc() {
        return this.docName;
    }

    public String getID() throws Exception {
        if (this.isRange) {
            throw new Exception(ERR_IS_RANGE);
        }
        return this.id;
    }

    public String getLeft() throws Exception {
        if (!this.isRange) {
            throw new Exception(ERR_NO_RANGE);
        }
        return this.left;
    }

    public String getRight() throws Exception {
        if (!this.isRange) {
            throw new Exception(ERR_NO_RANGE);
        }
        return this.right;
    }

    public String toString() {
        String retStr = "";
        retStr = "XPtrRef>\tdocument name: " + this.docName + ", type: ";
        retStr = this.isRange ? retStr + "range" + ", (left: " + this.left + ", right: " + this.right + ")" : retStr + "simple node" + ", id " + this.id;
        return retStr;
    }

    public static enum POINTERTYPE {
        ELEMENT,
        TEXT,
        XMLFILE,
        NOTSET;

    }
}

