/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.rst.resources;

import de.hu_berlin.german.korpling.rst.RSTDocument;
import de.hu_berlin.german.korpling.rst.RSTFactory;
import de.hu_berlin.german.korpling.rst.exceptions.RSTException;
import de.hu_berlin.german.korpling.rst.resources.RSTReader;
import de.hu_berlin.german.korpling.rst.resources.RSTWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RSTResource
extends ResourceImpl {
    public void save(Map<?, ?> options) throws IOException {
        if (this.getContents().size() > 1) {
            throw new RSTException("Cannot write more than one RSTDocument-object per file.");
        }
        if (!(this.getContents().get(0) instanceof RSTDocument)) {
            throw new RSTException("The object to store is not of type RSTDocument.");
        }
        RSTDocument rstDocument = (RSTDocument)this.getContents().get(0);
        RSTWriter writer = new RSTWriter();
        writer.write(rstDocument, this.getURI());
    }

    public void load(Map<?, ?> options) throws IOException {
        XMLReader xmlReader;
        SAXParser parser;
        if (this.getURI() == null) {
            throw new RSTException("Cannot load any resource, because no uri is given.");
        }
        File rstFile = new File(this.getURI().toFileString());
        if (!rstFile.exists()) {
            throw new RSTException("Cannot load resource, because the file does not exist: " + rstFile);
        }
        if (!rstFile.canRead()) {
            throw new RSTException("Cannot load resource, because the file can not be read: " + rstFile);
        }
        RSTDocument rstDocument = null;
        rstDocument = RSTFactory.eINSTANCE.createRSTDocument();
        this.getContents().add((Object)rstDocument);
        RSTReader rstReader = new RSTReader();
        rstReader.setRstFile(rstFile);
        rstReader.setRSTDocument(rstDocument);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", rstReader);
            xmlReader.setContentHandler(rstReader);
        }
        catch (ParserConfigurationException e) {
            throw new RSTException("Cannot load exmaralda from resource '" + rstFile.getAbsolutePath() + "'.", e);
        }
        catch (Exception e) {
            throw new RSTException("Cannot load exmaralda from resource '" + rstFile.getAbsolutePath() + "'.", e);
        }
        try {
            FileInputStream inputStream = new FileInputStream(rstFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            xmlReader.parse(is);
        }
        catch (SAXException e) {
            try {
                parser = factory.newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReader.parse(rstFile.getAbsolutePath());
                xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", rstReader);
                xmlReader.setContentHandler(rstReader);
            }
            catch (Exception e1) {
                throw new RSTException("Cannot load exmaralda from resource '" + rstFile.getAbsolutePath() + "'.", e1);
            }
        }
    }
}

