/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.rst.resources;

import de.hu_berlin.german.korpling.rst.Group;
import de.hu_berlin.german.korpling.rst.RSTDocument;
import de.hu_berlin.german.korpling.rst.Relation;
import de.hu_berlin.german.korpling.rst.Segment;
import de.hu_berlin.german.korpling.rst.exceptions.RSTException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;

public class RSTWriter {
    public static final String encoding = "UTF-8";

    public void write(RSTDocument rstDocument, URI uri) {
        XMLOutputFactory xof = null;
        XMLStreamWriter xmlWriter = null;
        try {
            if (rstDocument != null) {
                Relation incomingRelation;
                EList<Relation> incomingRelations;
                xof = XMLOutputFactory.newInstance();
                xmlWriter = null;
                OutputStreamWriter outStream = new OutputStreamWriter((OutputStream)new FileOutputStream(uri.toFileString()), encoding);
                xmlWriter = xof.createXMLStreamWriter(outStream);
                xmlWriter.writeStartDocument(encoding, "1.0");
                xmlWriter.writeStartElement("rst");
                xmlWriter.writeStartElement("header");
                xmlWriter.writeStartElement("encoding");
                xmlWriter.writeAttribute("name", encoding);
                xmlWriter.writeEndElement();
                xmlWriter.writeStartElement("relations");
                if (rstDocument.getRelations() != null && rstDocument.getRelations().size() > 0) {
                    HashSet<String> nameTypeHash = new HashSet<String>();
                    BasicEList headerRelEntries = new BasicEList();
                    for (Relation relation : rstDocument.getRelations()) {
                        String[] nameType = new String[]{relation.getName(), relation.getType()};
                        if (nameTypeHash.contains(nameType[0])) continue;
                        nameTypeHash.add(nameType[0]);
                        headerRelEntries.add((Object)nameType);
                    }
                    for (String[] relationName : headerRelEntries) {
                        xmlWriter.writeStartElement("rel");
                        xmlWriter.writeAttribute("name", relationName[0]);
                        if (relationName[1] != null) {
                            xmlWriter.writeAttribute("type", relationName[1]);
                        }
                        xmlWriter.writeEndElement();
                    }
                }
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
                xmlWriter.writeStartElement("body");
                if (rstDocument.getSegments() != null) {
                    for (Segment segment : rstDocument.getSegments()) {
                        xmlWriter.writeStartElement("segment");
                        xmlWriter.writeAttribute("id", segment.getId());
                        if (segment.getType() != null) {
                            xmlWriter.writeAttribute("type", segment.getType());
                        }
                        if ((incomingRelations = rstDocument.getIncomingRelations(segment.getId())) != null) {
                            incomingRelation = (Relation)incomingRelations.get(0);
                            if (incomingRelation.getParent() != null) {
                                xmlWriter.writeAttribute("parent", incomingRelation.getParent().getId());
                            }
                            if (incomingRelation.getName() != null) {
                                xmlWriter.writeAttribute("relname", incomingRelation.getName());
                            }
                        }
                        xmlWriter.writeCharacters(segment.getText());
                        xmlWriter.writeEndElement();
                    }
                }
                if (rstDocument.getGroups() != null) {
                    for (Group group : rstDocument.getGroups()) {
                        xmlWriter.writeStartElement("group");
                        xmlWriter.writeAttribute("id", group.getId());
                        if (group.getType() != null) {
                            xmlWriter.writeAttribute("type", group.getType());
                        }
                        if ((incomingRelations = rstDocument.getIncomingRelations(group.getId())) != null) {
                            incomingRelation = (Relation)incomingRelations.get(0);
                            if (incomingRelation.getParent() != null) {
                                xmlWriter.writeAttribute("parent", incomingRelation.getParent().getId());
                            }
                            if (incomingRelation.getName() != null) {
                                xmlWriter.writeAttribute("relname", incomingRelation.getName());
                            }
                        }
                        xmlWriter.writeEndElement();
                    }
                }
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
                xmlWriter.writeEndDocument();
            }
        }
        catch (XMLStreamException e) {
            throw new RSTException("Cannot store data to file '" + uri + "'. ", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RSTException("Cannot store data to file '" + uri + "'. ", e);
        }
        catch (FileNotFoundException e) {
            throw new RSTException("Cannot store data to file '" + uri + "'. ", e);
        }
        finally {
            try {
                xmlWriter.flush();
                xmlWriter.close();
            }
            catch (Exception e) {
                throw new RSTException("Cannot close stream '" + uri + "'. ", e);
            }
        }
    }
}

