/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.rst.resources;

import de.hu_berlin.german.korpling.rst.AbstractNode;
import de.hu_berlin.german.korpling.rst.Group;
import de.hu_berlin.german.korpling.rst.RSTDocument;
import de.hu_berlin.german.korpling.rst.RSTFactory;
import de.hu_berlin.german.korpling.rst.Relation;
import de.hu_berlin.german.korpling.rst.Segment;
import de.hu_berlin.german.korpling.rst.exceptions.RSTException;
import java.io.File;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class RSTReader
extends DefaultHandler2 {
    private File rstFile = null;
    private RSTDocument rstDocument = null;
    private Stack<RSTElements> rstElementStack = null;
    private StringBuffer currentText = null;
    private HashMap<String, String> relNameType = null;
    private HashMap<String, AbstractNode> idAbstractNodeTable = null;
    private HashMap<String, Vector<Relation>> idRelationTable = null;
    private Segment currentSegment = null;

    public RSTReader() {
        this.init();
    }

    private void init() {
        this.idAbstractNodeTable = new HashMap();
        this.idRelationTable = new HashMap();
        this.rstElementStack = new Stack();
        this.relNameType = new HashMap();
    }

    public void setRstFile(File rstFile) {
        this.rstFile = rstFile;
    }

    public File getRstFile() {
        return this.rstFile;
    }

    public void setRSTDocument(RSTDocument rstDocument) {
        this.rstDocument = rstDocument;
    }

    public RSTDocument getRSTDocument() {
        return this.rstDocument;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.rstElementStack.peek().equals((Object)RSTElements.SEGMENT)) {
            if (this.currentSegment == null) {
                throw new RSTException("Cannot add the found text node in file '" + this.getRstFile().getAbsolutePath() + "', because it is not contained in a <segment>-element.");
            }
            if (this.currentText == null) {
                this.currentText = new StringBuffer();
            }
            for (int i = start; i < start + length; ++i) {
                if (ch[i] == '\n') continue;
                this.currentText.append(ch[i]);
            }
        }
    }

    private void addRelation2Table(String id, Relation relation) {
        Vector<Relation> slot = this.idRelationTable.get(id);
        if (slot == null) {
            slot = new Vector();
            this.idRelationTable.put(id, slot);
        }
        slot.add(relation);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("rst")) {
            this.rstElementStack.push(RSTElements.RST);
        } else if (qName.equals("header")) {
            this.rstElementStack.push(RSTElements.HEADER);
        } else if (qName.equals("encoding")) {
            this.rstElementStack.push(RSTElements.ENCODING);
        } else if (qName.equals("relations")) {
            this.rstElementStack.push(RSTElements.RELATIONS);
        } else if (qName.equals("rel")) {
            this.rstElementStack.push(RSTElements.REL);
            String relName = attributes.getValue("name");
            String relType = attributes.getValue("type");
            this.relNameType.put(relName, relType);
        } else if (qName.equals("body")) {
            this.rstElementStack.push(RSTElements.BODY);
        } else if (qName.equals("segment")) {
            this.rstElementStack.push(RSTElements.SEGMENT);
            Segment segment = RSTFactory.eINSTANCE.createSegment();
            segment.setId(attributes.getValue("id"));
            this.getRSTDocument().getSegments().add((Object)segment);
            if (attributes.getValue("type") != null) {
                segment.setType(attributes.getValue("type"));
            }
            this.idAbstractNodeTable.put(attributes.getValue("id"), segment);
            this.currentSegment = segment;
            Vector<Relation> slot = this.idRelationTable.get(attributes.getValue("id"));
            if (slot != null) {
                for (Relation relation : slot) {
                    relation.setParent(segment);
                }
            }
            if (attributes.getValue("parent") != null) {
                AbstractNode parent;
                Relation relation = RSTFactory.eINSTANCE.createRelation();
                relation.setChild(segment);
                this.getRSTDocument().getRelations().add((Object)relation);
                if (attributes.getValue("relname") != null) {
                    String relname = attributes.getValue("relname");
                    relation.setName(relname);
                    if (this.relNameType.containsKey(relname)) {
                        relation.setType(this.relNameType.get(relname));
                    }
                }
                if ((parent = this.idAbstractNodeTable.get(attributes.getValue("parent"))) == null) {
                    this.addRelation2Table(attributes.getValue("parent"), relation);
                } else {
                    relation.setParent(parent);
                }
            }
        } else if (qName.equals("group")) {
            this.rstElementStack.push(RSTElements.GROUP);
            Group group = RSTFactory.eINSTANCE.createGroup();
            group.setId(attributes.getValue("id"));
            this.getRSTDocument().getGroups().add((Object)group);
            if (attributes.getValue("type") != null) {
                group.setType(attributes.getValue("type"));
            }
            this.idAbstractNodeTable.put(attributes.getValue("id"), group);
            Vector<Relation> slot = this.idRelationTable.get(attributes.getValue("id"));
            if (slot != null) {
                for (Relation relation : slot) {
                    relation.setParent(group);
                }
            }
            if (attributes.getValue("parent") != null) {
                AbstractNode parent;
                Relation relation = RSTFactory.eINSTANCE.createRelation();
                this.getRSTDocument().getRelations().add((Object)relation);
                relation.setChild(group);
                if (attributes.getValue("relname") != null) {
                    String relname = attributes.getValue("relname");
                    relation.setName(relname);
                    if (this.relNameType.containsKey(relname)) {
                        relation.setType(this.relNameType.get(relname));
                    }
                }
                if ((parent = this.idAbstractNodeTable.get(attributes.getValue("parent"))) == null) {
                    this.addRelation2Table(attributes.getValue("parent"), relation);
                } else {
                    relation.setParent(parent);
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.rstElementStack.pop();
        if (!qName.equals("body")) {
            if (qName.equals("segment")) {
                if (this.currentText != null) {
                    this.currentSegment.setText(this.currentText.toString());
                }
                this.currentText = null;
                this.currentSegment = null;
            } else if (qName.equals("group")) {
                // empty if block
            }
        }
    }

    public static enum RSTElements {
        RST,
        HEADER,
        ENCODING,
        RELATIONS,
        REL,
        BODY,
        SEGMENT,
        GROUP;

    }
}

