/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.graph.impl.GraphImpl;
import org.corpus_tools.salt.graph.impl.IdentifiableElementImpl;

public class LayerImpl<N extends Node, R extends Relation<N, N>>
extends IdentifiableElementImpl
implements Layer<N, R> {
    private Set<N> nodes = new HashSet<N>();
    private Set<R> relations = new HashSet<R>();
    protected Graph graph = null;

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph graph) {
        if (graph != null) {
            if (graph instanceof GraphImpl) {
                ((GraphImpl)graph).basicAddLayer(this);
            }
        } else if (this.getGraph() instanceof GraphImpl) {
            ((GraphImpl)this.getGraph()).basicRemoveLayer(this);
        }
        this.basicSetGraph(graph);
    }

    protected void basicSetGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Set<N> getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    @Override
    public void addNode(N node) {
        if (this.getGraph() != null && !this.getGraph().containsNode(node.getId())) {
            this.getGraph().addNode(node);
        }
        this.nodes.add(node);
    }

    @Override
    public void removeNode(N node) {
        if (this.nodes != null) {
            this.nodes.remove(node);
        }
    }

    @Override
    public Set<R> getRelations() {
        return Collections.unmodifiableSet(this.relations);
    }

    @Override
    public void addRelation(Relation<? extends Node, ? extends Node> relation) {
        if (this.getGraph() != null && !this.getGraph().containsRelation(relation.getId())) {
            this.getGraph().addRelation(relation);
        }
        this.relations.add(relation);
    }

    @Override
    public void removeRelation(R relation) {
        if (relation != null) {
            this.relations.remove(relation);
        }
    }
}

