/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal.persistence.dot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.exceptions.SaltResourceException;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.util.internal.persistence.dot.DOTEdge;
import org.corpus_tools.salt.util.internal.persistence.dot.DOTNode;
import org.eclipse.emf.common.util.URI;

public class SDocumentGraphDOTWriter
implements GraphTraverseHandler {
    private URI outputURI = null;
    private SDocumentGraph documentGraph = null;
    private PrintStream currOutputStream = null;
    private List<Node> visitedNodes = new ArrayList<Node>();
    private Set<SToken> tokenList;
    private Set<SSpan> spanList = new LinkedHashSet<SSpan>();
    private Set<STimeline> timelineList;
    private Set<SStructure> structureList = new LinkedHashSet<SStructure>();
    private Set<STextualDS> textList = new LinkedHashSet<STextualDS>();
    private Set<SNode> otherNodeList;
    protected static final String KW_DOT_NS = "dot::";
    protected static final String KW_DOT_STORED = "dot::stored";

    public SDocumentGraphDOTWriter() {
        this.timelineList = new LinkedHashSet<STimeline>();
        this.tokenList = new LinkedHashSet<SToken>();
        this.otherNodeList = new LinkedHashSet<SNode>();
    }

    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    public void setDocumentGraph(SDocumentGraph documentGraph) {
        this.documentGraph = documentGraph;
    }

    public SDocumentGraph getDocumentGraph() {
        return this.documentGraph;
    }

    public void save() {
        if (this.outputURI == null) {
            throw new SaltException("Cannot print the given model to dot, because no output file is given.");
        }
        String str = this.getOutputURI().toFileString();
        if (str == null) {
            str = this.getOutputURI().toString();
        }
        File outputFile = new File(str);
        File outputDir = null;
        outputDir = outputFile.getName().contains(".") ? outputFile.getParentFile() : outputFile;
        outputDir.mkdirs();
        try {
            this.currOutputStream = new PrintStream(outputFile, "UTF-8");
        }
        catch (FileNotFoundException e) {
            throw new NullPointerException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new NullPointerException(e.getMessage());
        }
        this.currOutputStream.println("digraph G {");
        this.currOutputStream.println("ordering=out;");
        SDocumentGraph docGraph = this.getDocumentGraph();
        if (docGraph != null) {
            List<SNode> startNodes = docGraph.getRoots();
            if (startNodes == null) {
                startNodes = new ArrayList<SNode>();
                if (this.getDocumentGraph().getTokens() != null && this.getDocumentGraph().getTokens().size() > 0) {
                    startNodes.add(this.getDocumentGraph().getTokens().get(0));
                }
            }
            if (startNodes.size() > 0) {
                docGraph.traverse(startNodes, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "Dot_top_down", this);
            }
            if (this.textList.size() > 0) {
                this.currOutputStream.println("{");
                this.currOutputStream.println("rank=max;");
                for (STextualDS sTextualDS : this.textList) {
                    this.printSTextualDS(sTextualDS);
                }
                this.currOutputStream.println("}");
            }
            if (this.timelineList.size() > 0) {
                this.currOutputStream.println("{");
                this.currOutputStream.println("rank=same;");
                for (STimeline sTimeline : this.timelineList) {
                    this.printSTimeline(sTimeline);
                }
                this.currOutputStream.println("}");
            }
            if (this.tokenList.size() > 0) {
                this.currOutputStream.println("{");
                this.currOutputStream.println("rank=same;");
                for (SToken sToken : this.tokenList) {
                    this.printSToken(sToken);
                }
                this.currOutputStream.println("}");
            }
            if (this.spanList.size() > 0) {
                this.currOutputStream.println("{");
                this.currOutputStream.println("rank=same;");
                for (SSpan sSpan : this.spanList) {
                    this.printSSpan(sSpan);
                }
                this.currOutputStream.println("}");
            }
            for (SStructure sStructure : this.structureList) {
                this.printSStructure(sStructure);
            }
            for (SNode sNode : this.otherNodeList) {
                this.printSNode(sNode);
            }
            if (this.visitedNodes.size() != this.getDocumentGraph().getNodes().size()) {
                ArrayList<SNode> forgottenNodes = new ArrayList<SNode>();
                for (SNode node : this.getDocumentGraph().getNodes()) {
                    if (this.visitedNodes.contains(node)) continue;
                    forgottenNodes.add(node);
                }
                if (forgottenNodes.size() == 0) {
                    throw new SaltResourceException("There are some nodes, which hasn' t been printed because of an unknown reason.");
                }
                docGraph.traverse(forgottenNodes, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "dot_forgotten_nodes", this);
            }
        } else {
            this.currOutputStream.println("<empty>[color= red, style = filled]");
        }
        this.currOutputStream.println("}");
        this.currOutputStream.flush();
        this.currOutputStream.close();
    }

    private String createAnnotations(SAnnotation sAnno) {
        String retStr = null;
        String anno = null;
        if (sAnno.getValue() != null) {
            anno = sAnno.getValue().toString().replace("\"", "\\\"");
            anno = anno.replace("\n", "\\n");
            anno = anno.replace("\r", "\\r");
        }
        retStr = sAnno.getQName() + "=" + anno;
        return retStr;
    }

    @Override
    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
    }

    @Override
    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation<SNode, SNode> relation, SNode currNode, long order) {
        return true;
    }

    private DOTNode getDOTNode(SNode currSNode) {
        DOTNode dotNode = new DOTNode();
        dotNode.id = currSNode.getId();
        if (currSNode.getName() != null) {
            dotNode.labels.add("name= " + currSNode.getName());
        }
        for (SAnnotation sAnno : currSNode.getAnnotations()) {
            dotNode.labels.add(this.createAnnotations(sAnno));
        }
        this.visitedNodes.add(currSNode);
        return dotNode;
    }

    private void printDOTNode(DOTNode dotNode) {
        this.currOutputStream.println(dotNode.toString());
    }

    private void printSTextualDS(STextualDS t) {
        DOTNode dotNode = this.getDOTNode(t);
        dotNode.color = "yellow";
        dotNode.style = "filled";
        dotNode.shape = "Mrecord";
        String text = t.getText();
        if (text != null) {
            text = text.replace("\"", "\\\"");
            text = text.replace("\n", "");
            text = text.replace("\r", "");
        }
        dotNode.labels.add("text=" + text);
        this.printDOTNode(dotNode);
    }

    private void printSToken(SToken currSNode) {
        DOTNode dotNode = this.getDOTNode(currSNode);
        dotNode.color = "turquoise";
        dotNode.style = "filled";
        dotNode.shape = "Mrecord";
        this.printDOTNode(dotNode);
    }

    private void printSTimeline(STimeline currSNode) {
        DOTNode dotNode = this.getDOTNode(currSNode);
        dotNode.color = "gray";
        dotNode.style = "filled";
        dotNode.shape = "Mrecord";
        dotNode.labels.add("time=" + currSNode.getData());
        this.printDOTNode(dotNode);
    }

    private void printSSpan(SSpan currSNode) {
        DOTNode dotNode = this.getDOTNode(currSNode);
        dotNode.color = "dodgerblue3";
        dotNode.style = "filled";
        dotNode.shape = "Mrecord";
        this.printDOTNode(dotNode);
    }

    private void printSStructure(SStructure currSNode) {
        DOTNode dotNode = this.getDOTNode(currSNode);
        dotNode.color = "seagreen";
        dotNode.style = "filled";
        dotNode.shape = "Mrecord";
        this.printDOTNode(dotNode);
    }

    private void printSNode(SNode currSNode) {
        DOTNode dotNode = this.getDOTNode(currSNode);
        dotNode.color = "red";
        dotNode.shape = "Mrecord";
        dotNode.style = "filled";
        this.printDOTNode(dotNode);
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        SNode currSNode = currNode;
        SNode fromSNode = null;
        if (fromNode != null) {
            fromSNode = fromNode;
        }
        if (currSNode instanceof STextualDS) {
            this.textList.add((STextualDS)currSNode);
        } else if (currSNode instanceof STimeline) {
            this.timelineList.add((STimeline)currSNode);
        } else if (currSNode instanceof SToken) {
            this.tokenList.add((SToken)currSNode);
        } else if (currSNode instanceof SSpan) {
            this.spanList.add((SSpan)currSNode);
        } else if (currSNode instanceof SStructure) {
            this.structureList.add((SStructure)currSNode);
        } else {
            this.otherNodeList.add(currSNode);
        }
        if (relation != null) {
            DOTEdge dotEdge = new DOTEdge();
            dotEdge.fromId = fromSNode.getId();
            dotEdge.toId = currSNode.getId();
            String type = relation.getType();
            if (type != null && !type.isEmpty()) {
                dotEdge.labels.add("type= [" + type + "]");
            }
            for (SAnnotation sAnno : relation.getAnnotations()) {
                dotEdge.labels.add(sAnno.getQName() + "= " + sAnno.getValue_STEXT());
            }
            if (relation instanceof STextualRelation) {
                dotEdge.color = "yellow";
                dotEdge.style = "filled";
            } else if (relation instanceof STimelineRelation) {
                dotEdge.color = "gray";
                dotEdge.style = "filled";
            } else if (relation instanceof SSpanningRelation) {
                dotEdge.color = "dodgerblue3";
                dotEdge.style = "filled";
            } else if (relation instanceof SDominanceRelation) {
                dotEdge.color = "seagreen";
                dotEdge.style = "filled";
            } else if (relation instanceof SPointingRelation) {
                dotEdge.color = "blue";
                dotEdge.style = "filled";
            }
            if (relation.getProcessingAnnotation(KW_DOT_STORED) == null) {
                this.currOutputStream.println(dotEdge.toString());
                SProcessingAnnotation spAnno = SaltFactory.createSProcessingAnnotation();
                spAnno.setQName(KW_DOT_STORED);
                relation.addProcessingAnnotation(spAnno);
            }
        }
    }
}

