/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.salt.exceptions.SaltInsertionException;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.LabelableElement;
import org.corpus_tools.salt.graph.impl.LabelImpl;
import org.corpus_tools.salt.util.SaltUtil;

public abstract class LabelableElementImpl
implements LabelableElement,
Serializable {
    public static final int EXPECTED_NUMBER_OF_LABELS = 5;
    private Map<String, Label> labels = null;

    @Override
    public Collection<Label> getLabels() {
        Collection<Label> retVal = null;
        if (this.labels != null) {
            retVal = this.labels.values();
        }
        return retVal;
    }

    @Override
    public Label getLabel(String qName) {
        if (this.labels != null) {
            return this.labels.get(qName);
        }
        return null;
    }

    @Override
    public Label getLabel(String namespace, String name) {
        String qName = SaltUtil.createQName(namespace, name);
        return this.getLabel(qName);
    }

    @Override
    public Set<Label> getLabelsByNamespace(String ns) {
        HashSet<Label> retVal = new HashSet<Label>(5);
        if (this.labels != null) {
            for (Label label : this.labels.values()) {
                if (ns == null) {
                    if (label.getNamespace() != null) continue;
                    retVal.add(label);
                    continue;
                }
                if (!ns.equals(label.getNamespace())) continue;
                retVal.add(label);
            }
        }
        return retVal;
    }

    @Override
    public void addLabel(Label label) {
        if (label != null) {
            if (label instanceof LabelImpl) {
                if (label.getContainer() != null) {
                    label.getContainer().removeLabel(label.getQName());
                }
                ((LabelImpl)label).basicSetLabelableElement(this);
            }
            this.basicAddLabel(label);
        }
    }

    public void basicAddLabel(Label label) {
        if (label != null) {
            String qName;
            if (label.getName() == null || label.getName().isEmpty()) {
                throw new SaltInsertionException(this, label, "Cannot add a label object without a name.");
            }
            if (this.labels == null) {
                this.labels = new HashMap<String, Label>(5);
            }
            if (this.labels.containsKey(qName = SaltUtil.createQName(label.getNamespace(), label.getName()))) {
                if (this instanceof IdentifiableElement) {
                    throw new SaltInsertionException(this, label, " Because an id already exists: " + this.labels.get(qName) + ".");
                }
                throw new SaltInsertionException(this, label, "Cannot add the given label object, because a label with this QName already exists: " + label.getQName());
            }
            this.labels.put(qName, label);
        }
    }

    @Override
    public void removeLabel(String qName) {
        if (qName != null) {
            Label label = this.getLabel(qName);
            if (label instanceof LabelImpl) {
                ((LabelImpl)label).setContainer((LabelableElement)null);
            }
            this.basicRemoveLabel(qName);
        }
    }

    public void basicRemoveLabel(String qName) {
        if (qName != null) {
            this.labels.remove(qName);
        }
    }

    @Override
    public void removeLabel(String namespace, String name) {
        this.removeLabel(SaltUtil.createQName(namespace, name));
    }

    @Override
    public void removeAll() {
        this.labels = new HashMap<String, Label>(5);
    }

    @Override
    public boolean containsLabel(String qName) {
        return this.labels.containsKey(qName);
    }

    @Override
    public Integer sizeLabels() {
        if (this.labels != null) {
            return this.labels.values().size();
        }
        return 0;
    }
}

