/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal.persistence;

import com.ctc.wstx.stax.WstxOutputFactory;
import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.SerializationUtils;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusDocumentRelation;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SCorpusRelation;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SMedialDS;
import org.corpus_tools.salt.common.SMedialRelation;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltResourceException;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.internal.persistence.SaltXML10Dictionary;
import org.eclipse.emf.common.util.URI;

public class SaltXML10Writer
implements SaltXML10Dictionary {
    private boolean isPrettyPrint = true;
    private File path = null;
    private final XMLOutputFactory xmlFactory = new WstxOutputFactory();
    private List<Object> writtenRootObjects = null;

    public SaltXML10Writer() {
        this.path = null;
    }

    public SaltXML10Writer(File path) {
        this.path = path;
    }

    public SaltXML10Writer(URI path) {
        String str;
        if (path != null && (str = path.toFileString()) != null && !str.isEmpty()) {
            this.path = new File(str);
        }
    }

    public void setPrettyPrint(boolean isPrettyPrint) {
        this.isPrettyPrint = isPrettyPrint;
    }

    public File getPath() {
        return this.path;
    }

    private String getLocationStr() {
        if (this.path == null) {
            return "<no-file>";
        }
        return this.path.toString();
    }

    public void writeObjects(XMLStreamWriter xml, Object ... objects) {
        ArrayList<Object> filteredObjects = new ArrayList<Object>(objects.length);
        for (Object o : objects) {
            if (!(o instanceof SaltProject || o instanceof SDocumentGraph || o instanceof SCorpusGraph)) {
                throw new SaltResourceException("Invalid type \"" + o.getClass().getSimpleName() + "\". Root objects " + "must be either of type SaltProject, SDocumentGraph of SCorpusGraph");
            }
            filteredObjects.add(o);
        }
        if (this.writtenRootObjects == null) {
            this.writtenRootObjects = new ArrayList<Object>(filteredObjects.size());
        }
        for (Object e : filteredObjects) {
            if (e instanceof SaltProject) {
                this.writeSaltProject(xml, (SaltProject)e);
            } else if (e instanceof SDocumentGraph) {
                this.writeDocumentGraph(xml, (SDocumentGraph)e);
            } else if (e instanceof SCorpusGraph) {
                this.writeCorpusGraph(xml, (SCorpusGraph)e, true);
            }
            this.writtenRootObjects.add(e);
        }
    }

    public void writeSaltProject(SaltProject project) {
        XMLStreamWriter xml = null;
        try (FileOutputStream output = new FileOutputStream(this.path);){
            xml = this.xmlFactory.createXMLStreamWriter(output, "UTF-8");
            xml.writeStartDocument("1.0");
            if (this.isPrettyPrint) {
                xml.writeCharacters("\n");
            }
            this.writeSaltProject(xml, project);
            xml.writeEndDocument();
        }
        catch (IOException | XMLStreamException e) {
            throw new SaltResourceException("Cannot store salt project to file '" + this.getLocationStr() + "'. ", e);
        }
        finally {
            if (xml != null) {
                try {
                    xml.flush();
                    xml.close();
                }
                catch (XMLStreamException e) {
                    throw new SaltResourceException("Cannot store salt project to file '" + this.getLocationStr() + "', because the opened stream is not closable. ", e);
                }
            }
        }
    }

    public void writeSaltProject(XMLStreamWriter xml, SaltProject project) {
        try {
            xml.writeStartElement("saltCommon", "SaltProject", "saltCommon");
            xml.writeNamespace("sCorpusStructure", "sCorpusStructure");
            xml.writeNamespace("xmi", "http://www.omg.org/XMI");
            xml.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xml.writeNamespace("saltCore", "saltCore");
            xml.writeNamespace("saltCommon", "saltCommon");
            xml.writeAttribute("http://www.omg.org/XMI", "version", "2.0");
            Iterator<SCorpusGraph> cGraphs = project.getCorpusGraphs().iterator();
            while (cGraphs.hasNext()) {
                if (this.isPrettyPrint) {
                    xml.writeCharacters("\n");
                    xml.writeCharacters("\t");
                }
                this.writeCorpusGraph(xml, cGraphs.next(), true);
            }
            if (this.isPrettyPrint) {
                xml.writeCharacters("\n");
            }
            xml.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SaltResourceException("Cannot store salt project to file '" + this.getLocationStr() + "'. ", e);
        }
    }

    public void writeCorpusGraph(XMLStreamWriter xml, SCorpusGraph graph, boolean embedded) {
        try {
            if (!embedded) {
                xml.writeStartDocument("1.0");
                if (this.isPrettyPrint) {
                    xml.writeCharacters("\n");
                    xml.writeStartElement("saltCommon", "sCorpusGraphs", "saltCommon");
                    xml.writeNamespace("sCorpusStructure", "sCorpusStructure");
                    xml.writeNamespace("xmi", "http://www.omg.org/XMI");
                    xml.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    xml.writeNamespace("saltCore", "saltCore");
                    xml.writeNamespace("saltCommon", "saltCommon");
                    xml.writeAttribute("http://www.omg.org/XMI", "version", "2.0");
                }
            } else {
                xml.writeStartElement("sCorpusGraphs");
            }
            if (graph.getLabels() != null) {
                Iterator<Label> labelIt = graph.getLabels().iterator();
                while (labelIt.hasNext()) {
                    if (this.isPrettyPrint) {
                        xml.writeCharacters("\n");
                        xml.writeCharacters("\t");
                    }
                    this.writeLabel(xml, labelIt.next());
                }
            }
            HashMap<SNode, Integer> nodePositions = new HashMap<SNode, Integer>();
            if (graph.getNodes() != null) {
                Iterator nodeIt = graph.getNodes().iterator();
                Integer position = 0;
                while (nodeIt.hasNext()) {
                    SNode node = (SNode)nodeIt.next();
                    this.writeNode(xml, node, null);
                    nodePositions.put(node, position);
                    Integer n = position;
                    Integer n2 = position = Integer.valueOf(position + 1);
                }
            }
            if (graph.getRelations() != null) {
                for (SRelation rel : graph.getRelations()) {
                    this.writeRelation(xml, rel, nodePositions, null);
                }
            }
            if (this.isPrettyPrint) {
                xml.writeCharacters("\n");
                xml.writeCharacters("\t");
            }
            xml.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SaltResourceException("Cannot store salt project to file '" + this.getLocationStr() + "'. " + e.getMessage(), e);
        }
        finally {
            if (!embedded && xml != null) {
                try {
                    xml.flush();
                    xml.close();
                }
                catch (XMLStreamException e) {
                    throw new SaltResourceException("Cannot store salt project to file '" + this.getLocationStr() + "', because the opened stream is not closable. ", e);
                }
            }
        }
    }

    public void writeDocumentGraph(SDocumentGraph graph) {
        XMLStreamWriter xml = null;
        try (FileOutputStream output = new FileOutputStream(this.path);){
            xml = this.xmlFactory.createXMLStreamWriter(output, "UTF-8");
            xml.writeStartDocument("1.0");
            if (this.isPrettyPrint) {
                xml.writeCharacters("\n");
            }
            this.writeDocumentGraph(xml, graph);
            xml.writeEndDocument();
        }
        catch (IOException | XMLStreamException e) {
            throw new SaltResourceException("Cannot store document graph to file '" + this.getLocationStr() + "'. ", e);
        }
        finally {
            if (xml != null) {
                try {
                    xml.flush();
                    xml.close();
                }
                catch (XMLStreamException e) {
                    throw new SaltResourceException("Cannot store document graph to file '" + this.getLocationStr() + "', because the opened stream is not closable. ", e);
                }
            }
        }
    }

    public void writeDocumentGraph(XMLStreamWriter xml, SDocumentGraph graph) {
        try {
            xml.writeStartElement("sDocumentStructure", "SDocumentGraph", "sDocumentStructure");
            xml.writeNamespace("sDocumentStructure", "sDocumentStructure");
            xml.writeNamespace("xmi", "http://www.omg.org/XMI");
            xml.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xml.writeNamespace("saltCore", "saltCore");
            xml.writeAttribute("http://www.omg.org/XMI", "version", "2.0");
            Iterator<Label> labelIt = graph.getLabels().iterator();
            while (labelIt.hasNext()) {
                if (this.isPrettyPrint) {
                    xml.writeCharacters("\n");
                    xml.writeCharacters("\t");
                }
                this.writeLabel(xml, labelIt.next());
            }
            HashMap layerPositions = new HashMap();
            Iterator layerIt = graph.getLayers().iterator();
            Integer position = 0;
            while (layerIt.hasNext()) {
                layerPositions.put(layerIt.next(), position);
                Integer n = position;
                Integer n2 = position = Integer.valueOf(position + 1);
            }
            HashMap<SNode, Integer> nodePositions = new HashMap<SNode, Integer>();
            Iterator nodeIt = graph.getNodes().iterator();
            position = 0;
            while (nodeIt.hasNext()) {
                SNode node = (SNode)nodeIt.next();
                this.writeNode(xml, node, layerPositions);
                nodePositions.put(node, position);
                Integer n = position;
                Integer n3 = position = Integer.valueOf(position + 1);
            }
            HashMap<SRelation<SNode, SNode>, Integer> relPositions = new HashMap<SRelation<SNode, SNode>, Integer>();
            Iterator relIt = graph.getRelations().iterator();
            position = 0;
            while (relIt.hasNext()) {
                SRelation rel = (SRelation)relIt.next();
                this.writeRelation(xml, rel, nodePositions, layerPositions);
                relPositions.put(rel, position);
                Integer n = position;
                Integer n4 = position = Integer.valueOf(position + 1);
            }
            layerIt = graph.getLayers().iterator();
            while (layerIt.hasNext()) {
                this.writeLayer(xml, (Layer)layerIt.next(), nodePositions, relPositions);
            }
            if (this.isPrettyPrint) {
                xml.writeCharacters("\n");
            }
            xml.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SaltResourceException("Cannot store document graph to file '" + this.getLocationStr() + "'. ", e);
        }
    }

    public void writeLabel(XMLStreamWriter xml, Label label) throws XMLStreamException {
        if (label != null && (label.getValue() instanceof SDocument || label.getValue() instanceof SDocumentGraph)) {
            return;
        }
        xml.writeEmptyElement("labels");
        if (label != null) {
            String type = "";
            if (label instanceof SAnnotation) {
                type = "saltCore:SAnnotation";
            } else if (label instanceof SMetaAnnotation) {
                type = "saltCore:SMetaAnnotation";
            } else if (label instanceof SProcessingAnnotation) {
                type = "saltCore:SProcessingAnnotation";
            } else if (label instanceof SFeature) {
                type = "saltCore:SFeature";
            } else if (label instanceof Identifier) {
                type = "saltCore:SElementId";
            }
            xml.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", type);
            if (label.getNamespace() != null && !label.getNamespace().isEmpty()) {
                if ("SDATA".equals(label.getName())) {
                    xml.writeAttribute("namespace", "saltCommon");
                } else {
                    xml.writeAttribute("namespace", label.getNamespace());
                }
            }
            if (label.getName() != null && !label.getName().isEmpty()) {
                xml.writeAttribute("name", label.getName());
            }
            if (label.getValue() != null) {
                xml.writeAttribute("value", this.marshallValue(label.getValue()));
            }
        }
    }

    public String marshallValue(Object value) {
        String retVal = null;
        if (value != null) {
            if (value instanceof String) {
                retVal = "T::" + (String)value;
            } else if (value instanceof Boolean) {
                retVal = "B::" + value.toString();
            } else if (value instanceof Integer) {
                retVal = "N::" + value.toString();
            } else if (value instanceof Long) {
                retVal = "N::" + value.toString();
            } else if (value instanceof Double) {
                retVal = "F::" + value.toString();
            } else if (value instanceof Float) {
                retVal = "F::" + value.toString();
            } else if (value instanceof URI) {
                retVal = "U::" + value.toString();
            } else if (value instanceof Serializable) {
                byte[] rawBytes = SerializationUtils.serialize((Serializable)((Serializable)value));
                retVal = "O::" + BaseEncoding.base64().encode(rawBytes);
            }
        }
        return retVal;
    }

    public void writeNode(XMLStreamWriter xml, Node node, Map<? extends Layer, Integer> layerPositions) throws XMLStreamException {
        if (this.isPrettyPrint) {
            xml.writeCharacters("\n");
            xml.writeCharacters("\t");
        }
        xml.writeStartElement("nodes");
        String type = "";
        if (node instanceof STextualDS) {
            type = "sDocumentStructure:STextualDS";
        } else if (node instanceof STimeline) {
            type = "sDocumentStructure:STimeline";
        } else if (node instanceof SMedialDS) {
            type = "sDocumentStructure:SAudioDS";
        } else if (node instanceof SToken) {
            type = "sDocumentStructure:SToken";
        } else if (node instanceof SSpan) {
            type = "sDocumentStructure:SSpan";
        } else if (node instanceof SStructure) {
            type = "sDocumentStructure:SStructure";
        } else if (node instanceof SDocument) {
            type = "sCorpusStructure:SDocument";
        } else if (node instanceof SCorpus) {
            type = "sCorpusStructure:SCorpus";
        }
        xml.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", type);
        if (node.getLayers().size() > 0) {
            StringBuilder layerAtt = new StringBuilder();
            Iterator<? extends Layer> layerIt = node.getLayers().iterator();
            boolean isFirst = true;
            while (layerIt.hasNext()) {
                if (!isFirst) {
                    layerAtt.append(" ");
                }
                isFirst = false;
                layerAtt.append("/");
                if (this.writtenRootObjects != null) {
                    layerAtt.append(this.writtenRootObjects.size());
                }
                layerAtt.append("/@layers.");
                layerAtt.append(layerPositions.get(layerIt.next()));
            }
            xml.writeAttribute("layers", layerAtt.toString());
        }
        Iterator<Label> labelIt = node.getLabels().iterator();
        while (labelIt.hasNext()) {
            if (this.isPrettyPrint) {
                xml.writeCharacters("\n");
                xml.writeCharacters("\t");
                xml.writeCharacters("\t");
            }
            this.writeLabel(xml, labelIt.next());
        }
        if (this.isPrettyPrint) {
            xml.writeCharacters("\n");
            xml.writeCharacters("\t");
        }
        xml.writeEndElement();
    }

    public void writeRelation(XMLStreamWriter xml, Relation relation, Map<? extends Node, Integer> nodePositions, Map<? extends Layer, Integer> layerPositions) throws XMLStreamException {
        if (this.isPrettyPrint) {
            xml.writeCharacters("\n");
            xml.writeCharacters("\t");
        }
        xml.writeStartElement("edges");
        String type = "";
        if (relation instanceof STextualRelation) {
            type = "sDocumentStructure:STextualRelation";
        } else if (relation instanceof STimelineRelation) {
            type = "sDocumentStructure:STimelineRelation";
        } else if (relation instanceof SMedialRelation) {
            type = "sDocumentStructure:SAudioRelation";
        } else if (relation instanceof SSpanningRelation) {
            type = "sDocumentStructure:SSpanningRelation";
        } else if (relation instanceof SDominanceRelation) {
            type = "sDocumentStructure:SDominanceRelation";
        } else if (relation instanceof SPointingRelation) {
            type = "sDocumentStructure:SPointingRelation";
        } else if (relation instanceof SOrderRelation) {
            type = "sDocumentStructure:SOrderRelation";
        } else if (relation instanceof SCorpusRelation) {
            type = "sCorpusStructure:SCorpusRelation";
        } else if (relation instanceof SCorpusDocumentRelation) {
            type = "sCorpusStructure:SCorpusDocumentRelation";
        }
        xml.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", type);
        int sourcePos = nodePositions.get(relation.getSource());
        int targetPos = nodePositions.get(relation.getTarget());
        if (this.writtenRootObjects == null) {
            xml.writeAttribute("source", "//@nodes." + sourcePos);
            xml.writeAttribute("target", "//@nodes." + targetPos);
        } else {
            int rootIndex = this.writtenRootObjects.size();
            xml.writeAttribute("source", "/" + rootIndex + "/@nodes." + sourcePos);
            xml.writeAttribute("target", "/" + rootIndex + "/@nodes." + targetPos);
        }
        if (relation.getLayers().size() > 0) {
            StringBuilder layerAtt = new StringBuilder();
            Iterator<Layer> layerIt = relation.getLayers().iterator();
            boolean isFirst = true;
            while (layerIt.hasNext()) {
                if (!isFirst) {
                    layerAtt.append(" ");
                }
                isFirst = false;
                layerAtt.append("/");
                if (this.writtenRootObjects != null) {
                    layerAtt.append(this.writtenRootObjects.size());
                }
                layerAtt.append("/@layers.");
                layerAtt.append(layerPositions.get(layerIt.next()));
            }
            xml.writeAttribute("layers", layerAtt.toString());
        }
        Iterator<Label> labelIt = relation.getLabels().iterator();
        while (labelIt.hasNext()) {
            if (this.isPrettyPrint) {
                xml.writeCharacters("\n");
                xml.writeCharacters("\t");
                xml.writeCharacters("\t");
            }
            this.writeLabel(xml, labelIt.next());
        }
        if (this.isPrettyPrint) {
            xml.writeCharacters("\n");
            xml.writeCharacters("\t");
        }
        xml.writeEndElement();
    }

    public void writeLayer(XMLStreamWriter xml, Layer layer, Map<SNode, Integer> nodePositions, Map<SRelation<SNode, SNode>, Integer> relPositions) throws XMLStreamException {
        boolean isFirst;
        if (this.isPrettyPrint) {
            xml.writeCharacters("\n");
            xml.writeCharacters("\t");
        }
        xml.writeStartElement("layers");
        xml.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "saltCore:SLayer");
        if (layer.getNodes().size() > 0) {
            StringBuilder nodeAtt = new StringBuilder();
            Iterator nodeIt = layer.getNodes().iterator();
            isFirst = true;
            while (nodeIt.hasNext()) {
                if (!isFirst) {
                    nodeAtt.append(" ");
                }
                isFirst = false;
                nodeAtt.append("/");
                if (this.writtenRootObjects != null) {
                    nodeAtt.append(this.writtenRootObjects.size());
                }
                nodeAtt.append("/@nodes.");
                nodeAtt.append(nodePositions.get(nodeIt.next()));
            }
            xml.writeAttribute("nodes", nodeAtt.toString());
        }
        if (layer.getRelations().size() > 0) {
            StringBuilder relAtt = new StringBuilder();
            Iterator relIt = layer.getRelations().iterator();
            isFirst = true;
            while (relIt.hasNext()) {
                if (!isFirst) {
                    relAtt.append(" ");
                }
                isFirst = false;
                relAtt.append("//@edges.");
                relAtt.append(relPositions.get(relIt.next()));
            }
            xml.writeAttribute("edges", relAtt.toString());
        }
        Iterator<Label> labelIt = layer.getLabels().iterator();
        while (labelIt.hasNext()) {
            if (this.isPrettyPrint) {
                xml.writeCharacters("\n");
                xml.writeCharacters("\t");
                xml.writeCharacters("\t");
            }
            this.writeLabel(xml, labelIt.next());
        }
        if (this.isPrettyPrint) {
            xml.writeCharacters("\n");
            xml.writeCharacters("\t");
        }
        xml.writeEndElement();
    }

    public void writeXMIRootElement(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeStartElement("xmi", "XMI", "http://www.omg.org/XMI");
        xml.writeNamespace("sDocumentStructure", "sDocumentStructure");
        xml.writeNamespace("xmi", "http://www.omg.org/XMI");
        xml.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xml.writeNamespace("saltCore", "saltCore");
        xml.writeAttribute("http://www.omg.org/XMI", "version", "2.0");
        if (this.isPrettyPrint) {
            xml.writeCharacters("\n");
        }
    }
}

