/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.core.impl;

import java.util.Iterator;
import java.util.Set;
import org.corpus_tools.salt.SDATATYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.core.SAbstractAnnotation;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.graph.impl.LabelImpl;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.SAnnotationContainerHelper;
import org.eclipse.emf.common.util.URI;

public abstract class SAbstractAnnotationImpl
extends LabelImpl
implements SAbstractAnnotation,
SAnnotationContainer {
    protected SDATATYPE computeSValueType() {
        if (this.getValue() == null) {
            return SDATATYPE.SOBJECT;
        }
        if (this.getValue() instanceof String) {
            return SDATATYPE.STEXT;
        }
        if (this.getValue() instanceof Boolean) {
            return SDATATYPE.SBOOLEAN;
        }
        if (this.getValue() instanceof Integer) {
            return SDATATYPE.SNUMERIC;
        }
        if (this.getValue() instanceof Long) {
            return SDATATYPE.SNUMERIC;
        }
        if (this.getValue() instanceof Float) {
            return SDATATYPE.SFLOAT;
        }
        if (this.getValue() instanceof Double) {
            return SDATATYPE.SFLOAT;
        }
        if (this.getValue() instanceof URI) {
            return SDATATYPE.SURI;
        }
        return SDATATYPE.SOBJECT;
    }

    @Override
    public SDATATYPE getValueType() {
        SDATATYPE retVal = null;
        SFeature feature = this.getFeature("SVAL_TYPE");
        if (feature != null) {
            if (feature.getValue() == null && this.getValue() != null) {
                feature.setValue((Object)this.computeSValueType());
            }
            retVal = SDATATYPE.valueOf(feature.getValue().toString());
        } else {
            retVal = this.computeSValueType();
        }
        return retVal;
    }

    @Override
    public void setValueType(SDATATYPE newSValueType) {
        SFeature feature = this.getFeature("SVAL_TYPE");
        if (feature == null) {
            feature = SaltFactory.createSFeature();
            feature.setQName("SVAL_TYPE");
            this.addFeature(feature);
        }
        if (newSValueType == null) {
            feature.setValue(null);
        } else {
            feature.setValue(newSValueType.toString());
        }
    }

    @Override
    public String getValue_STEXT() {
        String retVal = null;
        if (this.getValue() != null) {
            retVal = this.getValue() instanceof String ? (String)this.getValue() : this.getValue().toString();
        }
        return retVal;
    }

    @Override
    public Boolean getValue_SBOOLEAN() {
        Boolean retVal = null;
        if (this.getValueType() == SDATATYPE.SBOOLEAN && this.getValue() instanceof Boolean) {
            retVal = (Boolean)this.getValue();
        }
        return retVal;
    }

    @Override
    public Long getValue_SNUMERIC() {
        Long retVal = null;
        if (this.getValueType() == SDATATYPE.SNUMERIC) {
            if (this.getValue() instanceof Integer) {
                retVal = ((Integer)this.getValue()).longValue();
            } else if (this.getValue() instanceof Long) {
                retVal = (Long)this.getValue();
            }
        }
        return retVal;
    }

    @Override
    public Double getValue_SFLOAT() {
        Double retVal = null;
        if (this.getValueType() == SDATATYPE.SFLOAT) {
            if (this.getValue() instanceof Double) {
                retVal = (Double)this.getValue();
            } else if (this.getValue() instanceof Float) {
                retVal = ((Float)this.getValue()).doubleValue();
            }
        }
        return retVal;
    }

    @Override
    public URI getValue_SURI() {
        URI retVal = null;
        if (this.getValueType() == SDATATYPE.SURI && this.getValue() instanceof URI) {
            retVal = (URI)this.getValue();
        }
        return retVal;
    }

    @Override
    public Object getValue_SOBJECT() {
        return this.getValue();
    }

    @Override
    public SAnnotation createAnnotation(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createAnnotation(this, namespace, name, value);
    }

    public Set<SAnnotation> createAnnotations(String annotationString) {
        return SAnnotationContainerHelper.createAnnotations(this, annotationString);
    }

    @Override
    public void addAnnotation(SAnnotation annotation) {
        SAnnotationContainerHelper.addAnnotation(this, annotation);
    }

    @Override
    public <A extends SAnnotation> Set<A> getAnnotations() {
        return SAnnotationContainerHelper.getAnnotations(this);
    }

    @Override
    public SAnnotation getAnnotation(String qName) {
        return SAnnotationContainerHelper.getAnnotation(this, qName);
    }

    @Override
    public SAnnotation getAnnotation(String namespace, String name) {
        return SAnnotationContainerHelper.getAnnotation(this, SaltUtil.createQName(namespace, name));
    }

    @Override
    public Iterator<SAnnotation> iterator_SAnnotation() {
        return SAnnotationContainerHelper.iterator_SAnnotation(this);
    }

    @Override
    public void addMetaAnnotation(SMetaAnnotation metaAnnotation) {
        SAnnotationContainerHelper.addMetaAnnotation(this, metaAnnotation);
    }

    @Override
    public SMetaAnnotation createMetaAnnotation(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createMetaAnnotation(this, namespace, name, value);
    }

    public Set<SMetaAnnotation> createMetaAnnotations(String annotationString) {
        return SAnnotationContainerHelper.createMetaAnnotations(this, annotationString);
    }

    @Override
    public <A extends SMetaAnnotation> Set<A> getMetaAnnotations() {
        return SAnnotationContainerHelper.getMetaAnnotations(this);
    }

    @Override
    public SMetaAnnotation getMetaAnnotation(String qName) {
        return SAnnotationContainerHelper.getMetaAnnotation(this, qName);
    }

    @Override
    public Iterator<SMetaAnnotation> iterator_SMetaAnnotation() {
        return SAnnotationContainerHelper.iterator_SMetaAnnotation(this);
    }

    @Override
    public SProcessingAnnotation createProcessingAnnotation(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createProcessingAnnotation(this, namespace, name, value);
    }

    public Set<SProcessingAnnotation> createProcessingAnnotations(String annotationString) {
        return SAnnotationContainerHelper.createProcessingAnnotations(this, annotationString);
    }

    @Override
    public void addProcessingAnnotation(SProcessingAnnotation annotation) {
        SAnnotationContainerHelper.addProcessingAnnotation(this, annotation);
    }

    @Override
    public <A extends SProcessingAnnotation> Set<A> getProcessingAnnotations() {
        return SAnnotationContainerHelper.getProcessingAnnotations(this);
    }

    @Override
    public SProcessingAnnotation getProcessingAnnotation(String qName) {
        return SAnnotationContainerHelper.getProcessingAnnotation(this, qName);
    }

    @Override
    public Iterator<SProcessingAnnotation> iterator_SProcessingAnnotation() {
        return SAnnotationContainerHelper.iterator_SProcessingAnnotation(this);
    }

    @Override
    public SFeature createFeature(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createFeature(this, namespace, name, value);
    }

    public Set<SFeature> createFeatures(String featureString) {
        return SAnnotationContainerHelper.createFeatures(this, featureString);
    }

    @Override
    public void addFeature(SFeature feature) {
        SAnnotationContainerHelper.addFeature(this, feature);
    }

    @Override
    public <A extends SFeature> Set<A> getFeatures() {
        return SAnnotationContainerHelper.getFeatures(this);
    }

    @Override
    public SFeature getFeature(String qName) {
        return SAnnotationContainerHelper.getFeature(this, qName);
    }

    @Override
    public SFeature getFeature(String namespace, String name) {
        return SAnnotationContainerHelper.getFeature(this, SaltUtil.createQName(namespace, name));
    }

    @Override
    public Iterator<SFeature> iterator_SFeature() {
        return SAnnotationContainerHelper.iterator_SFeature(this);
    }
}

