/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import org.corpus_tools.salt.graph.GraphFactory;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.impl.LabelableElementImpl;

public abstract class IdentifiableElementImpl
extends LabelableElementImpl
implements IdentifiableElement {
    private Identifier identifier = null;

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(Identifier identifier) {
        if (identifier != null) {
            if (this.getIdentifier() != null) {
                this.removeLabel("salt", "id");
            }
            this.identifier = identifier;
            this.addLabel(identifier);
        }
    }

    @Override
    public void removeLabel(String qName) {
        if ("salt::id".equals(qName)) {
            this.identifier = null;
        }
        super.removeLabel(qName);
    }

    @Override
    public String getId() {
        if (this.getIdentifier() != null) {
            return this.getIdentifier().getId();
        }
        return null;
    }

    @Override
    public void setId(String id) {
        if (id != null && !id.isEmpty()) {
            GraphFactory.createIdentifier(this, id);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName());
        str.append("(");
        str.append(this.getId());
        str.append(")");
        if (this.getLabels() != null && this.getLabels().size() > 0) {
            str.append("[");
            boolean isFirst = true;
            for (Label label : this.getLabels()) {
                if (!(label instanceof Identifier)) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        str.append(", ");
                    }
                    str.append(label);
                }
                str.append("]");
            }
        }
        return str.toString();
    }
}

